.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH omap  __drivermansuffix__ __vendorversion__
.SH NAME
omap \- OMAP SoC graphics
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qomap\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B omap
is an __xservername__ driver for OMAP SoCs.
.SH SUPPORTED HARDWARE
.B omap
supports the OMAP3430, OMAP3630, OMAP4430, OMAP4460

.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
TODO
.PP
The following driver
.B Options
are supported
.TP
.BI "Option \*qDebug\*q \*q" boolean \*q
Enable debug logging.
.IP
Default: Disabled
.TP
.BI "Option \*qDRI\*q \*q" boolean \*q
Enable DRI2.
.IP
Default: Enabled
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable hw acceleration.
.IP
Default: Disabled
.TP
.BI "Option \*qHWcursor\*q \*q" boolean \*q
Enable HW mouse cursor.
.IP
Default: Enabled

.SH OUTPUT CONFIGURATION
The driver supports runtime configuration of detected outputs.  You can use the
.B xrandr
tool to control outputs on the command line as follows:

.RS
.B xrandr \-\-output
.I output
.B \-\-set
.I property value
.RE

Note that you may need to quote property and value arguments that contain spaces.
Each output listed below may have one or more properties associated
with it (like a binary EDID block if one is found).  Some outputs have
unique properties which are described below.  See the "MULTIHEAD
CONFIGURATIONS" section below for additional information.

TODO

.PP
See __xconfigfile__(__filemansuffix__) for information on associating Monitor
sections with these outputs for configuration.  Associating Monitor sections
with each output can be helpful if you need to ignore a specific output, for
example, or statically configure an extended desktop monitor layout.

.SH MULTIHEAD CONFIGURATIONS

The number of independent outputs is dictated by the number of CRTCs
(in X parlance) a given chip supports.  OMAP3xxx supports up to two,
while OMAP4xxx supports up to three displays.  The actual number of
displays supported will depend on the board.  But a built-in LCD and
external HDMI are a common configuration. 

You can use the "xrandr" tool, or various desktop utilities, to change
your output configuration at runtime.  To statically configure your
outputs, you can use the "Monitor-<type>" options along with
additional monitor sections in your xorg.conf to create your screen
topology.  The example below puts the VGA output to the right of the
builtin laptop screen, both running at 1024x768.

.nf
.B "Section \*qMonitor\*q"
.BI "  Identifier \*qLaptop FooBar Internal Display\*q"
.BI "  Option \*qPosition\*q \*q0 0\*q"
.B "EndSection"

.B "Section \*qMonitor\*q"
.BI "  Identifier \*qSome Random CRT\*q"
.BI "  Option \*qPosition\*q \*q1024 0\*q"
.BI "  Option \*qRightOf\*q \*qLaptop FoodBar Internal Display\*q"
.B "EndSection"

.B "Section \*qDevice\*q"
.BI "  Driver \*qomap\*q"
.BI "  Option \*qmonitor-LVDS\*q \*qLaptop FooBar Internal Display\*q"
.BI "  Option \*qmonitor-VGA\*q \*qSome Random CRT\*q"
.B "EndSection"
        
.SH REPORTING BUGS

The xf86-video-omap driver is part of the X.Org and Freedesktop.org
umbrella projects.  Report bugs at
https://bugs.freedesktop.org/enter_bug.cgi?product=xorg.  Mailing
lists are also commonly used to report experiences and ask questions
about configuration and other topics.  See lists.freedesktop.org for
more information (the xorg@lists.freedesktop.org mailing list is the
most appropriate place to ask X.Org and driver related questions).

.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include: Ian Elliott, Rob Clark.
