/* This file is generated by venus-protocol git-e05ae158. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_PIPELINE_H
#define VN_PROTOCOL_RENDERER_PIPELINE_H

#include "vn_protocol_renderer_structs.h"

/* struct VkSpecializationMapEntry */

static inline void
vn_decode_VkSpecializationMapEntry_temp(struct vn_cs_decoder *dec, VkSpecializationMapEntry *val)
{
    vn_decode_uint32_t(dec, &val->constantID);
    vn_decode_uint32_t(dec, &val->offset);
    vn_decode_size_t(dec, &val->size);
}

static inline void
vn_replace_VkSpecializationMapEntry_handle(VkSpecializationMapEntry *val)
{
    /* skip val->constantID */
    /* skip val->offset */
    /* skip val->size */
}

/* struct VkSpecializationInfo */

static inline void
vn_decode_VkSpecializationInfo_temp(struct vn_cs_decoder *dec, VkSpecializationInfo *val)
{
    vn_decode_uint32_t(dec, &val->mapEntryCount);
    if (vn_peek_array_size(dec)) {
        val->pMapEntries = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pMapEntries) * val->mapEntryCount);
        if (!val->pMapEntries) return;
        vn_decode_array_size(dec, val->mapEntryCount);
        for (uint32_t i = 0; i < val->mapEntryCount; i++)
            vn_decode_VkSpecializationMapEntry_temp(dec, &((VkSpecializationMapEntry *)val->pMapEntries)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pMapEntries = NULL;
    }
    vn_decode_size_t(dec, &val->dataSize);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->dataSize);
        val->pData = vn_cs_decoder_alloc_temp(dec, array_size);
        if (!val->pData) return;
        vn_decode_blob_array(dec, (void *)val->pData, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pData = NULL;
    }
}

static inline void
vn_replace_VkSpecializationInfo_handle(VkSpecializationInfo *val)
{
    /* skip val->mapEntryCount */
    if (val->pMapEntries) {
       for (uint32_t i = 0; i < val->mapEntryCount; i++)
            vn_replace_VkSpecializationMapEntry_handle(&((VkSpecializationMapEntry *)val->pMapEntries)[i]);
    }
    /* skip val->dataSize */
    /* skip val->pData */
}

/* struct VkPipelineShaderStageCreateInfo chain */

static inline void *
vn_decode_VkPipelineShaderStageCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineShaderStageCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineShaderStageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkShaderStageFlagBits(dec, &val->stage);
    vn_decode_VkShaderModule_lookup(dec, &val->module);
    if (vn_peek_array_size(dec)) {
        const size_t string_size = vn_decode_array_size(dec, UINT64_MAX);
        val->pName = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pName) * string_size);
        if (!val->pName) return;
        vn_decode_blob_array(dec, (char *)val->pName, string_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pName = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pSpecializationInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSpecializationInfo));
        if (!val->pSpecializationInfo) return;
        vn_decode_VkSpecializationInfo_temp(dec, (VkSpecializationInfo *)val->pSpecializationInfo);
    } else {
        val->pSpecializationInfo = NULL;
    }
}

static inline void
vn_decode_VkPipelineShaderStageCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineShaderStageCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineShaderStageCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineShaderStageCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineShaderStageCreateInfo_handle_self(VkPipelineShaderStageCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->stage */
    vn_replace_VkShaderModule_handle(&val->module);
    /* skip val->pName */
    if (val->pSpecializationInfo)
        vn_replace_VkSpecializationInfo_handle((VkSpecializationInfo *)val->pSpecializationInfo);
}

static inline void
vn_replace_VkPipelineShaderStageCreateInfo_handle(VkPipelineShaderStageCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO:
            vn_replace_VkPipelineShaderStageCreateInfo_handle_self((VkPipelineShaderStageCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkVertexInputBindingDescription */

static inline void
vn_decode_VkVertexInputBindingDescription_temp(struct vn_cs_decoder *dec, VkVertexInputBindingDescription *val)
{
    vn_decode_uint32_t(dec, &val->binding);
    vn_decode_uint32_t(dec, &val->stride);
    vn_decode_VkVertexInputRate(dec, &val->inputRate);
}

static inline void
vn_replace_VkVertexInputBindingDescription_handle(VkVertexInputBindingDescription *val)
{
    /* skip val->binding */
    /* skip val->stride */
    /* skip val->inputRate */
}

/* struct VkVertexInputAttributeDescription */

static inline void
vn_decode_VkVertexInputAttributeDescription_temp(struct vn_cs_decoder *dec, VkVertexInputAttributeDescription *val)
{
    vn_decode_uint32_t(dec, &val->location);
    vn_decode_uint32_t(dec, &val->binding);
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_uint32_t(dec, &val->offset);
}

static inline void
vn_replace_VkVertexInputAttributeDescription_handle(VkVertexInputAttributeDescription *val)
{
    /* skip val->location */
    /* skip val->binding */
    /* skip val->format */
    /* skip val->offset */
}

/* struct VkPipelineVertexInputStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineVertexInputStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineVertexInputStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineVertexInputStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->vertexBindingDescriptionCount);
    if (vn_peek_array_size(dec)) {
        val->pVertexBindingDescriptions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pVertexBindingDescriptions) * val->vertexBindingDescriptionCount);
        if (!val->pVertexBindingDescriptions) return;
        vn_decode_array_size(dec, val->vertexBindingDescriptionCount);
        for (uint32_t i = 0; i < val->vertexBindingDescriptionCount; i++)
            vn_decode_VkVertexInputBindingDescription_temp(dec, &((VkVertexInputBindingDescription *)val->pVertexBindingDescriptions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pVertexBindingDescriptions = NULL;
    }
    vn_decode_uint32_t(dec, &val->vertexAttributeDescriptionCount);
    if (vn_peek_array_size(dec)) {
        val->pVertexAttributeDescriptions = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pVertexAttributeDescriptions) * val->vertexAttributeDescriptionCount);
        if (!val->pVertexAttributeDescriptions) return;
        vn_decode_array_size(dec, val->vertexAttributeDescriptionCount);
        for (uint32_t i = 0; i < val->vertexAttributeDescriptionCount; i++)
            vn_decode_VkVertexInputAttributeDescription_temp(dec, &((VkVertexInputAttributeDescription *)val->pVertexAttributeDescriptions)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pVertexAttributeDescriptions = NULL;
    }
}

static inline void
vn_decode_VkPipelineVertexInputStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineVertexInputStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineVertexInputStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineVertexInputStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineVertexInputStateCreateInfo_handle_self(VkPipelineVertexInputStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->vertexBindingDescriptionCount */
    if (val->pVertexBindingDescriptions) {
       for (uint32_t i = 0; i < val->vertexBindingDescriptionCount; i++)
            vn_replace_VkVertexInputBindingDescription_handle(&((VkVertexInputBindingDescription *)val->pVertexBindingDescriptions)[i]);
    }
    /* skip val->vertexAttributeDescriptionCount */
    if (val->pVertexAttributeDescriptions) {
       for (uint32_t i = 0; i < val->vertexAttributeDescriptionCount; i++)
            vn_replace_VkVertexInputAttributeDescription_handle(&((VkVertexInputAttributeDescription *)val->pVertexAttributeDescriptions)[i]);
    }
}

static inline void
vn_replace_VkPipelineVertexInputStateCreateInfo_handle(VkPipelineVertexInputStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO:
            vn_replace_VkPipelineVertexInputStateCreateInfo_handle_self((VkPipelineVertexInputStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineInputAssemblyStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineInputAssemblyStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineInputAssemblyStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineInputAssemblyStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkPrimitiveTopology(dec, &val->topology);
    vn_decode_VkBool32(dec, &val->primitiveRestartEnable);
}

static inline void
vn_decode_VkPipelineInputAssemblyStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineInputAssemblyStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineInputAssemblyStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineInputAssemblyStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle_self(VkPipelineInputAssemblyStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->topology */
    /* skip val->primitiveRestartEnable */
}

static inline void
vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle(VkPipelineInputAssemblyStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO:
            vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle_self((VkPipelineInputAssemblyStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineTessellationDomainOriginStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkTessellationDomainOrigin(dec, &val->domainOrigin);
}

static inline void
vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle_self(VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->domainOrigin */
}

static inline void
vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle(VkPipelineTessellationDomainOriginStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle_self((VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineTessellationStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineTessellationStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineTessellationDomainOriginStateCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineTessellationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineTessellationDomainOriginStateCreateInfo_self_temp(dec, (VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineTessellationStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineTessellationStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->patchControlPoints);
}

static inline void
vn_decode_VkPipelineTessellationStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineTessellationStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineTessellationStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineTessellationStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineTessellationStateCreateInfo_handle_self(VkPipelineTessellationStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->patchControlPoints */
}

static inline void
vn_replace_VkPipelineTessellationStateCreateInfo_handle(VkPipelineTessellationStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO:
            vn_replace_VkPipelineTessellationStateCreateInfo_handle_self((VkPipelineTessellationStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO:
            vn_replace_VkPipelineTessellationDomainOriginStateCreateInfo_handle_self((VkPipelineTessellationDomainOriginStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineViewportStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineViewportStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineViewportStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineViewportStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->viewportCount);
    if (vn_peek_array_size(dec)) {
        val->pViewports = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pViewports) * val->viewportCount);
        if (!val->pViewports) return;
        vn_decode_array_size(dec, val->viewportCount);
        for (uint32_t i = 0; i < val->viewportCount; i++)
            vn_decode_VkViewport_temp(dec, &((VkViewport *)val->pViewports)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pViewports = NULL;
    }
    vn_decode_uint32_t(dec, &val->scissorCount);
    if (vn_peek_array_size(dec)) {
        val->pScissors = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pScissors) * val->scissorCount);
        if (!val->pScissors) return;
        vn_decode_array_size(dec, val->scissorCount);
        for (uint32_t i = 0; i < val->scissorCount; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)val->pScissors)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pScissors = NULL;
    }
}

static inline void
vn_decode_VkPipelineViewportStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineViewportStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineViewportStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineViewportStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineViewportStateCreateInfo_handle_self(VkPipelineViewportStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->viewportCount */
    if (val->pViewports) {
       for (uint32_t i = 0; i < val->viewportCount; i++)
            vn_replace_VkViewport_handle(&((VkViewport *)val->pViewports)[i]);
    }
    /* skip val->scissorCount */
    if (val->pScissors) {
       for (uint32_t i = 0; i < val->scissorCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)val->pScissors)[i]);
    }
}

static inline void
vn_replace_VkPipelineViewportStateCreateInfo_handle(VkPipelineViewportStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO:
            vn_replace_VkPipelineViewportStateCreateInfo_handle_self((VkPipelineViewportStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationStateStreamCreateInfoEXT chain */

static inline void *
vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->rasterizationStream);
}

static inline void
vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle_self(VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->rasterizationStream */
}

static inline void
vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle(VkPipelineRasterizationStateStreamCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle_self((VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineRasterizationStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkPipelineRasterizationStateStreamCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
            vn_decode_VkPipelineRasterizationStateStreamCreateInfoEXT_self_temp(dec, (VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkPipelineRasterizationStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->depthClampEnable);
    vn_decode_VkBool32(dec, &val->rasterizerDiscardEnable);
    vn_decode_VkPolygonMode(dec, &val->polygonMode);
    vn_decode_VkFlags(dec, &val->cullMode);
    vn_decode_VkFrontFace(dec, &val->frontFace);
    vn_decode_VkBool32(dec, &val->depthBiasEnable);
    vn_decode_float(dec, &val->depthBiasConstantFactor);
    vn_decode_float(dec, &val->depthBiasClamp);
    vn_decode_float(dec, &val->depthBiasSlopeFactor);
    vn_decode_float(dec, &val->lineWidth);
}

static inline void
vn_decode_VkPipelineRasterizationStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineRasterizationStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineRasterizationStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineRasterizationStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineRasterizationStateCreateInfo_handle_self(VkPipelineRasterizationStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->depthClampEnable */
    /* skip val->rasterizerDiscardEnable */
    /* skip val->polygonMode */
    /* skip val->cullMode */
    /* skip val->frontFace */
    /* skip val->depthBiasEnable */
    /* skip val->depthBiasConstantFactor */
    /* skip val->depthBiasClamp */
    /* skip val->depthBiasSlopeFactor */
    /* skip val->lineWidth */
}

static inline void
vn_replace_VkPipelineRasterizationStateCreateInfo_handle(VkPipelineRasterizationStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO:
            vn_replace_VkPipelineRasterizationStateCreateInfo_handle_self((VkPipelineRasterizationStateCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT:
            vn_replace_VkPipelineRasterizationStateStreamCreateInfoEXT_handle_self((VkPipelineRasterizationStateStreamCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineMultisampleStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineMultisampleStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineMultisampleStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineMultisampleStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkSampleCountFlagBits(dec, &val->rasterizationSamples);
    vn_decode_VkBool32(dec, &val->sampleShadingEnable);
    vn_decode_float(dec, &val->minSampleShading);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, (val->rasterizationSamples + 31) / 32);
        val->pSampleMask = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSampleMask) * array_size);
        if (!val->pSampleMask) return;
        vn_decode_VkSampleMask_array(dec, (VkSampleMask *)val->pSampleMask, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pSampleMask = NULL;
    }
    vn_decode_VkBool32(dec, &val->alphaToCoverageEnable);
    vn_decode_VkBool32(dec, &val->alphaToOneEnable);
}

static inline void
vn_decode_VkPipelineMultisampleStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineMultisampleStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineMultisampleStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineMultisampleStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineMultisampleStateCreateInfo_handle_self(VkPipelineMultisampleStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->rasterizationSamples */
    /* skip val->sampleShadingEnable */
    /* skip val->minSampleShading */
    /* skip val->pSampleMask */
    /* skip val->alphaToCoverageEnable */
    /* skip val->alphaToOneEnable */
}

static inline void
vn_replace_VkPipelineMultisampleStateCreateInfo_handle(VkPipelineMultisampleStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO:
            vn_replace_VkPipelineMultisampleStateCreateInfo_handle_self((VkPipelineMultisampleStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkStencilOpState */

static inline void
vn_decode_VkStencilOpState_temp(struct vn_cs_decoder *dec, VkStencilOpState *val)
{
    vn_decode_VkStencilOp(dec, &val->failOp);
    vn_decode_VkStencilOp(dec, &val->passOp);
    vn_decode_VkStencilOp(dec, &val->depthFailOp);
    vn_decode_VkCompareOp(dec, &val->compareOp);
    vn_decode_uint32_t(dec, &val->compareMask);
    vn_decode_uint32_t(dec, &val->writeMask);
    vn_decode_uint32_t(dec, &val->reference);
}

static inline void
vn_replace_VkStencilOpState_handle(VkStencilOpState *val)
{
    /* skip val->failOp */
    /* skip val->passOp */
    /* skip val->depthFailOp */
    /* skip val->compareOp */
    /* skip val->compareMask */
    /* skip val->writeMask */
    /* skip val->reference */
}

/* struct VkPipelineDepthStencilStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineDepthStencilStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineDepthStencilStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineDepthStencilStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->depthTestEnable);
    vn_decode_VkBool32(dec, &val->depthWriteEnable);
    vn_decode_VkCompareOp(dec, &val->depthCompareOp);
    vn_decode_VkBool32(dec, &val->depthBoundsTestEnable);
    vn_decode_VkBool32(dec, &val->stencilTestEnable);
    vn_decode_VkStencilOpState_temp(dec, &val->front);
    vn_decode_VkStencilOpState_temp(dec, &val->back);
    vn_decode_float(dec, &val->minDepthBounds);
    vn_decode_float(dec, &val->maxDepthBounds);
}

static inline void
vn_decode_VkPipelineDepthStencilStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineDepthStencilStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineDepthStencilStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineDepthStencilStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineDepthStencilStateCreateInfo_handle_self(VkPipelineDepthStencilStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->depthTestEnable */
    /* skip val->depthWriteEnable */
    /* skip val->depthCompareOp */
    /* skip val->depthBoundsTestEnable */
    /* skip val->stencilTestEnable */
    vn_replace_VkStencilOpState_handle(&val->front);
    vn_replace_VkStencilOpState_handle(&val->back);
    /* skip val->minDepthBounds */
    /* skip val->maxDepthBounds */
}

static inline void
vn_replace_VkPipelineDepthStencilStateCreateInfo_handle(VkPipelineDepthStencilStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO:
            vn_replace_VkPipelineDepthStencilStateCreateInfo_handle_self((VkPipelineDepthStencilStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineColorBlendAttachmentState */

static inline void
vn_decode_VkPipelineColorBlendAttachmentState_temp(struct vn_cs_decoder *dec, VkPipelineColorBlendAttachmentState *val)
{
    vn_decode_VkBool32(dec, &val->blendEnable);
    vn_decode_VkBlendFactor(dec, &val->srcColorBlendFactor);
    vn_decode_VkBlendFactor(dec, &val->dstColorBlendFactor);
    vn_decode_VkBlendOp(dec, &val->colorBlendOp);
    vn_decode_VkBlendFactor(dec, &val->srcAlphaBlendFactor);
    vn_decode_VkBlendFactor(dec, &val->dstAlphaBlendFactor);
    vn_decode_VkBlendOp(dec, &val->alphaBlendOp);
    vn_decode_VkFlags(dec, &val->colorWriteMask);
}

static inline void
vn_replace_VkPipelineColorBlendAttachmentState_handle(VkPipelineColorBlendAttachmentState *val)
{
    /* skip val->blendEnable */
    /* skip val->srcColorBlendFactor */
    /* skip val->dstColorBlendFactor */
    /* skip val->colorBlendOp */
    /* skip val->srcAlphaBlendFactor */
    /* skip val->dstAlphaBlendFactor */
    /* skip val->alphaBlendOp */
    /* skip val->colorWriteMask */
}

/* struct VkPipelineColorBlendStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineColorBlendStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineColorBlendStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineColorBlendStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkBool32(dec, &val->logicOpEnable);
    vn_decode_VkLogicOp(dec, &val->logicOp);
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        val->pAttachments = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pAttachments) * val->attachmentCount);
        if (!val->pAttachments) return;
        vn_decode_array_size(dec, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_decode_VkPipelineColorBlendAttachmentState_temp(dec, &((VkPipelineColorBlendAttachmentState *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pAttachments = NULL;
    }
    {
        const size_t array_size = vn_decode_array_size(dec, 4);
        vn_decode_float_array(dec, val->blendConstants, array_size);
    }
}

static inline void
vn_decode_VkPipelineColorBlendStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineColorBlendStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineColorBlendStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineColorBlendStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineColorBlendStateCreateInfo_handle_self(VkPipelineColorBlendStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->logicOpEnable */
    /* skip val->logicOp */
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkPipelineColorBlendAttachmentState_handle(&((VkPipelineColorBlendAttachmentState *)val->pAttachments)[i]);
    }
    /* skip val->blendConstants */
}

static inline void
vn_replace_VkPipelineColorBlendStateCreateInfo_handle(VkPipelineColorBlendStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO:
            vn_replace_VkPipelineColorBlendStateCreateInfo_handle_self((VkPipelineColorBlendStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkPipelineDynamicStateCreateInfo chain */

static inline void *
vn_decode_VkPipelineDynamicStateCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkPipelineDynamicStateCreateInfo_self_temp(struct vn_cs_decoder *dec, VkPipelineDynamicStateCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->dynamicStateCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->dynamicStateCount);
        val->pDynamicStates = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDynamicStates) * array_size);
        if (!val->pDynamicStates) return;
        vn_decode_VkDynamicState_array(dec, (VkDynamicState *)val->pDynamicStates, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pDynamicStates = NULL;
    }
}

static inline void
vn_decode_VkPipelineDynamicStateCreateInfo_temp(struct vn_cs_decoder *dec, VkPipelineDynamicStateCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkPipelineDynamicStateCreateInfo_pnext_temp(dec);
    vn_decode_VkPipelineDynamicStateCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkPipelineDynamicStateCreateInfo_handle_self(VkPipelineDynamicStateCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->dynamicStateCount */
    /* skip val->pDynamicStates */
}

static inline void
vn_replace_VkPipelineDynamicStateCreateInfo_handle(VkPipelineDynamicStateCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO:
            vn_replace_VkPipelineDynamicStateCreateInfo_handle_self((VkPipelineDynamicStateCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkGraphicsPipelineCreateInfo chain */

static inline void *
vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkGraphicsPipelineCreateInfo_self_temp(struct vn_cs_decoder *dec, VkGraphicsPipelineCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_uint32_t(dec, &val->stageCount);
    if (vn_peek_array_size(dec)) {
        val->pStages = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pStages) * val->stageCount);
        if (!val->pStages) return;
        vn_decode_array_size(dec, val->stageCount);
        for (uint32_t i = 0; i < val->stageCount; i++)
            vn_decode_VkPipelineShaderStageCreateInfo_temp(dec, &((VkPipelineShaderStageCreateInfo *)val->pStages)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pStages = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pVertexInputState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pVertexInputState));
        if (!val->pVertexInputState) return;
        vn_decode_VkPipelineVertexInputStateCreateInfo_temp(dec, (VkPipelineVertexInputStateCreateInfo *)val->pVertexInputState);
    } else {
        val->pVertexInputState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pInputAssemblyState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pInputAssemblyState));
        if (!val->pInputAssemblyState) return;
        vn_decode_VkPipelineInputAssemblyStateCreateInfo_temp(dec, (VkPipelineInputAssemblyStateCreateInfo *)val->pInputAssemblyState);
    } else {
        val->pInputAssemblyState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pTessellationState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pTessellationState));
        if (!val->pTessellationState) return;
        vn_decode_VkPipelineTessellationStateCreateInfo_temp(dec, (VkPipelineTessellationStateCreateInfo *)val->pTessellationState);
    } else {
        val->pTessellationState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pViewportState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pViewportState));
        if (!val->pViewportState) return;
        vn_decode_VkPipelineViewportStateCreateInfo_temp(dec, (VkPipelineViewportStateCreateInfo *)val->pViewportState);
    } else {
        val->pViewportState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pRasterizationState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pRasterizationState));
        if (!val->pRasterizationState) return;
        vn_decode_VkPipelineRasterizationStateCreateInfo_temp(dec, (VkPipelineRasterizationStateCreateInfo *)val->pRasterizationState);
    } else {
        val->pRasterizationState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pMultisampleState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pMultisampleState));
        if (!val->pMultisampleState) return;
        vn_decode_VkPipelineMultisampleStateCreateInfo_temp(dec, (VkPipelineMultisampleStateCreateInfo *)val->pMultisampleState);
    } else {
        val->pMultisampleState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDepthStencilState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDepthStencilState));
        if (!val->pDepthStencilState) return;
        vn_decode_VkPipelineDepthStencilStateCreateInfo_temp(dec, (VkPipelineDepthStencilStateCreateInfo *)val->pDepthStencilState);
    } else {
        val->pDepthStencilState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pColorBlendState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pColorBlendState));
        if (!val->pColorBlendState) return;
        vn_decode_VkPipelineColorBlendStateCreateInfo_temp(dec, (VkPipelineColorBlendStateCreateInfo *)val->pColorBlendState);
    } else {
        val->pColorBlendState = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pDynamicState = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pDynamicState));
        if (!val->pDynamicState) return;
        vn_decode_VkPipelineDynamicStateCreateInfo_temp(dec, (VkPipelineDynamicStateCreateInfo *)val->pDynamicState);
    } else {
        val->pDynamicState = NULL;
    }
    vn_decode_VkPipelineLayout_lookup(dec, &val->layout);
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_uint32_t(dec, &val->subpass);
    vn_decode_VkPipeline_lookup(dec, &val->basePipelineHandle);
    vn_decode_int32_t(dec, &val->basePipelineIndex);
}

static inline void
vn_decode_VkGraphicsPipelineCreateInfo_temp(struct vn_cs_decoder *dec, VkGraphicsPipelineCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkGraphicsPipelineCreateInfo_pnext_temp(dec);
    vn_decode_VkGraphicsPipelineCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkGraphicsPipelineCreateInfo_handle_self(VkGraphicsPipelineCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->stageCount */
    if (val->pStages) {
       for (uint32_t i = 0; i < val->stageCount; i++)
            vn_replace_VkPipelineShaderStageCreateInfo_handle(&((VkPipelineShaderStageCreateInfo *)val->pStages)[i]);
    }
    if (val->pVertexInputState)
        vn_replace_VkPipelineVertexInputStateCreateInfo_handle((VkPipelineVertexInputStateCreateInfo *)val->pVertexInputState);
    if (val->pInputAssemblyState)
        vn_replace_VkPipelineInputAssemblyStateCreateInfo_handle((VkPipelineInputAssemblyStateCreateInfo *)val->pInputAssemblyState);
    if (val->pTessellationState)
        vn_replace_VkPipelineTessellationStateCreateInfo_handle((VkPipelineTessellationStateCreateInfo *)val->pTessellationState);
    if (val->pViewportState)
        vn_replace_VkPipelineViewportStateCreateInfo_handle((VkPipelineViewportStateCreateInfo *)val->pViewportState);
    if (val->pRasterizationState)
        vn_replace_VkPipelineRasterizationStateCreateInfo_handle((VkPipelineRasterizationStateCreateInfo *)val->pRasterizationState);
    if (val->pMultisampleState)
        vn_replace_VkPipelineMultisampleStateCreateInfo_handle((VkPipelineMultisampleStateCreateInfo *)val->pMultisampleState);
    if (val->pDepthStencilState)
        vn_replace_VkPipelineDepthStencilStateCreateInfo_handle((VkPipelineDepthStencilStateCreateInfo *)val->pDepthStencilState);
    if (val->pColorBlendState)
        vn_replace_VkPipelineColorBlendStateCreateInfo_handle((VkPipelineColorBlendStateCreateInfo *)val->pColorBlendState);
    if (val->pDynamicState)
        vn_replace_VkPipelineDynamicStateCreateInfo_handle((VkPipelineDynamicStateCreateInfo *)val->pDynamicState);
    vn_replace_VkPipelineLayout_handle(&val->layout);
    vn_replace_VkRenderPass_handle(&val->renderPass);
    /* skip val->subpass */
    vn_replace_VkPipeline_handle(&val->basePipelineHandle);
    /* skip val->basePipelineIndex */
}

static inline void
vn_replace_VkGraphicsPipelineCreateInfo_handle(VkGraphicsPipelineCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO:
            vn_replace_VkGraphicsPipelineCreateInfo_handle_self((VkGraphicsPipelineCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkComputePipelineCreateInfo chain */

static inline void *
vn_decode_VkComputePipelineCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkComputePipelineCreateInfo_self_temp(struct vn_cs_decoder *dec, VkComputePipelineCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkPipelineShaderStageCreateInfo_temp(dec, &val->stage);
    vn_decode_VkPipelineLayout_lookup(dec, &val->layout);
    vn_decode_VkPipeline_lookup(dec, &val->basePipelineHandle);
    vn_decode_int32_t(dec, &val->basePipelineIndex);
}

static inline void
vn_decode_VkComputePipelineCreateInfo_temp(struct vn_cs_decoder *dec, VkComputePipelineCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkComputePipelineCreateInfo_pnext_temp(dec);
    vn_decode_VkComputePipelineCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkComputePipelineCreateInfo_handle_self(VkComputePipelineCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkPipelineShaderStageCreateInfo_handle(&val->stage);
    vn_replace_VkPipelineLayout_handle(&val->layout);
    vn_replace_VkPipeline_handle(&val->basePipelineHandle);
    /* skip val->basePipelineIndex */
}

static inline void
vn_replace_VkComputePipelineCreateInfo_handle(VkComputePipelineCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO:
            vn_replace_VkComputePipelineCreateInfo_handle_self((VkComputePipelineCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCreateGraphicsPipelines_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateGraphicsPipelines *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkPipelineCache_lookup(dec, &args->pipelineCache);
    vn_decode_uint32_t(dec, &args->createInfoCount);
    if (vn_peek_array_size(dec)) {
        args->pCreateInfos = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfos) * args->createInfoCount);
        if (!args->pCreateInfos) return;
        vn_decode_array_size(dec, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_decode_VkGraphicsPipelineCreateInfo_temp(dec, &((VkGraphicsPipelineCreateInfo *)args->pCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCreateInfos = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        assert(false);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pPipelines = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPipelines) * args->createInfoCount);
        if (!args->pPipelines) return;
        vn_decode_array_size(dec, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_decode_VkPipeline(dec, &args->pPipelines[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pPipelines = NULL;
    }
}

static inline void vn_replace_vkCreateGraphicsPipelines_args_handle(struct vn_command_vkCreateGraphicsPipelines *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkPipelineCache_handle(&args->pipelineCache);
    /* skip args->createInfoCount */
    if (args->pCreateInfos) {
       for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_replace_VkGraphicsPipelineCreateInfo_handle(&((VkGraphicsPipelineCreateInfo *)args->pCreateInfos)[i]);
    }
    /* skip args->pAllocator */
    /* skip args->pPipelines */
}

static inline void vn_encode_vkCreateGraphicsPipelines_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateGraphicsPipelines *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateGraphicsPipelines_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pipelineCache */
    /* skip args->createInfoCount */
    /* skip args->pCreateInfos */
    /* skip args->pAllocator */
    if (args->pPipelines) {
        vn_encode_array_size(enc, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_encode_VkPipeline(enc, &args->pPipelines[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkCreateComputePipelines_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateComputePipelines *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkPipelineCache_lookup(dec, &args->pipelineCache);
    vn_decode_uint32_t(dec, &args->createInfoCount);
    if (vn_peek_array_size(dec)) {
        args->pCreateInfos = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfos) * args->createInfoCount);
        if (!args->pCreateInfos) return;
        vn_decode_array_size(dec, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_decode_VkComputePipelineCreateInfo_temp(dec, &((VkComputePipelineCreateInfo *)args->pCreateInfos)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pCreateInfos = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        assert(false);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_peek_array_size(dec)) {
        args->pPipelines = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pPipelines) * args->createInfoCount);
        if (!args->pPipelines) return;
        vn_decode_array_size(dec, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_decode_VkPipeline(dec, &args->pPipelines[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pPipelines = NULL;
    }
}

static inline void vn_replace_vkCreateComputePipelines_args_handle(struct vn_command_vkCreateComputePipelines *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkPipelineCache_handle(&args->pipelineCache);
    /* skip args->createInfoCount */
    if (args->pCreateInfos) {
       for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_replace_VkComputePipelineCreateInfo_handle(&((VkComputePipelineCreateInfo *)args->pCreateInfos)[i]);
    }
    /* skip args->pAllocator */
    /* skip args->pPipelines */
}

static inline void vn_encode_vkCreateComputePipelines_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateComputePipelines *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateComputePipelines_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pipelineCache */
    /* skip args->createInfoCount */
    /* skip args->pCreateInfos */
    /* skip args->pAllocator */
    if (args->pPipelines) {
        vn_encode_array_size(enc, args->createInfoCount);
        for (uint32_t i = 0; i < args->createInfoCount; i++)
            vn_encode_VkPipeline(enc, &args->pPipelines[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkDestroyPipeline_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyPipeline *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkPipeline_lookup(dec, &args->pipeline);
    if (vn_decode_simple_pointer(dec)) {
        assert(false);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyPipeline_args_handle(struct vn_command_vkDestroyPipeline *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkPipeline_handle(&args->pipeline);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyPipeline_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyPipeline *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyPipeline_EXT});

    /* skip args->device */
    /* skip args->pipeline */
    /* skip args->pAllocator */
}

static inline void vn_dispatch_vkCreateGraphicsPipelines(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateGraphicsPipelines args;

    if (!ctx->dispatch_vkCreateGraphicsPipelines) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateGraphicsPipelines_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateGraphicsPipelines(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkCreateGraphicsPipelines returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateGraphicsPipelines_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateComputePipelines(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateComputePipelines args;

    if (!ctx->dispatch_vkCreateComputePipelines) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateComputePipelines_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateComputePipelines(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkCreateComputePipelines returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkCreateComputePipelines_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyPipeline(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyPipeline args;

    if (!ctx->dispatch_vkDestroyPipeline) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyPipeline_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyPipeline(ctx, &args);


    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkDestroyPipeline_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#endif /* VN_PROTOCOL_RENDERER_PIPELINE_H */
