/* TransitionsInterfaces.c generated by valac 0.36.6, the Vala compiler
 * generated from TransitionsInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>


#define SPIT_TRANSITIONS_TYPE_DIRECTION (spit_transitions_direction_get_type ())

#define SPIT_TRANSITIONS_TYPE_VISUALS (spit_transitions_visuals_get_type ())
#define SPIT_TRANSITIONS_VISUALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals))
#define SPIT_TRANSITIONS_VISUALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisualsClass))
#define SPIT_TRANSITIONS_IS_VISUALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TRANSITIONS_TYPE_VISUALS))
#define SPIT_TRANSITIONS_IS_VISUALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPIT_TRANSITIONS_TYPE_VISUALS))
#define SPIT_TRANSITIONS_VISUALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisualsClass))

typedef struct _SpitTransitionsVisuals SpitTransitionsVisuals;
typedef struct _SpitTransitionsVisualsClass SpitTransitionsVisualsClass;
typedef struct _SpitTransitionsVisualsPrivate SpitTransitionsVisualsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SPIT_TRANSITIONS_TYPE_MOTION (spit_transitions_motion_get_type ())
#define SPIT_TRANSITIONS_MOTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion))
#define SPIT_TRANSITIONS_MOTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotionClass))
#define SPIT_TRANSITIONS_IS_MOTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TRANSITIONS_TYPE_MOTION))
#define SPIT_TRANSITIONS_IS_MOTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPIT_TRANSITIONS_TYPE_MOTION))
#define SPIT_TRANSITIONS_MOTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotionClass))

typedef struct _SpitTransitionsMotion SpitTransitionsMotion;
typedef struct _SpitTransitionsMotionClass SpitTransitionsMotionClass;
typedef struct _SpitTransitionsMotionPrivate SpitTransitionsMotionPrivate;

#define SPIT_TYPE_PLUGGABLE (spit_pluggable_get_type ())
#define SPIT_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggable))
#define SPIT_IS_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_PLUGGABLE))
#define SPIT_PLUGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggableIface))

typedef struct _SpitPluggable SpitPluggable;
typedef struct _SpitPluggableIface SpitPluggableIface;

#define SPIT_TYPE_PLUGGABLE_INFO (spit_pluggable_info_get_type ())
typedef struct _SpitPluggableInfo SpitPluggableInfo;

#define SPIT_TRANSITIONS_TYPE_DESCRIPTOR (spit_transitions_descriptor_get_type ())
#define SPIT_TRANSITIONS_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TRANSITIONS_TYPE_DESCRIPTOR, SpitTransitionsDescriptor))
#define SPIT_TRANSITIONS_IS_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TRANSITIONS_TYPE_DESCRIPTOR))
#define SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TRANSITIONS_TYPE_DESCRIPTOR, SpitTransitionsDescriptorIface))

typedef struct _SpitTransitionsDescriptor SpitTransitionsDescriptor;
typedef struct _SpitTransitionsDescriptorIface SpitTransitionsDescriptorIface;

#define SPIT_TYPE_HOST_INTERFACE (spit_host_interface_get_type ())
#define SPIT_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterface))
#define SPIT_IS_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_HOST_INTERFACE))
#define SPIT_HOST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterfaceIface))

typedef struct _SpitHostInterface SpitHostInterface;
typedef struct _SpitHostInterfaceIface SpitHostInterfaceIface;

#define SPIT_TRANSITIONS_TYPE_EFFECT (spit_transitions_effect_get_type ())
#define SPIT_TRANSITIONS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect))
#define SPIT_TRANSITIONS_IS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TRANSITIONS_TYPE_EFFECT))
#define SPIT_TRANSITIONS_EFFECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffectIface))

typedef struct _SpitTransitionsEffect SpitTransitionsEffect;
typedef struct _SpitTransitionsEffectIface SpitTransitionsEffectIface;

typedef enum  {
	SPIT_TRANSITIONS_DIRECTION_LEFT = 0,
	SPIT_TRANSITIONS_DIRECTION_RIGHT = 1,
	SPIT_TRANSITIONS_DIRECTION_FORWARD = SPIT_TRANSITIONS_DIRECTION_LEFT,
	SPIT_TRANSITIONS_DIRECTION_BACKWARD = SPIT_TRANSITIONS_DIRECTION_RIGHT
} SpitTransitionsDirection;

struct _SpitTransitionsVisuals {
	GObject parent_instance;
	SpitTransitionsVisualsPrivate * priv;
};

struct _SpitTransitionsVisualsClass {
	GObjectClass parent_class;
	void (*reserved0) (SpitTransitionsVisuals* self);
	void (*reserved1) (SpitTransitionsVisuals* self);
	void (*reserved2) (SpitTransitionsVisuals* self);
	void (*reserved3) (SpitTransitionsVisuals* self);
	void (*reserved4) (SpitTransitionsVisuals* self);
	void (*reserved5) (SpitTransitionsVisuals* self);
	void (*reserved6) (SpitTransitionsVisuals* self);
	void (*reserved7) (SpitTransitionsVisuals* self);
};

struct _SpitTransitionsVisualsPrivate {
	GdkPixbuf* _from_pixbuf;
	GdkRectangle _from_pos;
	GdkPixbuf* _to_pixbuf;
	GdkRectangle _to_pos;
	GdkRGBA _bg_color;
};

struct _SpitTransitionsMotion {
	GObject parent_instance;
	SpitTransitionsMotionPrivate * priv;
};

struct _SpitTransitionsMotionClass {
	GObjectClass parent_class;
	void (*reserved0) (SpitTransitionsMotion* self);
	void (*reserved1) (SpitTransitionsMotion* self);
	void (*reserved2) (SpitTransitionsMotion* self);
	void (*reserved3) (SpitTransitionsMotion* self);
	void (*reserved4) (SpitTransitionsMotion* self);
	void (*reserved5) (SpitTransitionsMotion* self);
	void (*reserved6) (SpitTransitionsMotion* self);
	void (*reserved7) (SpitTransitionsMotion* self);
};

struct _SpitTransitionsMotionPrivate {
	SpitTransitionsDirection _direction;
	gint _fps;
	gint _duration_msec;
};

struct _SpitPluggableInfo {
	gchar* version;
	gchar* brief_description;
	gchar* authors;
	gchar* copyright;
	gchar* license;
	gboolean is_license_wordwrapped;
	gchar* website_url;
	gchar* website_name;
	gchar* translators;
	GdkPixbuf** icons;
	gint icons_length1;
};

struct _SpitPluggableIface {
	GTypeInterface parent_iface;
	gint (*get_pluggable_interface) (SpitPluggable* self, gint min_host_interface, gint max_host_interface);
	const gchar* (*get_id) (SpitPluggable* self);
	const gchar* (*get_pluggable_name) (SpitPluggable* self);
	void (*get_info) (SpitPluggable* self, SpitPluggableInfo* info);
	void (*activation) (SpitPluggable* self, gboolean enabled);
	void (*reserved0) (SpitPluggable* self);
	void (*reserved1) (SpitPluggable* self);
	void (*reserved2) (SpitPluggable* self);
	void (*reserved3) (SpitPluggable* self);
	void (*reserved4) (SpitPluggable* self);
	void (*reserved5) (SpitPluggable* self);
	void (*reserved6) (SpitPluggable* self);
	void (*reserved7) (SpitPluggable* self);
};

struct _SpitHostInterfaceIface {
	GTypeInterface parent_iface;
	GFile* (*get_module_file) (SpitHostInterface* self);
	gboolean (*get_config_bool) (SpitHostInterface* self, const gchar* key, gboolean def);
	void (*set_config_bool) (SpitHostInterface* self, const gchar* key, gboolean val);
	gint (*get_config_int) (SpitHostInterface* self, const gchar* key, gint def);
	void (*set_config_int) (SpitHostInterface* self, const gchar* key, gint val);
	gchar* (*get_config_string) (SpitHostInterface* self, const gchar* key, const gchar* def);
	void (*set_config_string) (SpitHostInterface* self, const gchar* key, const gchar* val);
	gdouble (*get_config_double) (SpitHostInterface* self, const gchar* key, gdouble def);
	void (*set_config_double) (SpitHostInterface* self, const gchar* key, gdouble val);
	void (*unset_config_key) (SpitHostInterface* self, const gchar* key);
	void (*reserved0) (SpitHostInterface* self);
	void (*reserved1) (SpitHostInterface* self);
	void (*reserved2) (SpitHostInterface* self);
	void (*reserved3) (SpitHostInterface* self);
	void (*reserved4) (SpitHostInterface* self);
	void (*reserved5) (SpitHostInterface* self);
	void (*reserved6) (SpitHostInterface* self);
	void (*reserved7) (SpitHostInterface* self);
};

struct _SpitTransitionsEffectIface {
	GTypeInterface parent_iface;
	void (*get_fps) (SpitTransitionsEffect* self, gint* desired_fps, gint* min_fps);
	void (*start) (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion);
	gboolean (*needs_clear_background) (SpitTransitionsEffect* self);
	void (*paint) (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number);
	void (*advance) (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number);
	void (*cancel) (SpitTransitionsEffect* self);
	void (*reserved0) (SpitTransitionsEffect* self);
	void (*reserved1) (SpitTransitionsEffect* self);
	void (*reserved2) (SpitTransitionsEffect* self);
	void (*reserved3) (SpitTransitionsEffect* self);
	void (*reserved4) (SpitTransitionsEffect* self);
	void (*reserved5) (SpitTransitionsEffect* self);
	void (*reserved6) (SpitTransitionsEffect* self);
	void (*reserved7) (SpitTransitionsEffect* self);
};

struct _SpitTransitionsDescriptorIface {
	GTypeInterface parent_iface;
	SpitTransitionsEffect* (*create) (SpitTransitionsDescriptor* self, SpitHostInterface* host);
	void (*reserved0) (SpitTransitionsDescriptor* self);
	void (*reserved1) (SpitTransitionsDescriptor* self);
	void (*reserved2) (SpitTransitionsDescriptor* self);
	void (*reserved3) (SpitTransitionsDescriptor* self);
	void (*reserved4) (SpitTransitionsDescriptor* self);
	void (*reserved5) (SpitTransitionsDescriptor* self);
	void (*reserved6) (SpitTransitionsDescriptor* self);
	void (*reserved7) (SpitTransitionsDescriptor* self);
};


static gpointer spit_transitions_visuals_parent_class = NULL;
static gpointer spit_transitions_motion_parent_class = NULL;

#define SPIT_TRANSITIONS_CURRENT_INTERFACE 0
GType spit_transitions_direction_get_type (void) G_GNUC_CONST;
GType spit_transitions_visuals_get_type (void) G_GNUC_CONST;
#define SPIT_TRANSITIONS_VISUALS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisualsPrivate))
enum  {
	SPIT_TRANSITIONS_VISUALS_DUMMY_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY,
	SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY
};
SpitTransitionsVisuals* spit_transitions_visuals_new (GdkPixbuf* from_pixbuf, GdkRectangle* from_pos, GdkPixbuf* to_pixbuf, GdkRectangle* to_pos, GdkRGBA* bg_color);
SpitTransitionsVisuals* spit_transitions_visuals_construct (GType object_type, GdkPixbuf* from_pixbuf, GdkRectangle* from_pos, GdkPixbuf* to_pixbuf, GdkRectangle* to_pos, GdkRGBA* bg_color);
static void spit_transitions_visuals_set_from_pixbuf (SpitTransitionsVisuals* self, GdkPixbuf* value);
static void spit_transitions_visuals_set_from_pos (SpitTransitionsVisuals* self, GdkRectangle * value);
static void spit_transitions_visuals_set_to_pixbuf (SpitTransitionsVisuals* self, GdkPixbuf* value);
static void spit_transitions_visuals_set_to_pos (SpitTransitionsVisuals* self, GdkRectangle * value);
static void spit_transitions_visuals_set_bg_color (SpitTransitionsVisuals* self, GdkRGBA * value);
void spit_transitions_visuals_reserved0 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved0 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved1 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved1 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved2 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved2 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved3 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved3 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved4 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved4 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved5 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved5 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved6 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved6 (SpitTransitionsVisuals* self);
void spit_transitions_visuals_reserved7 (SpitTransitionsVisuals* self);
static void spit_transitions_visuals_real_reserved7 (SpitTransitionsVisuals* self);
GdkPixbuf* spit_transitions_visuals_get_from_pixbuf (SpitTransitionsVisuals* self);
void spit_transitions_visuals_get_from_pos (SpitTransitionsVisuals* self, GdkRectangle * result);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1, const cairo_rectangle_int_t * s2);
GdkPixbuf* spit_transitions_visuals_get_to_pixbuf (SpitTransitionsVisuals* self);
void spit_transitions_visuals_get_to_pos (SpitTransitionsVisuals* self, GdkRectangle * result);
void spit_transitions_visuals_get_bg_color (SpitTransitionsVisuals* self, GdkRGBA * result);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1, const GdkRGBA * s2);
static void spit_transitions_visuals_finalize (GObject * obj);
static void _vala_spit_transitions_visuals_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_spit_transitions_visuals_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType spit_transitions_motion_get_type (void) G_GNUC_CONST;
#define SPIT_TRANSITIONS_MOTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotionPrivate))
enum  {
	SPIT_TRANSITIONS_MOTION_DUMMY_PROPERTY,
	SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY,
	SPIT_TRANSITIONS_MOTION_FPS_PROPERTY,
	SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY,
	SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY,
	SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY
};
SpitTransitionsMotion* spit_transitions_motion_new (SpitTransitionsDirection direction, gint fps, gint duration_msec);
SpitTransitionsMotion* spit_transitions_motion_construct (GType object_type, SpitTransitionsDirection direction, gint fps, gint duration_msec);
static void spit_transitions_motion_set_direction (SpitTransitionsMotion* self, SpitTransitionsDirection value);
static void spit_transitions_motion_set_fps (SpitTransitionsMotion* self, gint value);
static void spit_transitions_motion_set_duration_msec (SpitTransitionsMotion* self, gint value);
gdouble spit_transitions_motion_get_alpha (SpitTransitionsMotion* self, gint frame_number);
gint spit_transitions_motion_get_total_frames (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved0 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved0 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved1 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved1 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved2 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved2 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved3 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved3 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved4 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved4 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved5 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved5 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved6 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved6 (SpitTransitionsMotion* self);
void spit_transitions_motion_reserved7 (SpitTransitionsMotion* self);
static void spit_transitions_motion_real_reserved7 (SpitTransitionsMotion* self);
SpitTransitionsDirection spit_transitions_motion_get_direction (SpitTransitionsMotion* self);
gint spit_transitions_motion_get_fps (SpitTransitionsMotion* self);
gint spit_transitions_motion_get_duration_msec (SpitTransitionsMotion* self);
gint spit_transitions_motion_get_tick_msec (SpitTransitionsMotion* self);
static void spit_transitions_motion_finalize (GObject * obj);
static void _vala_spit_transitions_motion_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_spit_transitions_motion_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType spit_pluggable_info_get_type (void) G_GNUC_CONST;
SpitPluggableInfo* spit_pluggable_info_dup (const SpitPluggableInfo* self);
void spit_pluggable_info_free (SpitPluggableInfo* self);
void spit_pluggable_info_copy (const SpitPluggableInfo* self, SpitPluggableInfo* dest);
void spit_pluggable_info_destroy (SpitPluggableInfo* self);
GType spit_pluggable_get_type (void) G_GNUC_CONST;
GType spit_host_interface_get_type (void) G_GNUC_CONST;
GType spit_transitions_effect_get_type (void) G_GNUC_CONST;
GType spit_transitions_descriptor_get_type (void) G_GNUC_CONST;
SpitTransitionsEffect* spit_transitions_descriptor_create (SpitTransitionsDescriptor* self, SpitHostInterface* host);
void spit_transitions_descriptor_reserved0 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved0 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved1 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved1 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved2 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved2 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved3 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved3 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved4 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved4 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved5 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved5 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved6 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved6 (SpitTransitionsDescriptor* self);
void spit_transitions_descriptor_reserved7 (SpitTransitionsDescriptor* self);
static void spit_transitions_descriptor_real_reserved7 (SpitTransitionsDescriptor* self);
void spit_transitions_effect_get_fps (SpitTransitionsEffect* self, gint* desired_fps, gint* min_fps);
void spit_transitions_effect_start (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion);
gboolean spit_transitions_effect_needs_clear_background (SpitTransitionsEffect* self);
void spit_transitions_effect_paint (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number);
void spit_transitions_effect_advance (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number);
void spit_transitions_effect_cancel (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved0 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved0 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved1 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved1 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved2 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved2 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved3 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved3 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved4 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved4 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved5 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved5 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved6 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved6 (SpitTransitionsEffect* self);
void spit_transitions_effect_reserved7 (SpitTransitionsEffect* self);
static void spit_transitions_effect_real_reserved7 (SpitTransitionsEffect* self);


/**
 * Direction indicates what direction (animated motion) the {@link Effect} should simulate the 
 * images are moving, if appropriate.
 * 
 * The direction indicates from what side or corner of the screen the new image should come in from.
 * Thus, a LEFT slide means the current image exits via the left-hand edge of the screen and the 
 * new image moves into place from the right-hand edge.
 *
 * UP, DOWN, and diagonals may be added at some point.
 */
GType spit_transitions_direction_get_type (void) {
	static volatile gsize spit_transitions_direction_type_id__volatile = 0;
	if (g_once_init_enter (&spit_transitions_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_TRANSITIONS_DIRECTION_LEFT, "SPIT_TRANSITIONS_DIRECTION_LEFT", "left"}, {SPIT_TRANSITIONS_DIRECTION_RIGHT, "SPIT_TRANSITIONS_DIRECTION_RIGHT", "right"}, {SPIT_TRANSITIONS_DIRECTION_FORWARD, "SPIT_TRANSITIONS_DIRECTION_FORWARD", "forward"}, {SPIT_TRANSITIONS_DIRECTION_BACKWARD, "SPIT_TRANSITIONS_DIRECTION_BACKWARD", "backward"}, {0, NULL, NULL}};
		GType spit_transitions_direction_type_id;
		spit_transitions_direction_type_id = g_enum_register_static ("SpitTransitionsDirection", values);
		g_once_init_leave (&spit_transitions_direction_type_id__volatile, spit_transitions_direction_type_id);
	}
	return spit_transitions_direction_type_id__volatile;
}


SpitTransitionsVisuals* spit_transitions_visuals_construct (GType object_type, GdkPixbuf* from_pixbuf, GdkRectangle* from_pos, GdkPixbuf* to_pixbuf, GdkRectangle* to_pos, GdkRGBA* bg_color) {
	SpitTransitionsVisuals * self = NULL;
	GdkPixbuf* _tmp0_;
	GdkRectangle _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkRectangle _tmp3_;
	GdkRGBA _tmp4_;
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail ((from_pixbuf == NULL) || GDK_IS_PIXBUF (from_pixbuf), NULL);
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (from_pos != NULL, NULL);
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail ((to_pixbuf == NULL) || GDK_IS_PIXBUF (to_pixbuf), NULL);
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (to_pos != NULL, NULL);
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (bg_color != NULL, NULL);
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	self = (SpitTransitionsVisuals*) g_object_new (object_type, NULL);
#line 96 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = from_pixbuf;
#line 96 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_visuals_set_from_pixbuf (self, _tmp0_);
#line 97 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp1_ = *from_pos;
#line 97 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_visuals_set_from_pos (self, &_tmp1_);
#line 98 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp2_ = to_pixbuf;
#line 98 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_visuals_set_to_pixbuf (self, _tmp2_);
#line 99 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp3_ = *to_pos;
#line 99 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_visuals_set_to_pos (self, &_tmp3_);
#line 100 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp4_ = *bg_color;
#line 100 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_visuals_set_bg_color (self, &_tmp4_);
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return self;
#line 424 "TransitionsInterfaces.c"
}


SpitTransitionsVisuals* spit_transitions_visuals_new (GdkPixbuf* from_pixbuf, GdkRectangle* from_pos, GdkPixbuf* to_pixbuf, GdkRectangle* to_pos, GdkRGBA* bg_color) {
#line 94 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return spit_transitions_visuals_construct (SPIT_TRANSITIONS_TYPE_VISUALS, from_pixbuf, from_pos, to_pixbuf, to_pos, bg_color);
#line 431 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved0 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved0 (SpitTransitionsVisuals* self) {
#line 106 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 106 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved0 (self);
#line 444 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved1 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved1 (SpitTransitionsVisuals* self) {
#line 107 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 107 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved1 (self);
#line 457 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved2 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved2 (SpitTransitionsVisuals* self) {
#line 108 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 108 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved2 (self);
#line 470 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved3 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved3 (SpitTransitionsVisuals* self) {
#line 109 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 109 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved3 (self);
#line 483 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved4 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved4 (SpitTransitionsVisuals* self) {
#line 110 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 110 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved4 (self);
#line 496 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved5 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved5 (SpitTransitionsVisuals* self) {
#line 111 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 111 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved5 (self);
#line 509 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved6 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved6 (SpitTransitionsVisuals* self) {
#line 112 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 112 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved6 (self);
#line 522 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_real_reserved7 (SpitTransitionsVisuals* self) {
}


void spit_transitions_visuals_reserved7 (SpitTransitionsVisuals* self) {
#line 113 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 113 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_VISUALS_GET_CLASS (self)->reserved7 (self);
#line 535 "TransitionsInterfaces.c"
}


GdkPixbuf* spit_transitions_visuals_get_from_pixbuf (SpitTransitionsVisuals* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self), NULL);
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_from_pixbuf;
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 550 "TransitionsInterfaces.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return self ? g_object_ref (self) : NULL;
#line 557 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_set_from_pixbuf (SpitTransitionsVisuals* self, GdkPixbuf* value) {
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (spit_transitions_visuals_get_from_pixbuf (self) != value) {
#line 566 "TransitionsInterfaces.c"
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = value;
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_g_object_unref0 (self->priv->_from_pixbuf);
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_from_pixbuf = _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "from-pixbuf");
#line 579 "TransitionsInterfaces.c"
	}
}


void spit_transitions_visuals_get_from_pos (SpitTransitionsVisuals* self, GdkRectangle * result) {
	GdkRectangle _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_from_pos;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	*result = _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return;
#line 594 "TransitionsInterfaces.c"
}


static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1, const cairo_rectangle_int_t * s2) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1 == s2) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return TRUE;
#line 603 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1 == NULL) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 609 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s2 == NULL) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 615 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->x != s2->x) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 621 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->y != s2->y) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 627 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->width != s2->width) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 633 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->height != s2->height) {
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 639 "TransitionsInterfaces.c"
	}
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return TRUE;
#line 643 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_set_from_pos (SpitTransitionsVisuals* self, GdkRectangle * value) {
	GdkRectangle old_value;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (_cairo_rectangle_int_equal (value, (spit_transitions_visuals_get_from_pos (self, &old_value), &old_value)) != TRUE) {
#line 653 "TransitionsInterfaces.c"
		GdkRectangle _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = *value;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_from_pos = _tmp0_;
#line 73 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "from-pos");
#line 661 "TransitionsInterfaces.c"
	}
}


GdkPixbuf* spit_transitions_visuals_get_to_pixbuf (SpitTransitionsVisuals* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self), NULL);
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_to_pixbuf;
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = _tmp0_;
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 677 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_set_to_pixbuf (SpitTransitionsVisuals* self, GdkPixbuf* value) {
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (spit_transitions_visuals_get_to_pixbuf (self) != value) {
#line 686 "TransitionsInterfaces.c"
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = value;
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_g_object_unref0 (self->priv->_to_pixbuf);
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_to_pixbuf = _tmp1_;
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "to-pixbuf");
#line 699 "TransitionsInterfaces.c"
	}
}


void spit_transitions_visuals_get_to_pos (SpitTransitionsVisuals* self, GdkRectangle * result) {
	GdkRectangle _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_to_pos;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	*result = _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return;
#line 714 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_set_to_pos (SpitTransitionsVisuals* self, GdkRectangle * value) {
	GdkRectangle old_value;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (_cairo_rectangle_int_equal (value, (spit_transitions_visuals_get_to_pos (self, &old_value), &old_value)) != TRUE) {
#line 724 "TransitionsInterfaces.c"
		GdkRectangle _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = *value;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_to_pos = _tmp0_;
#line 87 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "to-pos");
#line 732 "TransitionsInterfaces.c"
	}
}


void spit_transitions_visuals_get_bg_color (SpitTransitionsVisuals* self, GdkRGBA * result) {
	GdkRGBA _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_bg_color;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	*result = _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return;
#line 747 "TransitionsInterfaces.c"
}


static gboolean _gdk_rgba_equal (const GdkRGBA * s1, const GdkRGBA * s2) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1 == s2) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return TRUE;
#line 756 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1 == NULL) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 762 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s2 == NULL) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 768 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->red != s2->red) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 774 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->green != s2->green) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 780 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->blue != s2->blue) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 786 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (s1->alpha != s2->alpha) {
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		return FALSE;
#line 792 "TransitionsInterfaces.c"
	}
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return TRUE;
#line 796 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_set_bg_color (SpitTransitionsVisuals* self, GdkRGBA * value) {
	GdkRGBA old_value;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (self));
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (_gdk_rgba_equal (value, (spit_transitions_visuals_get_bg_color (self, &old_value), &old_value)) != TRUE) {
#line 806 "TransitionsInterfaces.c"
		GdkRGBA _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = *value;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_bg_color = _tmp0_;
#line 92 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "bg-color");
#line 814 "TransitionsInterfaces.c"
	}
}


static void spit_transitions_visuals_class_init (SpitTransitionsVisualsClass * klass) {
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_visuals_parent_class = g_type_class_peek_parent (klass);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_type_class_add_private (klass, sizeof (SpitTransitionsVisualsPrivate));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved0 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved0;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved1 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved1;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved2 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved2;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved3 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved3;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved4 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved4;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved5 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved5;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved6 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved6;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsVisualsClass *) klass)->reserved7 = (void (*) (SpitTransitionsVisuals *)) spit_transitions_visuals_real_reserved7;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spit_transitions_visuals_get_property;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spit_transitions_visuals_set_property;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (klass)->finalize = spit_transitions_visuals_finalize;
#line 846 "TransitionsInterfaces.c"
	/**
	     * Returns the starting pixbuf (the pixbuf currently on the display).
	     *
	     * If transitioning from a blank screen, this will return null.
	     */
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY, g_param_spec_object ("from-pixbuf", "from-pixbuf", "from-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 854 "TransitionsInterfaces.c"
	/**
	     * Returns the position of the starting pixbuf on the display.
	     *
	     * If transitioning from a blank screen, this will be zeroed.
	     */
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY, g_param_spec_boxed ("from-pos", "from-pos", "from-pos", gdk_rectangle_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 862 "TransitionsInterfaces.c"
	/**
	     * Returns the ending pixbuf (the pixbuf that the transition should result in).
	     *
	     * If transitioning to a blank screen, this will return null.
	     */
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY, g_param_spec_object ("to-pixbuf", "to-pixbuf", "to-pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 870 "TransitionsInterfaces.c"
	/**
	     * Returns the position of the ending pixbuf on the display.
	     *
	     * If transitioning to a blank screen, this will be zeroed.
	     */
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY, g_param_spec_boxed ("to-pos", "to-pos", "to-pos", gdk_rectangle_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 878 "TransitionsInterfaces.c"
	/**
	     * Returns the background color of the viewport.
	     */
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY, g_param_spec_boxed ("bg-color", "bg-color", "bg-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 884 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_instance_init (SpitTransitionsVisuals * self) {
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	self->priv = SPIT_TRANSITIONS_VISUALS_GET_PRIVATE (self);
#line 891 "TransitionsInterfaces.c"
}


static void spit_transitions_visuals_finalize (GObject * obj) {
	SpitTransitionsVisuals * self;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals);
#line 66 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_g_object_unref0 (self->priv->_from_pixbuf);
#line 80 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_g_object_unref0 (self->priv->_to_pixbuf);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (spit_transitions_visuals_parent_class)->finalize (obj);
#line 905 "TransitionsInterfaces.c"
}


/**
 * Visuals contains the pertinent drawing information for the transition that must occur.
 * 
 * A Visuals object is supplied to {@link Effect} at the start of the transition and during each 
 * call to paint to the screen.
 *
 * Note that if starting with a blank screen, from_pixbuf will be null and from_pos will be
 * zeroed. The transition should be considered to start from a blank screen of the supplied
 * background color.
 *
 * Also note that if transitioning to a blank screen, to_pixbuf will be null and to_pos will be
 * zeroed. Like the prior case, the transition should move toward a blank screen of the background
 * color.
 */
GType spit_transitions_visuals_get_type (void) {
	static volatile gsize spit_transitions_visuals_type_id__volatile = 0;
	if (g_once_init_enter (&spit_transitions_visuals_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsVisualsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_transitions_visuals_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpitTransitionsVisuals), 0, (GInstanceInitFunc) spit_transitions_visuals_instance_init, NULL };
		GType spit_transitions_visuals_type_id;
		spit_transitions_visuals_type_id = g_type_register_static (G_TYPE_OBJECT, "SpitTransitionsVisuals", &g_define_type_info, 0);
		g_once_init_leave (&spit_transitions_visuals_type_id__volatile, spit_transitions_visuals_type_id);
	}
	return spit_transitions_visuals_type_id__volatile;
}


static void _vala_spit_transitions_visuals_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SpitTransitionsVisuals * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	switch (property_id) {
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_object (value, spit_transitions_visuals_get_from_pixbuf (self));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY:
#line 948 "TransitionsInterfaces.c"
		{
			GdkRectangle boxed;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
			spit_transitions_visuals_get_from_pos (self, &boxed);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
			g_value_set_boxed (value, &boxed);
#line 955 "TransitionsInterfaces.c"
		}
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_object (value, spit_transitions_visuals_get_to_pixbuf (self));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY:
#line 967 "TransitionsInterfaces.c"
		{
			GdkRectangle boxed;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
			spit_transitions_visuals_get_to_pos (self, &boxed);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
			g_value_set_boxed (value, &boxed);
#line 974 "TransitionsInterfaces.c"
		}
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY:
#line 980 "TransitionsInterfaces.c"
		{
			GdkRGBA boxed;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
			spit_transitions_visuals_get_bg_color (self, &boxed);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
			g_value_set_boxed (value, &boxed);
#line 987 "TransitionsInterfaces.c"
		}
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 991 "TransitionsInterfaces.c"
		default:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 997 "TransitionsInterfaces.c"
	}
}


static void _vala_spit_transitions_visuals_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SpitTransitionsVisuals * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_VISUALS, SpitTransitionsVisuals);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	switch (property_id) {
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_FROM_PIXBUF_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_visuals_set_from_pixbuf (self, g_value_get_object (value));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_FROM_POS_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_visuals_set_from_pos (self, g_value_get_boxed (value));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_TO_PIXBUF_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_visuals_set_to_pixbuf (self, g_value_get_object (value));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_TO_POS_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_visuals_set_to_pos (self, g_value_get_boxed (value));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_VISUALS_BG_COLOR_PROPERTY:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_visuals_set_bg_color (self, g_value_get_boxed (value));
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 1037 "TransitionsInterfaces.c"
		default:
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 60 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 1043 "TransitionsInterfaces.c"
	}
}


SpitTransitionsMotion* spit_transitions_motion_construct (GType object_type, SpitTransitionsDirection direction, gint fps, gint duration_msec) {
	SpitTransitionsMotion * self = NULL;
	SpitTransitionsDirection _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 157 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	self = (SpitTransitionsMotion*) g_object_new (object_type, NULL);
#line 158 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = direction;
#line 158 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_motion_set_direction (self, _tmp0_);
#line 159 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp1_ = fps;
#line 159 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_motion_set_fps (self, _tmp1_);
#line 160 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp2_ = duration_msec;
#line 160 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_motion_set_duration_msec (self, _tmp2_);
#line 157 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return self;
#line 1069 "TransitionsInterfaces.c"
}


SpitTransitionsMotion* spit_transitions_motion_new (SpitTransitionsDirection direction, gint fps, gint duration_msec) {
#line 157 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return spit_transitions_motion_construct (SPIT_TRANSITIONS_TYPE_MOTION, direction, fps, duration_msec);
#line 1076 "TransitionsInterfaces.c"
}


/**
     * Returns a value from 0.0 to 1.0 that represents the percentage of the transition's completion
     * for the specified frame.
     */
gdouble spit_transitions_motion_get_alpha (SpitTransitionsMotion* self, gint frame_number) {
	gdouble result = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 167 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0.0);
#line 168 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = frame_number;
#line 168 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp1_ = spit_transitions_motion_get_total_frames (self);
#line 168 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = ((gdouble) _tmp0_) / ((gdouble) _tmp2_);
#line 168 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 1101 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved0 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved0 (SpitTransitionsMotion* self) {
#line 174 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 174 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved0 (self);
#line 1114 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved1 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved1 (SpitTransitionsMotion* self) {
#line 175 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 175 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved1 (self);
#line 1127 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved2 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved2 (SpitTransitionsMotion* self) {
#line 176 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 176 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved2 (self);
#line 1140 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved3 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved3 (SpitTransitionsMotion* self) {
#line 177 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 177 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved3 (self);
#line 1153 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved4 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved4 (SpitTransitionsMotion* self) {
#line 178 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 178 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved4 (self);
#line 1166 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved5 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved5 (SpitTransitionsMotion* self) {
#line 179 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 179 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved5 (self);
#line 1179 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved6 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved6 (SpitTransitionsMotion* self) {
#line 180 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 180 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved6 (self);
#line 1192 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_real_reserved7 (SpitTransitionsMotion* self) {
}


void spit_transitions_motion_reserved7 (SpitTransitionsMotion* self) {
#line 181 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 181 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_MOTION_GET_CLASS (self)->reserved7 (self);
#line 1205 "TransitionsInterfaces.c"
}


SpitTransitionsDirection spit_transitions_motion_get_direction (SpitTransitionsMotion* self) {
	SpitTransitionsDirection result;
	SpitTransitionsDirection _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_direction;
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 1220 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_set_direction (SpitTransitionsMotion* self, SpitTransitionsDirection value) {
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (spit_transitions_motion_get_direction (self) != value) {
#line 1229 "TransitionsInterfaces.c"
		SpitTransitionsDirection _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = value;
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_direction = _tmp0_;
#line 126 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "direction");
#line 1237 "TransitionsInterfaces.c"
	}
}


gint spit_transitions_motion_get_fps (SpitTransitionsMotion* self) {
	gint result;
	gint _tmp0_;
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_fps;
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = _tmp0_;
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 1253 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_set_fps (SpitTransitionsMotion* self, gint value) {
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (spit_transitions_motion_get_fps (self) != value) {
#line 1262 "TransitionsInterfaces.c"
		gint _tmp0_;
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = value;
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_fps = _tmp0_;
#line 131 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "fps");
#line 1270 "TransitionsInterfaces.c"
	}
}


gint spit_transitions_motion_get_duration_msec (SpitTransitionsMotion* self) {
	gint result;
	gint _tmp0_;
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_duration_msec;
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = _tmp0_;
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 1286 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_set_duration_msec (SpitTransitionsMotion* self, gint value) {
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (self));
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (spit_transitions_motion_get_duration_msec (self) != value) {
#line 1295 "TransitionsInterfaces.c"
		gint _tmp0_;
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		_tmp0_ = value;
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		self->priv->_duration_msec = _tmp0_;
#line 136 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_object_notify ((GObject *) self, "duration-msec");
#line 1303 "TransitionsInterfaces.c"
	}
}


gint spit_transitions_motion_get_total_frames (SpitTransitionsMotion* self) {
	gint result;
	gint _tmp0_;
	gint _tmp1_;
#line 143 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
#line 144 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_fps;
#line 144 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp1_ = self->priv->_duration_msec;
#line 144 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = (gint) (((gdouble) _tmp0_) * (((gdouble) _tmp1_) / 1000.0));
#line 144 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 1322 "TransitionsInterfaces.c"
}


gint spit_transitions_motion_get_tick_msec (SpitTransitionsMotion* self) {
	gint result;
	gint _tmp0_;
#line 152 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_MOTION (self), 0);
#line 153 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	_tmp0_ = self->priv->_fps;
#line 153 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	result = (gint) (1000.0 / ((gdouble) _tmp0_));
#line 153 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return result;
#line 1337 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_class_init (SpitTransitionsMotionClass * klass) {
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	spit_transitions_motion_parent_class = g_type_class_peek_parent (klass);
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_type_class_add_private (klass, sizeof (SpitTransitionsMotionPrivate));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved0 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved0;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved1 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved1;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved2 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved2;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved3 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved3;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved4 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved4;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved5 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved5;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved6 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved6;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	((SpitTransitionsMotionClass *) klass)->reserved7 = (void (*) (SpitTransitionsMotion *)) spit_transitions_motion_real_reserved7;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_spit_transitions_motion_get_property;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_spit_transitions_motion_set_property;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (klass)->finalize = spit_transitions_motion_finalize;
#line 1368 "TransitionsInterfaces.c"
	/**
	     * Returns the direction the transition should occur in (if pertinent to the {@link Effect}.
	     */
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY, g_param_spec_enum ("direction", "direction", "direction", SPIT_TRANSITIONS_TYPE_DIRECTION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1374 "TransitionsInterfaces.c"
	/**
	     * Returns the frames per second of the {@link Effect}.
	     */
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_FPS_PROPERTY, g_param_spec_int ("fps", "fps", "fps", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1380 "TransitionsInterfaces.c"
	/**
	     * Returns the amount of time the transition should take (in milliseconds).
	     */
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY, g_param_spec_int ("duration-msec", "duration-msec", "duration-msec", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1386 "TransitionsInterfaces.c"
	/**
	     * Returns the number of frames that should be required to perform the transition in the
	     * expected {@link duration_msec}.
	     */
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY, g_param_spec_int ("total-frames", "total-frames", "total-frames", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1393 "TransitionsInterfaces.c"
	/**
	     * Returns the approximate time between each frame draw (in milliseconds).
	     */
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY, g_param_spec_int ("tick-msec", "tick-msec", "tick-msec", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1399 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_instance_init (SpitTransitionsMotion * self) {
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	self->priv = SPIT_TRANSITIONS_MOTION_GET_PRIVATE (self);
#line 1406 "TransitionsInterfaces.c"
}


static void spit_transitions_motion_finalize (GObject * obj) {
	SpitTransitionsMotion * self;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion);
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	G_OBJECT_CLASS (spit_transitions_motion_parent_class)->finalize (obj);
#line 1416 "TransitionsInterfaces.c"
}


/**
 * Motion contains all the pertinent information regarding the animation of the transition.
 *
 * Some of Motion's information may not apply to a transition effect (such as Direction for a 
 * fade effect).
 */
GType spit_transitions_motion_get_type (void) {
	static volatile gsize spit_transitions_motion_type_id__volatile = 0;
	if (g_once_init_enter (&spit_transitions_motion_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsMotionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spit_transitions_motion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpitTransitionsMotion), 0, (GInstanceInitFunc) spit_transitions_motion_instance_init, NULL };
		GType spit_transitions_motion_type_id;
		spit_transitions_motion_type_id = g_type_register_static (G_TYPE_OBJECT, "SpitTransitionsMotion", &g_define_type_info, 0);
		g_once_init_leave (&spit_transitions_motion_type_id__volatile, spit_transitions_motion_type_id);
	}
	return spit_transitions_motion_type_id__volatile;
}


static void _vala_spit_transitions_motion_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SpitTransitionsMotion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion);
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	switch (property_id) {
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_enum (value, spit_transitions_motion_get_direction (self));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_FPS_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_int (value, spit_transitions_motion_get_fps (self));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_int (value, spit_transitions_motion_get_duration_msec (self));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_TOTAL_FRAMES_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_int (value, spit_transitions_motion_get_total_frames (self));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_TICK_MSEC_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		g_value_set_int (value, spit_transitions_motion_get_tick_msec (self));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 1473 "TransitionsInterfaces.c"
		default:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 1479 "TransitionsInterfaces.c"
	}
}


static void _vala_spit_transitions_motion_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SpitTransitionsMotion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SPIT_TRANSITIONS_TYPE_MOTION, SpitTransitionsMotion);
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	switch (property_id) {
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_DIRECTION_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_motion_set_direction (self, g_value_get_enum (value));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_FPS_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_motion_set_fps (self, g_value_get_int (value));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		case SPIT_TRANSITIONS_MOTION_DURATION_MSEC_PROPERTY:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		spit_transitions_motion_set_duration_msec (self, g_value_get_int (value));
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 1507 "TransitionsInterfaces.c"
		default:
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 122 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		break;
#line 1513 "TransitionsInterfaces.c"
	}
}


/**
     * Returns an instance of the {@link Effect} this descriptor represents.
     */
SpitTransitionsEffect* spit_transitions_descriptor_create (SpitTransitionsDescriptor* self, SpitHostInterface* host) {
#line 191 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self), NULL);
#line 191 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->create (self, host);
#line 1526 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved0 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved0 (SpitTransitionsDescriptor* self) {
#line 196 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 196 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved0 (self);
#line 1539 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved1 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved1 (SpitTransitionsDescriptor* self) {
#line 197 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 197 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved1 (self);
#line 1552 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved2 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved2 (SpitTransitionsDescriptor* self) {
#line 198 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 198 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved2 (self);
#line 1565 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved3 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved3 (SpitTransitionsDescriptor* self) {
#line 199 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 199 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved3 (self);
#line 1578 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved4 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved4 (SpitTransitionsDescriptor* self) {
#line 200 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 200 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved4 (self);
#line 1591 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved5 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved5 (SpitTransitionsDescriptor* self) {
#line 201 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 201 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved5 (self);
#line 1604 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved6 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved6 (SpitTransitionsDescriptor* self) {
#line 202 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 202 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved6 (self);
#line 1617 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_real_reserved7 (SpitTransitionsDescriptor* self) {
}


void spit_transitions_descriptor_reserved7 (SpitTransitionsDescriptor* self) {
#line 203 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_DESCRIPTOR (self));
#line 203 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_DESCRIPTOR_GET_INTERFACE (self)->reserved7 (self);
#line 1630 "TransitionsInterfaces.c"
}


static void spit_transitions_descriptor_base_init (SpitTransitionsDescriptorIface * iface) {
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (!initialized) {
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		initialized = TRUE;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved0 = spit_transitions_descriptor_real_reserved0;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved1 = spit_transitions_descriptor_real_reserved1;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved2 = spit_transitions_descriptor_real_reserved2;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved3 = spit_transitions_descriptor_real_reserved3;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved4 = spit_transitions_descriptor_real_reserved4;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved5 = spit_transitions_descriptor_real_reserved5;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved6 = spit_transitions_descriptor_real_reserved6;
#line 187 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved7 = spit_transitions_descriptor_real_reserved7;
#line 1657 "TransitionsInterfaces.c"
	}
}


/**
 * A Descriptor offers a factory method for creating {@link Effect} instances.
 */
GType spit_transitions_descriptor_get_type (void) {
	static volatile gsize spit_transitions_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&spit_transitions_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsDescriptorIface), (GBaseInitFunc) spit_transitions_descriptor_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_transitions_descriptor_type_id;
		spit_transitions_descriptor_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitTransitionsDescriptor", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_transitions_descriptor_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_transitions_descriptor_type_id, SPIT_TYPE_PLUGGABLE);
		g_once_init_leave (&spit_transitions_descriptor_type_id__volatile, spit_transitions_descriptor_type_id);
	}
	return spit_transitions_descriptor_type_id__volatile;
}


/**
     * Returns frames per second (FPS) information for this effect.
     *
     * If the min_fps is not met, the Effect may be cancelled or the host will skip ahead.
     *
     * @param desired_fps The desired FPS of the transition.  Return zero if no
     *        transition is to occur (instantaneous or null transition).
     * @param min_fps The minimum FPS before the effect is consider "ruined".
     *        Return zero if any FPS is acceptable.
     */
void spit_transitions_effect_get_fps (SpitTransitionsEffect* self, gint* desired_fps, gint* min_fps) {
#line 240 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 240 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->get_fps (self, desired_fps, min_fps);
#line 1694 "TransitionsInterfaces.c"
}


/**
     * Called when the effect is starting.
     * 
     * All state should be reset. The frame number, which is not supplied, is one.
     */
void spit_transitions_effect_start (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion) {
#line 247 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 247 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->start (self, visuals, motion);
#line 1708 "TransitionsInterfaces.c"
}


/**
     * Return true if the Effect needs the background cleared prior to calling {@link paint}.
     */
gboolean spit_transitions_effect_needs_clear_background (SpitTransitionsEffect* self) {
#line 252 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_val_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self), FALSE);
#line 252 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	return SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->needs_clear_background (self);
#line 1720 "TransitionsInterfaces.c"
}


/**
     * Called when the effect needs to paint (i.e. an expose or draw event has occurred).
     * 
     * This call should ''not'' advance the state of the effect (i.e. it may be called more than 
     * once for the same frame).
     *
     * @param ctx The Cairo context the Effect should use to paint the transition.
     * @param width The width (in pixels) of the Cairo surface.
     * @param height The height (in pixels) of the Cairo surface.
     * @param frame_number The ''one-based'' frame being drawn.
     */
void spit_transitions_effect_paint (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, cairo_t* ctx, gint width, gint height, gint frame_number) {
#line 265 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 265 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->paint (self, visuals, motion, ctx, width, height, frame_number);
#line 1740 "TransitionsInterfaces.c"
}


/**
     * Called to notify the effect that the state of the transition should advance to the specified
     * frame number.
     * 
     * Note: There is no guarantee frame numbers will be consecutive between calls
     * to next, especially if the transition clock is attempting to catch up.
     *
     * @param frame_number The ''one-based'' frame being advanced to.
     */
void spit_transitions_effect_advance (SpitTransitionsEffect* self, SpitTransitionsVisuals* visuals, SpitTransitionsMotion* motion, gint frame_number) {
#line 277 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 277 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->advance (self, visuals, motion, frame_number);
#line 1758 "TransitionsInterfaces.c"
}


/**
     * Called if the Effect should halt the transition.
     * 
     * It only needs to reset state if {@link start} is called again.
     */
void spit_transitions_effect_cancel (SpitTransitionsEffect* self) {
#line 284 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 284 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->cancel (self);
#line 1772 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved0 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved0 (SpitTransitionsEffect* self) {
#line 289 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 289 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved0 (self);
#line 1785 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved1 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved1 (SpitTransitionsEffect* self) {
#line 290 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 290 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved1 (self);
#line 1798 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved2 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved2 (SpitTransitionsEffect* self) {
#line 291 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 291 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved2 (self);
#line 1811 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved3 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved3 (SpitTransitionsEffect* self) {
#line 292 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 292 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved3 (self);
#line 1824 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved4 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved4 (SpitTransitionsEffect* self) {
#line 293 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 293 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved4 (self);
#line 1837 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved5 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved5 (SpitTransitionsEffect* self) {
#line 294 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 294 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved5 (self);
#line 1850 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved6 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved6 (SpitTransitionsEffect* self) {
#line 295 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 295 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved6 (self);
#line 1863 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_real_reserved7 (SpitTransitionsEffect* self) {
}


void spit_transitions_effect_reserved7 (SpitTransitionsEffect* self) {
#line 296 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_EFFECT (self));
#line 296 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	SPIT_TRANSITIONS_EFFECT_GET_INTERFACE (self)->reserved7 (self);
#line 1876 "TransitionsInterfaces.c"
}


static void spit_transitions_effect_base_init (SpitTransitionsEffectIface * iface) {
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	static gboolean initialized = FALSE;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
	if (!initialized) {
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		initialized = TRUE;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved0 = spit_transitions_effect_real_reserved0;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved1 = spit_transitions_effect_real_reserved1;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved2 = spit_transitions_effect_real_reserved2;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved3 = spit_transitions_effect_real_reserved3;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved4 = spit_transitions_effect_real_reserved4;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved5 = spit_transitions_effect_real_reserved5;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved6 = spit_transitions_effect_real_reserved6;
#line 229 "/home/jens/Source/shotwell/src/plugins/TransitionsInterfaces.vala"
		iface->reserved7 = spit_transitions_effect_real_reserved7;
#line 1903 "TransitionsInterfaces.c"
	}
}


/**
 * An Effect represents an interstitial effect that is used to transition the display from one 
 * image to another.
 * 
 * An Effect must hold state so that it knows what it should be drawn at any call to {@link paint}
 * (which is called regularly during a transition). That is, it should be able to draw any frame of
 * the transition at any time. The same frame may need to be drawn multiple times, or the host
 * may skip ahead and ask for a frame well ahead of the last requested one.
 *
 * ''Frame numbers are one-based throughout this interface''. This is because the initial state (the
 * blank viewport or the starting pixbuf) is frame zero. The Effect is never called to paint this
 * frame.  The Effect is also not called to paint the final frame (a blank viewport or the ending
 * pixbuf).
 *
 * If the Effect uses background threads for its work, it should use the appropriate primitives
 * for critical sections. All calls to this interface will be from the context of the main UI
 * thread. ''None of these calls should block.''
 *
 * If the Details object needs to be held by the Effect, its reference to it should be dropped at
 * the end of the cycle (or shortly thereafter).
 *
 * An instance may be reused and should be prepared for restarts.
 */
GType spit_transitions_effect_get_type (void) {
	static volatile gsize spit_transitions_effect_type_id__volatile = 0;
	if (g_once_init_enter (&spit_transitions_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitTransitionsEffectIface), (GBaseInitFunc) spit_transitions_effect_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_transitions_effect_type_id;
		spit_transitions_effect_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitTransitionsEffect", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_transitions_effect_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_transitions_effect_type_id__volatile, spit_transitions_effect_type_id);
	}
	return spit_transitions_effect_type_id__volatile;
}



