/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/SchemaTypesXml/ActionClassInstanceXml.h"

#include "Doc/SchemaTypesDoc/CActionClassInstanceCollectionDoc.h"
#include "Doc/SchemaTypesDoc/CActionClassInstanceDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/SchemaTypesXml/ActionClassInstanceCollectionXml.h"

using namespace Caf;

void ActionClassInstanceCollectionXml::add(
	const SmartPtrCActionClassInstanceCollectionDoc actionClassInstanceCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ActionClassInstanceCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(actionClassInstanceCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCActionClassInstanceDoc> actionClassInstanceVal =
			actionClassInstanceCollectionDoc->getActionClassInstanceCollection();
		CAF_CM_VALIDATE_STL(actionClassInstanceVal);

		if (! actionClassInstanceVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCActionClassInstanceDoc> > actionClassInstanceIter(actionClassInstanceVal);
				actionClassInstanceIter; actionClassInstanceIter++) {
				const SmartPtrCXmlElement actionClassInstanceXml =
					thisXml->createAndAddElement("actionClassInstance");
				ActionClassInstanceXml::add(*actionClassInstanceIter, actionClassInstanceXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCActionClassInstanceCollectionDoc ActionClassInstanceCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ActionClassInstanceCollectionXml", "parse");

	SmartPtrCActionClassInstanceCollectionDoc actionClassInstanceCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection actionClassInstanceChildrenXml =
			thisXml->findRequiredChildren("actionClassInstance");

		std::deque<SmartPtrCActionClassInstanceDoc> actionClassInstanceVal;
		if (! actionClassInstanceChildrenXml.IsNull() && ! actionClassInstanceChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> actionClassInstanceXmlIter(*actionClassInstanceChildrenXml);
				actionClassInstanceXmlIter; actionClassInstanceXmlIter++) {
				const SmartPtrCXmlElement actionClassInstanceXml = actionClassInstanceXmlIter->second;
				const SmartPtrCActionClassInstanceDoc actionClassInstanceDoc =
					ActionClassInstanceXml::parse(actionClassInstanceXml);
				actionClassInstanceVal.push_back(actionClassInstanceDoc);
			}
		}

		actionClassInstanceCollectionDoc.CreateInstance();
		actionClassInstanceCollectionDoc->initialize(
			actionClassInstanceVal);
	}
	CAF_CM_EXIT;

	return actionClassInstanceCollectionDoc;
}

