/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Dimension;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.standard.FigureChangeAdapter;
import org.jhotdraw.util.GraphNode;

public class GraphLayout
extends FigureChangeAdapter {
    public double LENGTH_FACTOR = 1.0;
    public double REPULSION_STRENGTH = 0.5;
    public double REPULSION_LIMIT = 200.0;
    int REPULSION_TYPE = 0;
    public double SPRING_STRENGTH = 0.1;
    public double TORQUE_STRENGTH = 0.25;
    public double FRICTION_FACTOR = 0.75;
    private Hashtable nodes = new Hashtable();
    private Hashtable edges = new Hashtable();

    private GraphNode getGraphNode(Figure figure) {
        return (GraphNode)this.nodes.get(figure);
    }

    private double len(Figure figure) {
        return (Double)this.edges.get(figure) * this.LENGTH_FACTOR;
    }

    public void addNode(Figure figure) {
        this.nodes.put(figure, new GraphNode(figure));
        figure.addFigureChangeListener(this);
    }

    public void addEdge(ConnectionFigure connectionFigure, int n) {
        Dimension dimension = connectionFigure.getStartConnector().owner().size();
        Dimension dimension2 = connectionFigure.getEndConnector().owner().size();
        int n2 = Math.max(dimension.width, dimension.height) / 2 + Math.max(dimension2.width, dimension2.height) / 2 + n;
        this.edges.put(connectionFigure, new Double(n2));
    }

    public synchronized void relax() {
        GraphNode graphNode;
        Object object;
        if (this.nodes == null) {
            return;
        }
        Enumeration enumeration = this.edges.keys();
        while (enumeration.hasMoreElements()) {
            object = (ConnectionFigure)enumeration.nextElement();
            double d = this.len((Figure)object);
            graphNode = this.getGraphNode(object.getStartConnector().owner());
            GraphNode graphNode2 = this.getGraphNode(object.getEndConnector().owner());
            double d2 = graphNode2.x - graphNode.x;
            double d3 = graphNode2.y - graphNode.y;
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            if (!(d4 > 0.0)) continue;
            double d5 = this.SPRING_STRENGTH * (d - d4) / d4;
            double d6 = d5 * d2;
            double d7 = d5 * d3;
            double d8 = Math.atan2(d2, d3);
            double d9 = -Math.sin(4.0 * d8);
            graphNode2.dx += (d6 += this.TORQUE_STRENGTH * d3 * d9 / d4);
            graphNode2.dy += (d7 += -this.TORQUE_STRENGTH * d2 * d9 / d4);
            graphNode.dx += -d6;
            graphNode.dy += -d7;
        }
        object = this.nodes.elements();
        while (object.hasMoreElements()) {
            GraphNode graphNode3 = (GraphNode)object.nextElement();
            double d = 0.0;
            double d10 = 0.0;
            Enumeration enumeration2 = this.nodes.elements();
            while (enumeration2.hasMoreElements()) {
                GraphNode graphNode4 = (GraphNode)enumeration2.nextElement();
                if (graphNode3 == graphNode4) continue;
                double d11 = graphNode3.x - graphNode4.x;
                double d12 = graphNode3.y - graphNode4.y;
                double d13 = d11 * d11 + d12 * d12;
                double d14 = Math.sqrt(d13);
                if (d14 == 0.0) {
                    d += this.REPULSION_STRENGTH * Math.random();
                    d10 += this.REPULSION_STRENGTH * Math.random();
                    continue;
                }
                if (!(d14 < this.REPULSION_LIMIT)) continue;
                d11 /= this.REPULSION_LIMIT;
                d12 /= this.REPULSION_LIMIT;
                d14 /= this.REPULSION_LIMIT;
                double d15 = 0.0;
                switch (this.REPULSION_TYPE) {
                    case 0: {
                        d15 = 0.5 * (1.0 - d14) / d14;
                        break;
                    }
                    case 1: {
                        d15 = 1.0 - d14;
                        break;
                    }
                    case 2: {
                        d15 = 2.0 * (1.0 - d14) * (1.0 - d14);
                    }
                }
                d += (d15 *= this.REPULSION_STRENGTH) * d11;
                d10 += d15 * d12;
            }
            graphNode3.dx += d;
            graphNode3.dy += d10;
        }
        Enumeration enumeration3 = this.nodes.keys();
        while (enumeration3.hasMoreElements()) {
            Figure figure = (Figure)enumeration3.nextElement();
            graphNode = this.getGraphNode(figure);
            if (!Boolean.TRUE.equals(figure.getAttribute(FigureAttributeConstant.LOCATION))) {
                graphNode.x += Math.max(-5.0, Math.min(5.0, graphNode.dx));
                graphNode.y += Math.max(-5.0, Math.min(5.0, graphNode.dy));
                Point point = figure.center();
                figure.moveBy((int)Math.round(graphNode.x) - point.x, (int)Math.round(graphNode.y) - point.y);
                if (graphNode.x < 0.0) {
                    graphNode.x = 0.0;
                }
                if (graphNode.y < 0.0) {
                    graphNode.y = 0.0;
                }
            }
            graphNode.dx *= this.FRICTION_FACTOR;
            graphNode.dy *= this.FRICTION_FACTOR;
        }
    }

    public synchronized void figureChanged(FigureChangeEvent figureChangeEvent) {
        Figure figure;
        if (this.nodes != null && this.nodes.containsKey(figure = figureChangeEvent.getFigure())) {
            this.getGraphNode(figure).update();
        }
    }

    public void remove() {
        if (this.nodes != null) {
            Enumeration enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Figure figure = (Figure)enumeration.nextElement();
                figure.removeFigureChangeListener(this);
            }
            this.nodes = null;
            this.edges = null;
        }
    }
}

