; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv7-linux-gnueabi -mcpu=cortex-m0 -verify-machineinstrs | FileCheck --check-prefix CHECK-T1 %s
; RUN: llc < %s -mtriple=thumbv7-linux-gnueabi -mcpu=cortex-m3 -verify-machineinstrs | FileCheck --check-prefix CHECK-T2 %s

define i32 @i(i32 %a) {
; CHECK-T1-LABEL: i:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    movs r1, #255
; CHECK-T1-NEXT:    adds r1, #20
; CHECK-T1-NEXT:    bics r0, r1
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: i:
; CHECK-T2:       @ %bb.0: @ %entry
; CHECK-T2-NEXT:    movw r1, #275
; CHECK-T2-NEXT:    bics r0, r1
; CHECK-T2-NEXT:    bx lr
entry:
  %and = and i32 %a, -276
  ret i32 %and
}

define i32 @j(i32 %a) {
; CHECK-T1-LABEL: j:
; CHECK-T1:       @ %bb.0: @ %entry
; CHECK-T1-NEXT:    movs r1, #128
; CHECK-T1-NEXT:    bics r0, r1
; CHECK-T1-NEXT:    bx lr
;
; CHECK-T2-LABEL: j:
; CHECK-T2:       @ %bb.0: @ %entry
; CHECK-T2-NEXT:    bic r0, r0, #128
; CHECK-T2-NEXT:    bx lr
entry:
  %and = and i32 %a, -129
  ret i32 %and
}

define void @truncated(i16 %a, i16* %p) {
; CHECK-T1-LABEL: truncated:
; CHECK-T1:       @ %bb.0:
; CHECK-T1-NEXT:    ldr r2, .LCPI2_0
; CHECK-T1-NEXT:    ands r2, r0
; CHECK-T1-NEXT:    strh r2, [r1]
; CHECK-T1-NEXT:    bx lr
; CHECK-T1-NEXT:    .p2align 2
; CHECK-T1-NEXT:  @ %bb.1:
; CHECK-T1-NEXT:  .LCPI2_0:
; CHECK-T1-NEXT:    .long 65407 @ 0xff7f
;
; CHECK-T2-LABEL: truncated:
; CHECK-T2:       @ %bb.0:
; CHECK-T2-NEXT:    movw r2, #65407
; CHECK-T2-NEXT:    ands r0, r2
; CHECK-T2-NEXT:    strh r0, [r1]
; CHECK-T2-NEXT:    bx lr
  %and = and i16 %a, -129
  store i16 %and, i16* %p
  ret void
}
