; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
;
; Exercise folding of memcmp calls with addition expressions involving
; pointers into constant arrays of types larger than char and fractional
; offsets.

declare i32 @memcmp(ptr, ptr, i64)

@i32a = constant [2 x i16] [i16 4386, i16 13124]
@i32b = constant [2 x i16] [i16 4386, i16 13124]


define void @fold_memcmp_i32a_i32b_pIb(i32 %I, ptr %pcmp)
; CHECK-LABEL: @fold_memcmp_i32a_i32b_pIb(
; CHECK-NEXT:    store i32 0, ptr [[PCMP:%.*]], align 4
; CHECK-NEXT:    [[PST_1_1_2:%.*]] = getelementptr i8, ptr [[PCMP]], i64 4
; CHECK-NEXT:    store i32 0, ptr [[PST_1_1_2]], align 4
; CHECK-NEXT:    [[PST_1_1_3:%.*]] = getelementptr i8, ptr [[PCMP]], i64 8
; CHECK-NEXT:    store i32 0, ptr [[PST_1_1_3]], align 4
; CHECK-NEXT:    ret void
;
{


  %pi8ap1 = getelementptr i8, ptr @i32a, i32 1
  %pi8bp1 = getelementptr i8, ptr @i32b, i32 1

  %cmp_1_1_1 = call i32 @memcmp(ptr %pi8ap1, ptr %pi8ap1, i64 1)
  store i32 %cmp_1_1_1, ptr %pcmp

  %pst_1_1_2 = getelementptr i32, ptr %pcmp, i32 1
  %cmp_1_1_2 = call i32 @memcmp(ptr %pi8ap1, ptr %pi8ap1, i64 2)
  store i32 %cmp_1_1_2, ptr %pst_1_1_2

  %pst_1_1_3 = getelementptr i32, ptr %pcmp, i32 2
  %cmp_1_1_3 = call i32 @memcmp(ptr %pi8ap1, ptr %pi8ap1, i64 3)
  store i32 %cmp_1_1_3, ptr %pst_1_1_3

  ret void
}


%struct.A = type { [4 x i8] }
%struct.B = type { [2 x i8], [2 x i8] }

@a = constant [1 x %struct.A] [%struct.A { [4 x i8] [i8 1, i8 2, i8 3, i8 4] }]
@b = constant [1 x %struct.B] [%struct.B { [2 x i8] [i8 1, i8 2], [2 x i8] [i8 3, i8 4]}]

define void @fold_memcmp_A_B_pIb(i32 %I, ptr %pcmp) {
; CHECK-LABEL: @fold_memcmp_A_B_pIb(
; CHECK-NEXT:    store i32 0, ptr [[PCMP:%.*]], align 4
; CHECK-NEXT:    [[PST_0_0_2:%.*]] = getelementptr i8, ptr [[PCMP]], i64 4
; CHECK-NEXT:    store i32 0, ptr [[PST_0_0_2]], align 4
; CHECK-NEXT:    [[PST_0_0_3:%.*]] = getelementptr i8, ptr [[PCMP]], i64 8
; CHECK-NEXT:    store i32 0, ptr [[PST_0_0_3]], align 4
; CHECK-NEXT:    [[PST_0_0_4:%.*]] = getelementptr i8, ptr [[PCMP]], i64 12
; CHECK-NEXT:    store i32 0, ptr [[PST_0_0_4]], align 4
; CHECK-NEXT:    [[PST_0_1_1:%.*]] = getelementptr i8, ptr [[PCMP]], i64 16
; CHECK-NEXT:    store i32 -1, ptr [[PST_0_1_1]], align 4
; CHECK-NEXT:    [[PST_0_1_2:%.*]] = getelementptr i8, ptr [[PCMP]], i64 20
; CHECK-NEXT:    store i32 -1, ptr [[PST_0_1_2]], align 4
; CHECK-NEXT:    [[PST_0_1_3:%.*]] = getelementptr i8, ptr [[PCMP]], i64 24
; CHECK-NEXT:    store i32 -1, ptr [[PST_0_1_3]], align 4
; CHECK-NEXT:    [[PST_1_0_1:%.*]] = getelementptr i8, ptr [[PCMP]], i64 16
; CHECK-NEXT:    store i32 1, ptr [[PST_1_0_1]], align 4
; CHECK-NEXT:    [[PST_1_0_2:%.*]] = getelementptr i8, ptr [[PCMP]], i64 20
; CHECK-NEXT:    store i32 1, ptr [[PST_1_0_2]], align 4
; CHECK-NEXT:    [[PST_1_0_3:%.*]] = getelementptr i8, ptr [[PCMP]], i64 24
; CHECK-NEXT:    store i32 1, ptr [[PST_1_0_3]], align 4
; CHECK-NEXT:    ret void
;



  ; Fold memcmp(&a, &b, 1) to 0;
  %cmp_0_0_1 = call i32 @memcmp(ptr @a, ptr @b, i64 1)
  store i32 %cmp_0_0_1, ptr %pcmp

  ; Fold memcmp(&a, &b, 2) to 0;
  %pst_0_0_2 = getelementptr i32, ptr %pcmp, i32 1
  %cmp_0_0_2 = call i32 @memcmp(ptr @a, ptr @b, i64 2)
  store i32 %cmp_0_0_2, ptr %pst_0_0_2

  ; Fold memcmp(&a, &b, 3) to 0;
  %pst_0_0_3 = getelementptr i32, ptr %pcmp, i32 2
  %cmp_0_0_3 = call i32 @memcmp(ptr @a, ptr @b, i64 3)
  store i32 %cmp_0_0_3, ptr %pst_0_0_3

  ; Fold memcmp(&a, &b, 4) to 0;
  %pst_0_0_4 = getelementptr i32, ptr %pcmp, i32 3
  %cmp_0_0_4 = call i32 @memcmp(ptr @a, ptr @b, i64 4)
  store i32 %cmp_0_0_4, ptr %pst_0_0_4


  %pi8bp1 = getelementptr i8, ptr @b, i32 1

  ; Fold memcmp(&a, (char*)&b + 1, 1) to -1;
  %pst_0_1_1 = getelementptr i32, ptr %pcmp, i32 4
  %cmp_0_1_1 = call i32 @memcmp(ptr @a, ptr %pi8bp1, i64 1)
  store i32 %cmp_0_1_1, ptr %pst_0_1_1

  ; Fold memcmp(&a, (char*)&b + 1, 2) to -1;
  %pst_0_1_2 = getelementptr i32, ptr %pcmp, i32 5
  %cmp_0_1_2 = call i32 @memcmp(ptr @a, ptr %pi8bp1, i64 2)
  store i32 %cmp_0_1_2, ptr %pst_0_1_2

  ; Fold memcmp(&a, (char*)&b + 1, 3) to -1;
  %pst_0_1_3 = getelementptr i32, ptr %pcmp, i32 6
  %cmp_0_1_3 = call i32 @memcmp(ptr @a, ptr %pi8bp1, i64 3)
  store i32 %cmp_0_1_3, ptr %pst_0_1_3


  %pi8ap1 = getelementptr i8, ptr @a, i32 1

  ; Fold memcmp((char*)&a + 1, &b, 1) to +1;
  %pst_1_0_1 = getelementptr i32, ptr %pcmp, i32 4
  %cmp_1_0_1 = call i32 @memcmp(ptr %pi8ap1, ptr @b, i64 1)
  store i32 %cmp_1_0_1, ptr %pst_1_0_1

  ; Fold memcmp((char*)&a + 1, &b, 2) to +1;
  %pst_1_0_2 = getelementptr i32, ptr %pcmp, i32 5
  %cmp_1_0_2 = call i32 @memcmp(ptr %pi8ap1, ptr @b, i64 2)
  store i32 %cmp_1_0_2, ptr %pst_1_0_2

  ; Fold memcmp((char*)&a + 1, &b, 3) to +1;
  %pst_1_0_3 = getelementptr i32, ptr %pcmp, i32 6
  %cmp_1_0_3 = call i32 @memcmp(ptr %pi8ap1, ptr @b, i64 3)
  store i32 %cmp_1_0_3, ptr %pst_1_0_3

  ret void
}
