; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=slp-vectorizer -S < %s | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-arm-none-eabi"

define <vscale x 8 x i32> @scalable(i1 %c, i32 %srcALen, i32 %srcBLen) {
; CHECK-LABEL: @scalable(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END12:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END12]]
; CHECK:       if.end12:
; CHECK-NEXT:    [[SRCALEN_ADDR_0:%.*]] = phi i32 [ [[SRCALEN:%.*]], [[IF_THEN]] ], [ [[SRCBLEN:%.*]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[SRCBLEN_ADDR_0:%.*]] = phi i32 [ [[SRCBLEN]], [[IF_THEN]] ], [ [[SRCALEN]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT78:%.*]] = insertelement <vscale x 8 x i32> poison, i32 [[SRCBLEN_ADDR_0]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT82:%.*]] = insertelement <vscale x 8 x i32> poison, i32 [[SRCALEN_ADDR_0]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLAT83:%.*]] = shufflevector <vscale x 8 x i32> [[BROADCAST_SPLATINSERT82]], <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
; CHECK-NEXT:    ret <vscale x 8 x i32> [[BROADCAST_SPLAT83]]
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  br label %if.end12

if.else:                                          ; preds = %entry
  br label %if.end12

if.end12:                                         ; preds = %if.else, %if.then
  %srcALen.addr.0 = phi i32 [ %srcALen, %if.then ], [ %srcBLen, %if.else ]
  %srcBLen.addr.0 = phi i32 [ %srcBLen, %if.then ], [ %srcALen, %if.else ]
  %broadcast.splatinsert78 = insertelement <vscale x 8 x i32> poison, i32 %srcBLen.addr.0, i64 0
  %broadcast.splatinsert82 = insertelement <vscale x 8 x i32> poison, i32 %srcALen.addr.0, i64 0
  %broadcast.splat83 = shufflevector <vscale x 8 x i32> %broadcast.splatinsert82, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  ret <vscale x 8 x i32> %broadcast.splat83
}

define <vscale x 8 x i32> @multiuse(i1 %c, i32 %srcALen, i32 %srcBLen) {
; CHECK-LABEL: @multiuse(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF_THEN:%.*]], label [[IF_ELSE:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[IF_END12:%.*]]
; CHECK:       if.else:
; CHECK-NEXT:    br label [[IF_END12]]
; CHECK:       if.end12:
; CHECK-NEXT:    [[SRCALEN_ADDR_0:%.*]] = phi i32 [ [[SRCALEN:%.*]], [[IF_THEN]] ], [ [[SRCBLEN:%.*]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[SRCBLEN_ADDR_0:%.*]] = phi i32 [ [[SRCBLEN]], [[IF_THEN]] ], [ [[SRCALEN]], [[IF_ELSE]] ]
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT78:%.*]] = insertelement <vscale x 8 x i32> poison, i32 [[SRCBLEN_ADDR_0]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLATINSERT82:%.*]] = insertelement <vscale x 8 x i32> poison, i32 [[SRCALEN_ADDR_0]], i64 0
; CHECK-NEXT:    [[BROADCAST_SPLAT83:%.*]] = shufflevector <vscale x 8 x i32> [[BROADCAST_SPLATINSERT82]], <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
; CHECK-NEXT:    [[X:%.*]] = add i32 [[SRCALEN_ADDR_0]], [[SRCBLEN_ADDR_0]]
; CHECK-NEXT:    [[BROADCAST_SPLAT84:%.*]] = insertelement <vscale x 8 x i32> [[BROADCAST_SPLAT83]], i32 [[SRCBLEN_ADDR_0]], i64 1
; CHECK-NEXT:    ret <vscale x 8 x i32> [[BROADCAST_SPLAT84]]
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  br label %if.end12

if.else:                                          ; preds = %entry
  br label %if.end12

if.end12:                                         ; preds = %if.else, %if.then
  %srcALen.addr.0 = phi i32 [ %srcALen, %if.then ], [ %srcBLen, %if.else ]
  %srcBLen.addr.0 = phi i32 [ %srcBLen, %if.then ], [ %srcALen, %if.else ]
  %broadcast.splatinsert78 = insertelement <vscale x 8 x i32> poison, i32 %srcBLen.addr.0, i64 0
  %broadcast.splatinsert82 = insertelement <vscale x 8 x i32> poison, i32 %srcALen.addr.0, i64 0
  %broadcast.splat83 = shufflevector <vscale x 8 x i32> %broadcast.splatinsert82, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %x = add i32 %srcALen.addr.0, %srcBLen.addr.0
  %broadcast.splat84 = insertelement <vscale x 8 x i32> %broadcast.splat83, i32 %srcBLen.addr.0, i64 1
  ret <vscale x 8 x i32> %broadcast.splat84
}

