; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -global-isel -mtriple aarch64 -stop-after=irtranslator -verify-machineinstrs %s -o - | FileCheck %s

; Make sure we treat <1 x N> getelementptrs like scalar getelementptrs.

; We should not create a splat vector for the non-vector index on this
; getelementptr. The entire getelementptr should be translated to a scalar
; G_PTR_ADD.
define <1 x i8*> @one_elt_vector_ptr_add_non_vector_idx(<1 x i8*> %vec) {
  ; CHECK-LABEL: name: one_elt_vector_ptr_add_non_vector_idx
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $d0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $d0
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY [[C]](s32)
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s64) = G_SEXT [[COPY1]](s32)
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[SEXT]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[PTR_ADD]](p0)
  ; CHECK:   $d0 = COPY [[COPY2]](p0)
  ; CHECK:   RET_ReallyLR implicit $d0
  %ptr_add = getelementptr i8, <1 x i8*> %vec, <1 x i32> <i32 1>
  ret <1 x i8*> %ptr_add
}

; We should not create a splat vector for the non-vector pointer on this
; getelementptr. The entire getelementptr should be translated to a scalar
; G_PTR_ADD.
define <1 x i8*> @one_elt_vector_ptr_add_non_vector_ptr(i8* %vec) {
  ; CHECK-LABEL: name: one_elt_vector_ptr_add_non_vector_ptr
  ; CHECK: bb.1 (%ir-block.0):
  ; CHECK:   liveins: $x0
  ; CHECK:   [[COPY:%[0-9]+]]:_(p0) = COPY $x0
  ; CHECK:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; CHECK:   [[COPY1:%[0-9]+]]:_(s32) = COPY [[C]](s32)
  ; CHECK:   [[SEXT:%[0-9]+]]:_(s64) = G_SEXT [[COPY1]](s32)
  ; CHECK:   [[PTR_ADD:%[0-9]+]]:_(p0) = G_PTR_ADD [[COPY]], [[SEXT]](s64)
  ; CHECK:   [[COPY2:%[0-9]+]]:_(p0) = COPY [[PTR_ADD]](p0)
  ; CHECK:   $d0 = COPY [[COPY2]](p0)
  ; CHECK:   RET_ReallyLR implicit $d0
  %ptr_add = getelementptr i8, i8* %vec, <1 x i32> <i32 1>
  ret <1 x i8*> %ptr_add
}
