# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

"""genetic.prog -- module for genetic programming
"""

import operator, random, UserList, copy
from genetic import organism


class MutableOrderList(organism.Chromosom, UserList.UserList):
  """MutableOrderList implements a list; the order of its items can be
changed (by mutation, ...) but the number and the value of these items
don't change.
Usefull for TSP (see demo) !
"""
  DEFAULT_GENES = {
    "__crossover__" :  0.0 ,
    "__mutation__"  :  0.6 ,
    "__loss__"      :  0.0 ,
    }
  def __init__(self, **genes):
    UserList.UserList .__init__(self)
    organism.Chromosom.__init__(self, **genes)
    
  def useless(self): return 0
  
  def crossover(self, other): # No cross-over here !
    pass
  
  def checkmutate(self):
    newdict = self.checkmutate_object(self.__dict__)
    if not newdict is self.__dict__: mutated = self.__class__(**newdict)
    else:                            mutated = self
    
    for i in range(len(self)):
      if random.random() < self.__mutation__:
        if mutated is self: mutated = self.__class__(**self.__dict__)
        mutated[i - 1], mutated[i] = mutated[i], mutated[i - 1]
    
    return mutated
  
#  def __repr__(self):
#    return organism.Chromosom.__repr__(self) + "    \t : %s\n" % (gene, value)
      
