// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <array>

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 4>, 1280> hypergeometric_2F0 = {{
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.3943300261077013584267012717002038584011e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.1288074415453579939659035904973256538749e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.6611745543614506068714120519075056819550e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.5457479850061401970225922839343737383427e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(7.7635659556434543079371866945447478779323e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.9371161179717812336270934717521291586710e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.1349416737435136788732250938876799030561e+16) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.8415173440760341442711964780042686256393e+16) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.4596067098813351124340440200079189674532e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.3038462901451313148189528672455581460301e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.9569369804956199686427815514222403549919e+09) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.9284978646136702164674383903141303554929e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.1625366397762522765902141066188386626434e+14) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.5805805296483196422592484674884796413424e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.7911630751565900334275720051243482599803e+15) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.8906571692330664641407549050101998647921e+16) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.6411579346720533138878729479437884000014e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-1.4498889284574548017751610267446757499345e+10) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-8.3271771544924746163648576624345911602483e+08) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.6533879135313327889264355749808128862831e+11) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.8905411332958948419647385805622296944304e+11) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.2763846423947949314812868012344280025195e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.9448274771935190815787671410141118911850e+12) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.4068291586513926253394784159870993730124e+13) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.4442190955932690782916374666746273846054e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.5725267498751219389751144115701097822318e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(9.6954763100480713484374377692862818281273e+21) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.2755413189325955091373101138089162194080e+22) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.7332236712188806226961791606277136045724e+22) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.5873025103502227350310870404349076380829e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.8017897972969793297922930940024278809438e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.1759244390232399855359214672561788003397e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.1965273427572815946177339662586119595803e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.3416248088165165558809062161128323826914e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.0467131971672301640619522612322679183991e+22) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.8407881012739617191207992172450705302152e+22) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0525323522318999802948737022940077244959e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.7296005318029860509993659490576509505474e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.4160612309089654365905288987042851260483e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.1431911411962516399275447876206070683422e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.7999157114204999148697889034814804499921e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.7239237289040412610682510219640377424521e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.2343577878680828329068947938677151975421e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.6667482322583481879890100213482167892849e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.3520268844062748298404564289091575689607e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.2646881992982808629124234354097106416734e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0658858172534853974127290736369668903130e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.4375197415456047413913394799460379221843e+27) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(7.3786591898299896238593100048027881305181e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.7368727839345706439241212744583796125379e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.8364316562009418746235294154923748764043e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.7315825045915682111841670601140012985993e+23) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.7438357165050574006649389742432799768994e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.3579978559196747745377519234657577413416e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.3728673285719139840665877445839628377320e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.8502374002264755291022160489678151030887e+27) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.9315664575945933355101551429997102491750e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.5213781908174696660754597448989523754299e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.4892939741714194856708644205125953506376e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.7779755812967212898206918145773749019426e+24) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0205267618122557435737957108337499637003e+25) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.4288814664612971878953369344414386237390e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(7.9584263108596144697880142413317892493490e+26) },
      { SC_(-2.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0674451782175161706260556600087827374434e+28) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.2064814428783291408964503690687194956553e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(7.8372332215466866437363226118467662887139e+11) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-2.3263879881496642875712530901605392593156e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.3304163020442691588885099497836477008692e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.8734624075969716173632539649815938316097e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.1766045512427460876523589050447245046190e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.0187854778761142470775209898600795101794e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.0170907147595870335385974246510427304635e+16) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.3792238272468620202037233977501796657607e+11) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.4719427768929355434784960062442489718524e+11) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-5.6686101144573645804123768549811536355809e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.4554754909904974099125306890035352496074e+13) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.5886333938517995678665611347646489315746e+14) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.6830104414210582938077442956908202615525e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.1202801133006275955507792101138727943361e+15) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0337744476806331642126494106920082741196e+16) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.2928683690511577826314701051603248237475e+10) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.8843183754510977878028380908541213900309e+09) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-2.9624133340306820210230223465401298637704e+08) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.3591889190205943720568426401468863488714e+11) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.4884101550577940417728296085570395407400e+11) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.6352482096993225038574638100289215837746e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.9653886184791891410428396827850069505559e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.9269763305159866283377339316286447203439e+12) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0203023873065713142858391261737933677072e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.7145495664846983529087085719430518398125e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.3810536130577687559337570714756595966496e+20) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-6.5354819329731953428611827606531924319473e+20) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.2758086880474535254192669887607127632419e+21) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.0239479645971903930524467809730165709926e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.4766024900122273492148893454742305192502e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.7694487510628045128053615836051029527142e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.1143814167342208887826826205743870975947e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.3907711617373001215822215538249571085811e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1071481684446243945083825179903990788026e+21) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.4195612875768715576331147333738581655166e+21) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-4.9355648216202385078939288218737213333676e+21) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.2113236072916401498033900884146141752267e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-3.1877150006699819548663892354677344658772e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.8110999204921628181971992660994040568950e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.1691070606186171906921451725449226378778e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4245686692297847832607716789291658656017e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1107793973702254664099702561658237211931e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.6863840656327865771893643761431619533067e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-5.8347711656481242754623805070700992584572e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.5800086745097343156398790021722450381607e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-3.7149444337553371625761602901481605453331e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.4094440342950485907173269638268459006180e+25) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.7358927444336817116518139879938899871383e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.7965378880666067789687368485810607025281e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.3979970335111973018767821111980825921616e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-2.1576576747727851083832655394274450327451e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.4617915642653070331536369201905076192785e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.2951998457923642777000563141177574103923e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-4.7442161223113489733754620628208056682318e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-5.6271617449758289880578703965251685494539e+25) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3718702405485909671890727434081813825444e+25) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.9992748718886780411753964761917128777820e+24) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.9076246104879867723959571342559174263112e+22) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.1926425238315699254449936253469764300594e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-4.1111084062762318571887918053897336471445e+23) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.7996307894164065313512447693058011462684e+25) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.5890201049814890195892694796649881794780e+25) },
      { SC_(-1.9000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.0561031007536501144359554106020176005729e+26) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.4142272542796382055834011636284187963561e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-1.0247462160791433801424287955696712593563e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-3.2293272649938817718307009458766299377390e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.7088858371056294232998979999746704942906e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0010886860225133413676326441415225761172e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.0556175024178584678488602212326250229038e+15) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.3295425326471633862681720750645515370719e+15) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.4773831214835564001467854409852797612222e+15) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.1132408881017156830291508596479421221777e+11) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.0981408391214605962596589511223676867036e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-2.2264328864618431920358665963923400135902e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.7231480476293324660396956988960633526890e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.7167607026525559498989343264886472446014e+13) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.7934852868335470774367527187471160837541e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(7.2683223216777297390053505997983516495219e+14) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.4465832286352104139085286980965240214883e+15) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-5.0899944211907516744228088758785275991138e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-3.7461535565912584628469254484081951173521e+09) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-7.1652156669090042605845915200077015721750e+07) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.6915686962225403575217385366697873161501e+10) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.2156686293229989570472562013970448311187e+11) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.8130072263666921193250783211592089687359e+11) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.3713472702577007402149608156244481701615e+11) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.2596009700454825229478129802403484295269e+12) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.3934778777673803743608920047818672875065e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.9574345476806160253793335468469273852513e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.0795776385934024562322319264862046202070e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.4624096929067232365680037469869405633955e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.1313573861388065141698142042245294472250e+20) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.1889552498557305606318849061359930729693e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.9282779645681711853361636324774065840853e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.2521400367987144494647543734507778339758e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(8.8673793778329189739157762086628101009390e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.9660149128357459290840327107020270185009e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.1706943252589360602045220194305325042602e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.3287105609433743333986685391657454813995e+19) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.3909149506035821412124384868750417626338e+20) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.8149208207282838653443140224345948845920e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.2470406107196937965897552906590254575268e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.3120905918364138689833055268032546900006e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(8.3406529960660254141878271808647837502681e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.6029316609285996976558136572636332728212e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.6755955270228991399490183834256132346161e+20) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.9920151546935117719344258032408219274848e+20) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.5945116233367821026923932470327442388811e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.4391785967800825484586020481910840759296e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.3338145900358875349262294509477173679426e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.3931849409849209310243313359566816412603e+24) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0427385817396714077008791653966872018229e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(7.0036663649005734594427291737039822957057e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.0801905491182147068256672145543106439638e+20) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.0136118986240624762682066606334338493930e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.2889913666173525284294695910278477672001e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.1950295965807774813607148113669178973040e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.6884614081276962109277907265049732106587e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.7623647473288686001951860854748921722751e+24) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.9124850903153076812371328807813680782888e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.2961586607947217794552886626775248639327e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.2868280900414334561628844586162151617529e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.2655308354351583460694075029996646429182e+21) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.7029967463887129834303984584341236976182e+22) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(6.1333322856670486818154569877294282881184e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.6591784178953692105681412795289896985703e+23) },
      { SC_(-1.8000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.9945455257354212958541642882110142948713e+24) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-8.1461345243066326252929938987181813151305e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-5.9975531760211909163863102671660047975559e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-6.4238832326856107495192425797757762556304e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.5642310420604012939918769674419391964230e+13) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.2651893819800849924104166557087213666420e+13) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.2578537690017413211647146765260380021923e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.0817057192060795439095177420812789656692e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.9194263226098611874382941605979937807936e+15) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-6.2047499449141486378660202517653237619149e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-4.3051838875731366166794352881074132623484e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-8.0156677761223248174106590447515788536565e+07) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.3493807674200391767944211672790373646782e+12) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.9291187659279086379173514822250652169169e+13) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.8559582958395340504197192809251594796734e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.3169698578169653584211921101429075847969e+14) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0629369605122160971658668156314190883056e+15) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.3508467509000797159063299226321392074326e+09) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.5607477263250147986639044578614778963474e+08) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-4.8699805979664850584279283622750044472299e+06) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.1523306808906073111729935442272996410722e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.6757750960234813228641001593217706120551e+10) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.5540888404221089611611573386222717230109e+11) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.2527808204480026676785079445805056131048e+11) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.4561663670526062897860363164776306194702e+12) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.9534103567370706889760505194512262749249e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.3449507681544183731696141076943250104568e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.8190249352761654031780783657104911121010e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.8989765998525645306027421264968673245673e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-5.8219478621260971362948001233021248188690e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.7735373504141050677594530984558495622609e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.4631552837733726379892447633709434594270e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.2859337329956566940772624385229862605119e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.8365617519757583901620425866079202734027e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.6401929197164995275704070629794858902904e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.5466554405924155809105910244473798020413e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-3.9134160647487578286355038728280970463313e+18) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.1978730349872324262844745024188965484769e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.6333483878310705725772140548163470072655e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-5.0442404398532322877841351371867439320947e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.6702251060494379200678670787187846819480e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.2999620242648003503271158438275713813419e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.2673873371230938595404489287774141508430e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.9827728171355497808828540619032438977608e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-3.9066144446647511373990875937491766292808e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.1898651309261624858184878165972809541328e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.5609428952179435822024486377641518099078e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-4.9379685836373830863044839572473553874808e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.5382914999293724267738978091028982389759e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.0881878313659193551068471606510904698856e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.8085507288641383895964987068082442837662e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.6872233727807909444408204436632357939153e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-4.9100589240487051897991193920733419851065e+19) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.4947696884770715549602650253676374407203e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-4.4676125581814155806361563936162740493358e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-6.1945498274380602177377353836555902951501e+21) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-5.6890980670490207341225577381801447828321e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8064108530403634351239792563711594955590e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.2397246662165492774463622209453739740637e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.6054615576727689261164528610085543882925e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-2.3927042122957938608033523659105200566002e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.2602467432222735591247124183667062183820e+20) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.1508232506937173573232201041806904952971e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.9799261240313965832386539123067005466019e+22) },
      { SC_(-1.7000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.7235152636132201411267468457358315740814e+23) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.9079745892369108714608399867745721262542e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-1.2092798546542624282528715126217997858452e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.9416640576620024948581350940840999480136e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.8521606397648672681008182577291543285339e+12) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(9.9163636619849731528879800266374770388387e+12) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.2748849962757076393134139290969698639583e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.1548395974405855488909897160321012429046e+14) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.2070540046454679424023723198658034968071e+14) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-4.9438665067772928250191457451062269345934e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-2.2589965246336659698609333804467889857544e+09) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.1487866423241777337994971252654237090907e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.0015353698016387393070226752003127820502e+12) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.0704375365765554010234215010825369590062e+12) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.4949221272717595420494408603997280541431e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(6.8199152313569288949729482447507368749766e+13) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.0077915465585768891590446601199566936296e+14) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.6933533739375856915973653134410669614305e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-1.0339719556406461378425206452671298759338e+08) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.3675651509791873923680449351099356987219e+06) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.4139221372751844245379480025125109617676e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.5192360743812125237536616845150031302078e+10) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.5299048766452389634245278455548422356597e+11) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.8254829188739039347878040571093749866406e+11) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.1348089629519387044403304435421586236815e+11) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(8.9768440705663992351160603121885229661326e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.3216283041840696530690323796968646208495e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1100190698263012152448212261889592223969e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.0796034403411210223296034542033365903983e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.1052773020331295761608881020207488581586e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.7809030106657244868885368130548247899441e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0604754245638963918549611618418166532830e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.6593264878736305562122516659863384121401e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.7141156263359218096482513239440433342048e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.2064920887722585034125348140876354796928e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.1040625712253607581855147521936795097460e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.1640836737317292268626093525727377244106e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.2145187098187451617159399842586907705552e+17) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.5503805587853060542189454053532424861769e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.1122448016835117679064230142531021158715e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.7206230362639162760925471695484632139803e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3444830204952831100744394828787434482351e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(9.4484633453271261059067221112412548632047e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.6135656050126948339779487989581497126303e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.9716892070436269660871192234408235319444e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.6337293626158485496167338173059865657451e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.3865967366577601396817329274539442133445e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.8868904670330563130666787758367999512386e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.5256869207731057742636232956107132287427e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.6500863171436724602982876256230879319306e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.1594371807012233646070187898059937080254e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.9760429163696869599206561123363092915870e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.4550977471243744378364035896955731997506e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(7.0115758189919046665425923081723740584423e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.7234595150417781802406657120780007955979e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.3450295341476674576662988063291292908761e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.8947648078995094122838996572780059578470e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.8258914583127799737669379698686688504707e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.7913566627952798451487996059886881389890e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.0553628859798656528372616493586058133268e+18) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.1200551372945350727319380788340258680341e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.1882852152051542879725095193049991865740e+19) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.7675768132815857603954550717646949727517e+20) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0560843501474222802057720806657439254844e+21) },
      { SC_(-1.6000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.4916502401833614765335446326475050872668e+21) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.9389019437981574185114743344136275215952e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.2890484530195815432603859593634648559508e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0681138319689241581898042207586396073196e+08) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.3987520305962680820187244634863350117243e+12) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.7898249217543488854885775974179339597088e+12) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.4203608503217552248800465117773056498324e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.9917601234834647251451708978897856585484e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.2835505557335981809683581501288872651241e+14) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.3454979930912826577975933905734346883487e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.2967516720837351231074894412324390057238e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.2108216957923990503892323329779544749742e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.9651306407027607618326008004087564995094e+11) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.7716494667496276309917374830941447775187e+12) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.4934664596117098437882921597156073339187e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.8408704129783286670581292390305069047666e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(7.7474589996902288254673396223778155545933e+13) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.7745343757276495908412139565738832782850e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.1812282257834125684065402731940022379890e+07) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.7709638444265014630349714289950779989186e+06) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.0044442640902920720543360070371425962553e+09) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0567291565621956514849908210000428869044e+10) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(6.1880870283143518542179259921650358471177e+10) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(7.3586056649977325904534155151928496139341e+10) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4179511297982289799340903976173631228984e+11) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.2684062924348004905914444009513410779594e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.0743129103944075893751577718189432762761e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.0050552292666853661335682623604952616174e+15) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-6.3712003560697493979092050603522228216403e+15) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.7190965285710175864538673571688431542339e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.5421448247024651697638217173390150320411e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-4.7374595794678046213220514603034010656854e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.4030920150301910017755872412518986233927e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(7.9164415334795922178911181089497648843001e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.6988905515342175702426603138313962856354e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.2896546829751278950574641028100518009902e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.2409618321973031736994831309590281577354e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.3429243987252483320700287203108297962242e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-6.8576036280204920397185565190705763087766e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-9.1682216301150281115587786971154466010769e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-6.5699186719032645692454511079790957609873e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.6455441225160175343900805228441771920868e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.0577674962315678037968328134911373751930e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.9920869154429246718607671590377278778306e+16) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.0286122266718868906108898751594219028758e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.7569450950873279387012241088258395272248e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-5.5790077168108943188709552358624164874220e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-7.4500111404176013720665707764216718506625e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-5.2989336115762091536402359445674381583743e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.8621900367946899859276576147806920611320e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.9314993473389974175056228082074395790424e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0906338801638178398482175978829114112527e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.2685008524042204461831093239055931398405e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.3982534943900813193655816295660299459493e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-6.8677433827336855345225982899221547387765e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-9.1698998124752316861859539527924610249767e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-6.5175378310869738958868432667081105501760e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.6524393196327034995982652376276133255691e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.9042438647211291752931708250199136337166e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.1546454190108706646805180962405789966935e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-5.4063965871180560329014861525486744084367e+17) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.4435849705834156957279880163411636205777e+18) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.8916187396482837294284731952457876089726e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-3.8579559071550807579612154034157517052153e+19) },
      { SC_(-1.5000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.7287410399556499024387483851739994684264e+20) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.0778686914901580923608162281680934293217e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4239985866229755546800495727368489437117e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-9.8720571726693942664414460362182115995675e+06) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.7317172893990192240221399096057542200083e+11) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(7.2387112407968873344563564709406298235007e+11) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.7588077248965935227772180244944853264918e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(7.0583095931355650652188463978375902336851e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.8573499094415505979007406374014142135015e+13) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.5152632304468569390914718070764485575993e+08) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.0014470802590891001232839757145186828197e+08) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-1.7993430985051125825851866983090070471382e+07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.4799661416093441414746526344364647356946e+11) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.7722663640415517717438798054053742368913e+11) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.7042057648770177144039671535291085853956e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.5292589006626850841054084026926520448385e+12) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.8039977508247471724287525455312881822805e+13) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.1625978440146847475660286353293719808876e+07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.3986231391039210334697397291982125357156e+07) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.9935332464187183993274402072342218243912e+05) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.3992618809947221430274518020949935643809e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.1613799829837359850526761045376439803061e+09) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.3331222181354003048828639796599458025218e+10) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.7631085261875038039710572437481021299893e+10) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.8345853528082101943163318760556308002737e+10) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.1024024513520103097671909873005754070494e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.5486674128598132573417512736514301410910e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.5767098555308158117132788107467183307636e+14) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.9088699538812665341276658901285132388413e+14) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(9.8928884355486911421318283777147016052820e+14) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.6756748799214752221915507018842991152846e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.1992050607129089949870267925580132116420e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.3895158100031135027838585887171521225152e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.7833788481672887574781153566508272868871e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.7854765508040336833713828098832063453461e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.1753801526603847773407804037963955343544e+14) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.3898154195760286725433800352948114198434e+14) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.8671842938340869509289889545422634040633e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.1485774289641450866190089467740286429731e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.1306866938503214724475804342538477395570e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.6034951271491998892931650058336392878626e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.4453859995389593256787143991195608247178e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.7975846346813338669498779585445012438877e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.1666588311730346838433413718850825805446e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.5533894546875453904910485001372015669533e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.3960712853055942107872401800448216865167e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.3221313544515093501398964636359026557496e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.0428418745538137872703022856061437188159e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.9035107467181760900956266410619531541327e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.9429220175847995601948136824336181771016e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.1629970363579248678820733139192152102968e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.2045222619403928262072391901361269659687e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.7804838124051873583326059819042419500521e+15) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.7037205428492260257533061789660903575174e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.8301291809084783625788329980476928067406e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.7080824823975088396527543268917249784476e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.3179951164330613610667665320862775505290e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0607346306745962058148672671970381653013e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(7.7884009183208905736194990302046253290282e+17) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.2042584194877312102143936820325794649907e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.6936299090668528925734732659847615722466e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.7460025485138664656166186482639177562764e+16) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.1107090871436356920194245133124150982274e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.4541517805035385281576045830722990741144e+18) },
      { SC_(-1.4000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(9.0461358727621913952130532806922894326821e+18) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-3.1480936729864766659204837930667088252491e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-2.7635977176921170732295293421893074093971e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-1.4289151615084249176368120773082424029261e+07) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.1844263010609324194206305992155596227031e+10) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.7264935283839609997500876394609794294299e+11) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.2446982788957392454894786790431563736447e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.5108678564516815912679098047107247074455e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.7217290392389549469833808033241530032128e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-3.6443999732794693081853112301275521005674e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-2.8910372613748136721014449864018246627135e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-8.2280544688084257691044535991684485855632e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.3302050991577828093812689021125752989787e+10) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.1819244897319664691492727452753649251451e+11) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.3470401207947497767745863268856072694783e+11) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0111987182792738708067334401394194848846e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.7786564210094180363857564979445460683207e+12) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.8752780737015786584519348343025457578910e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.1215977252417326742539665908045076141461e+06) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-2.2257210522917173056032972804877940181858e+05) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.9605062454005466183085952532623906542959e+08) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.5274861691140390978140943271567458508777e+09) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.1279809281768868928785172795087778204662e+09) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.5782063305601692682698920966043659380042e+09) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.9618617512532647762412431993351223312722e+10) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0739948549634191623406144680444530616621e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.0906881194377358219988202268776389494242e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.0992429196188062257835685583613490878587e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-2.4973168792324761154902480205676205539723e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-5.9276435431763388002405277352946240209577e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-8.2508036524692465588612828389625961965494e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.0625653587697564598508144186357469165553e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-5.9038928263370546797049369550243872256609e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8732117177159513635246441632652744375376e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4104168023634947353499877319192060978995e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.3657788721575797666677964369684819703838e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-4.5769701551290385092651811234360624508381e+13) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.0845806046222643705277113865924091339370e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.5028661205589584871131051985282431575236e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.9346849986552812158680592559958008009539e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.0723130391456235406200582309150133822682e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0936773374803043434701366640749542042026e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.2219587413971736620269056222550575243365e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.0635295469862717021413273826207383744199e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-3.1068222403210722895337048228974760040508e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.3246666112958804299573117134534086452331e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.0011040435597498480373350256637240914351e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.2872190473047848065140244685721183049773e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-7.0810358000099501116938320276642337357793e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3027340779907767937982505997475723476047e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(9.7921410884791518676570646056708693662652e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.6413678215804914199552687877147114021828e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-3.7542752834671896124015509581367673318161e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-8.8467939031254329382277246334443578344799e+14) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.2075540781019006923494083944952372900576e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.5524957792814084014664897597979287095792e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-8.5341931913120905501140076229243817607134e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.3691073303832416801052287007605266237074e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.2808314613632111995890738078891688615437e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.2039331844779444900414262908575756549229e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.3867717756420045210130810921776003648685e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.2571722411767208944782894478135811923508e+15) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-4.4067936783213007383396593241764086235159e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-5.6612756556139028301223910262979535585113e+16) },
      { SC_(-1.3000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.0970360128577092711718949406975130455153e+17) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-2.0020222382938053714445495584697411837270e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-1.3858068184010755648706518334772669449879e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.5019858149657931974849348247810158980264e+06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.0811859735602263520977966149456211329740e+10) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.7778476521440379910946275300808617296123e+10) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.4397083750564068878245164152753620716971e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.9294308337699244010490317785632976203795e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0292580918250151944697542871147390555201e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-9.1370485630594302433464867622349615152285e+07) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-5.8668629222734178423824159967020676247808e+07) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.3469781829525499804542317971549293257018e+06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.4872913681183081689767989162689021131772e+10) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.6846567449400018225475591215641965587127e+10) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.7046771905759738548058057585563032597190e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.0435805706941598600100901912097197250580e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(7.1034589517886885904839771275770108089240e+11) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-2.0677247204679210591552190351731243844876e+06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-1.7593150145346615684607661853282622564643e+06) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-1.1727181230908279454789911933116505064800e+05) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.1062296947042766174868987842735274358713e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.1874923199326616278330790923411704750667e+08) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.5922585713166478119817266319179048632460e+09) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.0363737550264836479924842995983076471995e+09) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(9.0127112453627008989311018893645530522602e+09) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.6975473064524988633821198445681935269990e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.3892551698595088957483811206142222102512e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.1779533737004831128641876214157305359931e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.6644686233231688165118787045365078785551e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.7047311070230838548337144623613301753368e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.2358927475921728329938943349670657651768e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.3526974327664097329964743791930260890285e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.6148382805954972904886355970095391528037e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.6201154834537965843716515580832134231135e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(7.4073224496583995436310740133118430460396e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.6504499579998492850097019230027847680435e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.9534675569289431924785905236041605420361e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.5627164364674299639062820214170626032297e+12) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.4697129324856483114000358394562032130419e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.4354199765219482008716533806507412374125e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.5978621908509164507078167967879408695073e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.0554986079040504701309306373864856183853e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.8866560718693690520499951851727091194743e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.8763155663002707931228421505861399497012e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.8035617573895911834425681521889105591632e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.9871948343064591045716803660677427427483e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.4762746498744717769444873898336386347906e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.6475127196233374738037731555738149034987e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.7313990712551505471348367388854373491188e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.9582394089391963045217905059653614082150e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.5800127193591345639951520510919794162589e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.2067240504239188491875394853796411297521e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.1561509205488548110411398250316718717604e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.7643610548507014567783966736200086660994e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.3417744019581277285283951577494050252407e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(6.7387113085937864304278862334432035371112e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.2568215759909887756308756957631791554218e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8551182538826864551863217069830336193169e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4246109414370550878316829347455648491375e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.7748841319185087253647905121213800904773e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.3861904796443377340240331338268952114992e+13) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.6267895352402088874958549482726926317993e+14) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.8080106895144376981731860297117479751716e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.2790957025475424130824058279687669084001e+15) },
      { SC_(-1.2000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0962156690788074903046706342829579946129e+16) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.1526641753209374351263870277430253910126e+07) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.9476187162625251933863818245955980891608e+07) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.9930326148170389582826481965035548117313e+06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.3389362757306333570417879928662411974990e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(7.5801327231061950708680694564424404929497e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.3377606341550985199931762576708231339221e+10) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.1466329205320764408147190330157422076421e+10) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.6650562668894963809957477745625716136023e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.0154327708418419558568894533171274690959e+07) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.8958053612307459136589393321360109833606e+07) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0747182445224991845036781255364058360220e+06) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.2127780914488653831142543480502342848081e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.5870668515253124309880392448727049114161e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.1540066010090612718846578499647710009765e+10) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.7373708023785730334670629415579831479526e+10) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.1989130515493839009891062894144406984038e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-9.2052903859426916235840483067967952982709e+05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-6.8126257694276644358319964361452312274121e+05) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.5054324532585214373139019408106669563767e+03) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.9284389415983962456086144319512217064908e+07) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.6183293332474706723628706503478174700309e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.5015970026166591398566584880919121533397e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.7228188608597178120822589761701637388005e+08) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4630887383371187374537890647872232865080e+09) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.1432167771889728211639763712202167853716e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.4761267599008564745335400679356012157078e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.5903601935091616956957354597823873673335e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.1596373023782967887557125035361490410423e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.4199312869997736414536931591723073744820e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.2717874522552579663532126682661888285669e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.8167388169294199187259729718077350796090e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.2094809745749972029221405449484248428764e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.1312594048058588064956576539756424953552e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.0401942749089091425403125783844812640879e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.5773737480147664392471172693343762179195e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.9893322940024539500443674302438344901452e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-4.1443407927590841710856019764679712211450e+11) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.8729790344294238717361882264287953452655e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-4.8001311128891853944259139775792287160894e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.0560101036497543767501258095594536855835e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.4178550649433844973694563048820018489737e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.9008522725482125090524082274555022561048e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1882070479102894202072388899648489687346e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.0880744033133833265613098570958171423070e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.2552569360539821022624331385067311529046e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.0788837813126654315801624458849631261386e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.5734927284933497899334891383825285098040e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.0940558901933242790694679692844319087554e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.8184760520824860868060721439239240397612e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.2154919299332644353274221291849274234067e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.3822320619878479438691108461414086263638e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.2863595925447207484158797516219876295746e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.6649580562346739330570453526187041665238e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.4533557637767849649926407172531366199818e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-3.0367181350326363261156153571621165659017e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.2900687409912202004824362072995121665402e+14) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(8.1270294417572891927529231955589952745584e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.3822265809552825181455144243727222721712e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.9312165232439806274033457801573662074379e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-4.0750802156259517064220166264177433285797e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-8.4151975671269562395605855730775406972621e+12) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-7.6800740914590493506635706099174112395297e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-9.4991212445101527546171679479090605755718e+13) },
      { SC_(-1.1000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.0163613685104995494006060230095717214094e+14) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.9648696627741181509264528357737525810701e+06) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.8160377284908661989902946326089551851704e+06) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-6.3032921760398175335810837985760988375256e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.3268520414843076270848639959995291011494e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.3957168503147600662851005122105774065236e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.0090509035158861298634596783806785891574e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.2094294232422293459842203674560972130264e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4295280537663593659860742586764241480286e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.1873719228265128109471368170349319566532e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-5.0868692536937012730994974014127996820997e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-5.5716321319691425591552032601764390395221e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.3815458442270050985219613334381170086924e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0657224226187901250091384440989013620968e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.2944025766683765636049741662719722608983e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(6.1949196337091517072248496474566247755251e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.8212609727777272149968189123829632086205e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.5307018622966510200817446475125644410649e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4425368529239968391613251505373520256698e+05) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.0222889197360184958698160807759800670510e+04) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.9091125873112346399192727283386183970543e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.6093138289692161012618874393218571195544e+07) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.9552312216341390407566144397681066552533e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.2538243020725355002173231664768911504605e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.9943359977627244965871508483996595656237e+08) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8059438724631570113902470994353820528270e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4546930429261614673674365883014129053950e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.2083563441287230411386044844603402044629e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.4638759883088837985385768907819657765233e+09) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.6556412127096442837553681008966943176490e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.2754999057289745863077238766353174594424e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.5516391762380096367453111028713557372432e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.8546182076426186610384932053004843494055e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.8465550825753009224467787141624735700138e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.2917607430390722556237882855659628704746e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.8909785204090901705193646077884260727382e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.4015132717296806445330323539764954653299e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.7369121179069018496481912924741957089089e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.0989404831913863299067147461259242704178e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.5523463930119339646501557476295811711267e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(9.6065680314327734773045540554074146121569e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.1977723468572366933483532297683857180711e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(9.6288874833646247012995145795864112894016e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.7881740652247887610764116823870169200801e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.8330608051490994959976396134570026223468e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.3276436131667901434212167131532877358311e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.0043974317624778908983443973925002778000e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.2199264981507421479461999448654949621777e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.5575548631355591691700891165373516599725e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3804508919188286285107570209512513928730e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.1095885539934735483534573062059282563374e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.9579526798137967582128431165795674757227e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.9850193853950753911521998714087307782484e+10) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.5507264160407864548385209216769274526720e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.1716615721851101234434034211366212851898e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.4229253117911354898027571935464939525318e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.3122221641031028232622534503216044348729e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.6769147116351309013280488061702073616818e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.9527053568744153597956749292345184382378e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.3543039378012553713330625067783817547959e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.3321109640242339716137554759666571664622e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.5147118774380520632348939247618356905351e+11) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.3821147137841584217894826863678626182570e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.1043814680129056389668921296080079080958e+12) },
      { SC_(-1.0000000000000000000000000000000000000000e+01), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.5251676262859688044711549835077112304067e+13) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.1814762461055769486724460953682516121846e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-8.8504656910408011445916804261644255754780e+06) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-1.6003863056299608917554357738103011545927e+05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.4731142685419590836441692694471378101022e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.3625727797005743221505157715587612563312e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.0323598440400078961525209340681843114381e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.1926781664104177628273449527570051361070e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.2107313208072152726707383715985088079779e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-7.0205767937450785484885003398178400199654e+06) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-5.1804511523304737485094317562226551668391e+06) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-3.7255494173763159029946161245424592340132e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.1669570603786890013446797448675606037677e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.8661135956392488878797403006864715286131e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.0855820799480017223781153038216456468096e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.3339581461599684759460194100495040945378e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4999501322384352548315528789292015743637e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.2617369662601746888283617170700893457606e+05) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(9.6518600499870768730423220347260085483256e+04) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-6.3708494727653312628482220322752972921091e+01) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.7809641498718617756285017812054930356590e+06) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.1933631712474791207486041574549153972154e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.5685977429937028219264369147879515973765e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.2132252156311031220640402639010819265764e+07) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.2928729102379830943536423171566022750744e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0823456238647819077442376153738955903690e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.9139654793439196666437929545438653252806e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(9.5671773441792723770993376995240283487568e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-6.4875356552843208283393022442700154499174e+08) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.1893122678775242980129130656480956488761e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-7.5144526815407245151982853359041505436192e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-8.9684275386664606343665930831101677188999e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.9725917794294148743362449535104323739806e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.6447882015401763157211193309266913200732e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.3539475071834477451487973810431391801985e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.4436748133281680916956829989772740311536e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.0351229999970351109932084114746640247347e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.8944257717154221451803443664495353621312e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.1915534133019937546578853005149657626939e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.4215514806366745869256759276912225829598e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.7001184305683200064340256407380940804326e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.1533602794475016261368639586392353135813e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.0579334869951149124718742935723341979736e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.2895272297217043443837959111855640632460e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-4.4749247344950284036285431655009089280231e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-8.1488966665348387562116014428422493280997e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-5.0569855325608173854263575575256310381505e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-6.0260949598670244608541958654234387407674e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.9778566803297448154256087351851485247125e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(7.0087872447281007995219714583491537240017e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.7602946980696163293883751580368887299543e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.0131444105401632711197287447159695238539e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-5.1663784493691283864242417337251169096904e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-9.4036378203435223274471979333289796655400e+09) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-5.8283001717918250863092373592277645419125e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-6.9444672093752467535611389886662243281950e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.2777158789799424481937647275363857768182e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.7197300122719460251433312927457188498219e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4121194856334445213246918555429963611384e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.4565101529350110756651641490314871611803e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.3864640974476850739400399712808989264165e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.5157623350294764164271661038002744201032e+10) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.5462856192164143772180605678049935507489e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.8410838131337416524190058022124601410865e+11) },
      { SC_(-9.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-6.0111437261031234267047434162901078323566e+11) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.5283841321357006950136726252933239381219e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.5868939492275890439621217549490484839143e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.9893675594652483101011343373039404816099e+05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.4076531312582423221327185437774974361218e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.6858314446608099417513000156034744116769e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.3912402117636011657676786393127953968642e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.5842749765014497654069087513537212331292e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.8614559196478003935178951321877059984367e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.1710168773217501616246381030285570700265e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.5004043417904228915595007272355959017810e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.2664088502491283710696339314499442708262e+05) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.9685540314039264881600853259293925444066e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.0067719697016141534273197515051365553364e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.1275251248245944533411008813287499878678e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.2832037695047440198066797765341073651590e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.1154838718517442073523159650009040573060e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-3.4268481148097602980392983304655575641796e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-3.0424978193882984551753038339696870798444e+04) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-4.0247581988280148701523460248091604524477e+03) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.8954526888448517448687975883741845870285e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.8025170412855725182403456193915472323327e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.5559618680027298629031368124376545327359e+06) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0780067776753110714664114106979255646877e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4697662594041241246642372182945978405876e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.7779338180587822618705089061294295658751e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.7069648996044680059666551628647898426253e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.9056792947418380155440644333523643364491e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.2365276025954572930559682402269872127833e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(8.9942640573073582801617058296816598925134e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.6574533360381339184569796857040376232967e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.4531767442671063213985470556421075959235e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.5871272776466377441772335920987474566241e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.9147733058125967309427567171408307298432e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.3441796855047011152652733262667201342532e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1485716582393268123638142357439570678639e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.0351785390136675404293887271407418176401e+07) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.3778266036688952156317771507110158211505e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.1028688977352126116572480749859779954076e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.3131771145464054196857349579340976183443e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4136258243711779247636460436040949503902e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.2824130465363215506507583934576500626063e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.7585778613537305941001921745468117036640e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.7268625745793379748632611846977082135656e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.0622033206660170710490126848458812901496e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.2251691170937126457090453676879364897474e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.6583359634964012774412422245770507129012e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.1077673121451874984264297023507385929955e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.9583920250937006617246804899681459200398e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.6933174969263850466024573734742606194926e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.1035025224395666249352448462330504606544e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.1855852061434086735456139804046225246108e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.4908886473338534343803080749073971033872e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.9539344146552042077512382146367488496663e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.0253872550216798036311525318066780978136e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.5364997570623045362924650330944779545216e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0187441554215482448999779120140885438042e+10) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(8.3237806523491974699271601865927548460928e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.9884777258147820149691864534068313023714e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(9.3176465463878119622148672619716750145603e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.5767464980154690897584043510059187722867e+08) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.4584175494532694969771719047722212295169e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(7.3509521653553603714182985653038947714804e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.5868300061836417001807627582820031027855e+09) },
      { SC_(-8.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.4626909301497002600433057978305438795327e+10) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.1789858127491832590279869098270049079656e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.7042880771372691429779778853321939200863e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-9.1667985422510032485778320635652483817070e+04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.6450513889697856076375289639820482786881e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.3154785097481717957822715646525990352314e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.7224570346385737028476431057595457541834e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.9322373513913916841668876468809485299799e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.2475383831359256498600180771842624799399e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-9.0088049608841080380143585708880145749646e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-7.3993465755743887337512919557172050707172e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-6.7457090124240842890368255590541662776350e+04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.0713286885635083746066539122220208801185e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.4710001112232267344666581590633420409358e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.4415956908854883882453826759042832099498e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.6164389455363812323375526926939883142665e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.5429180765286052182506715773763397734040e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.3352571551221324901204756926475161394014e+04) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.7526684927560969574683829676541260389350e+03) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.0165404489925879691969547128399111154371e+02) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.2040462187061858454694875404318442076066e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.9700583312562962510449906247300956760549e+05) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.7917611595686172206320266917456751901990e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.9959158065403597244319184889026333790946e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.1904088102794987434297690236877869944117e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.4431417984940037233915736550373879457604e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.8243789792922969171035084279847778083665e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.8293864528429891858063196203672920775923e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-4.4648093962567380044772869174338149379206e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.1828677228065905359196005087542981121167e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.0458051049582240879101665356033553258044e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-3.4982761484452802957848175647259327642444e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-8.9363921229870759188529904646138592170623e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.2456035575879698994001006341116657388089e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.3733675918685433770691057657001334246672e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(9.5372771855898120547995843623601476497153e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-6.5742771696715718519367498394680912953272e+06) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.0559252060424087182130987744667266747445e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-4.4579217485034162480832150990294412174863e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-5.1182337543527639134659884127843340745767e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.3043432408804468343961371282197876874927e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8205426467020631694957893327371412932355e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.5642028370181352998673350913819535323229e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.7274186034329519164095047537098611605036e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-2.1944071448632525703585216577774905405527e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.5077537689517242471215034449213504390744e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.4620610475803955696124938855340167362360e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.6767698879838082709054301762944076209734e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.2434556704140437301213373845097643712606e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.0226130856972603705940364789396514555060e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.7376066440278063210031742436945005857904e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.0248031577043284225404500881882952778690e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-2.4686393583718922646894292453129983708633e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.9443759140669366322892134752084431452106e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.6421076181961815244455600520685582584490e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.8830650869375133958930495470120569500264e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.7624726517760460142768265435023045976462e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.1739798924286615546600562890673164215703e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.5829162090865887403376531047359236601999e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.1700637804183240052647445008144817881926e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-5.5305383606053672053328848257494182765430e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-8.8111412208316159594699159403617334597100e+07) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.6398702234506757730522813067402032540784e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-4.1711810958252648175329287275644432717902e+08) },
      { SC_(-7.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.0504940337276123916600197191471012382387e+09) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.4111894283780927260927783258105415367077e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.0503325041707742808220367695109959038750e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.9314041154566971500157202863270693047831e+04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.1266687717195024178741824415721946100685e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(7.1089517974891734572052769832940730864363e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.9673959911710389157502892554087710031174e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.1730871648862286318833048403611540415227e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.2945694637349433058896594105216121884342e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.9591293719308308126510429438641368164744e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.6639399329301998668573511797421479751769e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.3356941696920035412820443691374829535085e+04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.4448905530946743615612950371858885345321e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.1554144489178389505784039129297325928915e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.6971444338191941868594361792596556797585e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.8739496475900035937435880700493555795264e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.6953345988745460786199215415103395153518e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.1937846750557115385346393014569365671334e+04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(9.8447288887100430325906573835454587887280e+03) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.9334021818725494286139873465508477248594e+02) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.5013094794663664694515799260102245834421e+04) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.1557044116375224941489633301804833558997e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.0220593220451327551521189935158974407691e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.3208656349161230230117047656858957240619e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.3464512962906233631141082751268056222876e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.0548865935864262344756958616328911001032e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.6877117318145519250792286240151351987176e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.1784222278188708593522553629295731434997e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.0354112157452228092639339574717791886667e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.0784985837579549085222163047356815526713e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.1085954691111832518335743722998317411666e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.3755221780556120720783316372582616866565e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(5.3232755008748025496475917177616456397406e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.1188331011587387276233340514110043030569e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.6222169570108125611845923714049468852066e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.2790701861726533755443515566078603201640e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.6879320461151537685542283746597276787401e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(8.5541105773858348762657092100767452048699e+05) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.9548019052818774545672488013502900387812e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.3276329202945231353819537970790829633520e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(7.4396852384464167869274272794907202503421e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0513736952968043567210315138905240976407e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(9.2345253455832241313085220255572783896627e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.0759140997973266315480319262379691013783e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.6508298651297197341228129645356469509269e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.4713533718459815218693952330950535216962e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.4326230412350773050192617703412113334324e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.4866096907854522510326861676892160755316e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.1068773754047755179278879813304778093136e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.1527593746596777900046929909404369919241e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.0123864369596857207989820367936363685989e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.2723690832240739423471649447823495968177e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.8314246750426069569451243718346756127736e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.7405633910195328383523151919535356384679e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.3407290201304743633699799533639167855068e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0507204341276341774298221875602061330176e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.3321209020312817922223611101290537461468e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.1710224515166871151327085813409680942149e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.9052217709843083091484065888412683323511e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.2338627696266222915898863846529996201201e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.7247638819362498195656661233832737110277e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.5585667469330226588142124423644648379305e+06) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.8807189221413630122090845385138174752677e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.1142501556583817337054083851091256472695e+07) },
      { SC_(-6.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.6740528498332356889506357442111233938561e+07) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-4.1225060484666672026858850168149033506188e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-3.6112683719696492065032128095268783656583e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-7.4427675786719972254248780330692648748278e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.7190981722240401458544227279315861216625e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(8.8462895017980948311049894382780104979232e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.0817475305190735550262852524620905102700e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.2631412517184435493913037251861449948802e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(4.0102378706585944703962126343183747671397e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-3.5155540484559808679049021985404838977493e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-3.0773864595853157308107419841005948294532e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-6.2758416268663681262633363595218602318780e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.9853814886217529251096119042072413085887e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(7.8726210696525066969388104525109520300506e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.8475550589152309902059705147627195860853e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.0080499368503133963821864377153380139575e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.5525968161862835421721536221186421510832e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-4.6138116381902735688160119663193591177803e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-3.9840862290972326393488784478138342315792e+03) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-6.5470380045982378183675022154362033149651e+02) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.5713874189873774873513029064481344190654e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.0392663503659527860616059900948080915147e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(4.6066241616664209700948870683299719774845e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(4.9895877783413007917577298179046346115572e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(8.6326226945766576243748721628075697153127e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.2076299391297451572595205114105596478715e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.9850777497073396840875241346612327334336e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.8646349581420913439626162874120748000247e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-3.8820360246398994763230358187028975691708e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-5.4725434609855553632606645907653078204865e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.5511788280780702608191765684617280647409e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.7139451078831517587534956184787665537398e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.3670297324819814171162365514741587086374e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.8492382724582371529253328234305608082999e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.5609882410940891472271648203914922291569e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.5263856636420989856269484474992902068647e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-5.2230327975906558888888274576170767637060e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.3518668573257379522182783753134961232179e+04) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.0754860367206548633909824733466634289424e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.2924736084209272409724960189478612549695e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-4.4937275157750395093481655662435068164410e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.3317656690905984751215103933458825024709e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.6847072426286737178278019447967781995007e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.6455676307670305596066692945126861579983e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.3073383364792379952150768432719177750391e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.8322928598949946442892598676374503406274e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-5.1135469130593507826881051040695238987212e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-5.6425734611866353567129695199132132049576e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.0991949897425455452898755482774172488428e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.8476426507897217603047709314778152016920e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.1472260272482508518797316518701848306878e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.7769994142552487659820472697503195955585e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.4292036781718187742467550895551611545792e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-2.0023131009871941050939929668138980372860e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-5.5822238099598379514102194855762902631302e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-6.1591861810361204260539757811496879371038e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.1991566618121849203017732888337861220551e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.1727588729421854782296696486132077524914e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.0520879230909531307235052202053052279359e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(3.0140189198690227196811966483843393238690e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-2.6258213667508391428638140945223391981855e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-3.6694960777632782110527969398061710191428e+05) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.0161265015313733411953189973319421349937e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.1204988944501734956915262145138600068634e+06) },
      { SC_(-5.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-2.1735718313710411219782734898295283973622e+06) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.1021239508816959181849533882816092611532e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(5.4975583171807780147266971965500304494952e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.5911459791974625743786202240105590775827e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.2311058841676485458012196951835537701856e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0276233986016743920727853904667113500789e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.0487245734313897053046800348164028723642e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.1913887704200282350804412787713971999860e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.4740851919488024147163189230194142616512e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(5.4180407391781927985448089948394429386821e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.8791243283323808023668694956492543938346e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.4033031076644167425935351341343360470658e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(7.5227224799439434816433053765715244050700e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(9.3853629704120569959858813772248216092700e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.8675052091296505140355565446173597504910e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.9972059991184320903086333591522147531875e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(3.1627323407597226370335186065294309958065e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.2456749287755634362513961818372177149072e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.1136352916897542736977173150892921301037e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.8734119833241060475067199874514721535016e+02) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(2.6638601309277541811326892320715141164882e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(3.2923494014791369826562987647095337665057e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(6.3798891941663761595186087488537148195105e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(6.8067876242532238149986401761315370012025e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0614919054830324951509127155993077172219e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.6806079718654700898551358651400732024885e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.5442568081268690656441987084320938589250e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(5.8524181023634626857595038486337693322684e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(3.9936894308310111527816492743142980546072e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(5.2660930768263117749221467687028137328660e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.2178774091080751726297338839402237393520e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.3196334854219665319813054323277581680716e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.2708591903750360167522829477027375084073e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.0717936882085176942345879703533933535965e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.9030344011847804590850850516743928288704e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.1786248536730604800909985287400224408899e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.1122950869060761174359640885613944990948e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.7317035327036250117529819408039219244698e+03) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.5510530447455287845259423185155516460552e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.6801110331510507516979715410786135223670e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.8853895336785899479135472609435996971515e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.9830063184684199684700454606539324658586e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.6548985719842903936029861265876202619151e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.3605183080035207576014142681840202858774e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.0932831527466033230846394187604793202033e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.4339722853636693925965393380766371348223e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.2696782080524226122122574956123882816838e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.5385624540421970662356764985006647853544e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.0428727172864209170278309880669981555170e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.2462897323330760330198594761939402371224e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.8961395990814732398855757396666843881651e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.4485753992911013813948429135795869682791e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.1767635465252003552153335617765960422316e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.5429264671638217888458170451194837139282e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(3.5148237622951943467921937472722187532766e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(3.8035623900237862340395947585785353672578e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(6.4921384699010581704721742929116394914343e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(6.5881500338678452199691233943866701993622e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(6.0413237769886533914351467914896130214688e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.2286522796779240970540405593538837522172e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.9423413310354831132702041048972784857278e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(2.5409854432826943984102406858178451683125e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.7536715302295151877223563421627712817254e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(6.2231082132034770831869960062636227089181e+04) },
      { SC_(-4.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.0587426850744222771578399301793505622484e+05) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-7.9985171669187543588943336003235648456532e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-7.4033256156957422478512272513112430141125e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-2.9609238405845220063972174366027714127186e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.4531667201283543720778652154390552545033e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.1179105529134601273036647595021490922877e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.8823122000798236983057069324322421770973e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.9804211761347700279130071032108744804731e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.8037983580047352352494069990812269937060e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-7.3540412611021726576001453769402446458886e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-6.8050413171562132256813433658799369407294e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-2.7116292216432010574360526460429909355711e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.8521001288077524765575872762283232183263e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0463475725198645394928926809322065688442e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.7595561336604717431339385125556650039422e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.8510557152757287662482314920308515796187e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.6187293124740896857041055879277554647581e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-2.6576885516470280696413535912096462920372e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-2.4494871653222550550090781744216400624560e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-9.2128217741268807449871531841820088275462e+01) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(4.1572222456205577347626067542899481534175e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(4.8836790032570104301638033016498720459504e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(8.0714194940012740419419838554293854262375e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(8.4780230182700700858013663073539676789719e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.1875197613920580208099397955907907465608e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3510497244512793540004219271168438796891e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.2683939046973288197949586172451221311726e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.1528169821488991303556498319193213697120e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-4.4184667583743647607613310886525519917760e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-5.4459516884606791072714483136859120977104e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.0257480838288922825401460080427231791215e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.0897763799324367504066990737719018377496e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.6410998577342144527266949309103320543260e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.5870908401009048834340408391128757356501e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4895560515882974672324320260616300670455e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.1977077909283683832595061229255320417955e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-5.3607302300894697881671080591451060520441e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-6.5992445667311839987985988711407042232184e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.2389341908730788316376097969780061613384e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.3159035007007687295127538624181741198589e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.9781665001880466298921863999490190255157e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.6216207158724363535634379952289076998214e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.4584667600696996579750159884837291887086e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1750168072187676243243486667767980649794e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-9.6892875635157036686850515334266259148373e+02) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.1887583201785620095196004192211333242578e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.2117805827608072598702623962907132021347e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.3473800188206779389552946711117405630583e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.5117323479781498720667221080969867541783e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.7534648948305934894784834870947378107339e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.5819131564229621533566997631210096524192e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.2328019574130097568511408791444231399999e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.0258364799831436425883884061939248547875e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.2582021548914657431807294202785880816780e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-2.3391295702834444304814070658096275440543e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-2.4823676611019054716770010633574575374873e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-3.7120898290730831905602653471693914787719e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(3.8542916663403687696430165990894642401237e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(3.6124116124006677073050745546486102659075e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.7138736996451208453562096488293301795315e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.5117192280789244163929682027610656121611e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.8506186562416990817415024231373587446462e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-3.4230930696075947875185340051275593881616e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-3.6311290299962341598238275687477593652887e+03) },
      { SC_(-3.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-5.4151032660504968124617563543654186665533e+03) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(9.4335283251458723285565224268335660974018e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.9639623582918896454429947401041368747069e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.9005751531480147252071555354519536221169e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.0207555025197169415535056826772916283735e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.1423601416113190992539400861390750993433e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.6202498118406210493621717112629164255660e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.6763903472827436017207668270817544353690e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.1162503650117871843548920389577709536347e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(8.9454927787713089291825269135195061406297e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(8.4990175436322086288587906631158072498717e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(4.6371657405555644887422803426601592216572e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.7813045653474289223402455148486813694140e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0943567122347682968864972450258883003593e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.5509829560953481595277420123189999592362e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.6046151442294714191385206995127399309808e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.0247664130714800627847554966778090496451e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(4.7439946595376212326024803571401235961075e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(4.4979622983641477847159990813766177277823e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(2.3835018473895355749482503961178027351853e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.9959849361902797562667429375811382744922e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.6841298899811904046707811745834794761069e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.3776702161188094249525533830459789034519e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.6932142020559758173426593425014985427879e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.2160756838525454233158065809740724406984e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.1499363833692120655448276894326234897573e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.1028124581435089432021866714189818454669e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(6.8299758101728298341413146740598799980249e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(5.2930643590039255614337081609095467254903e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.0927846453332547814295861847711322439392e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(9.3244754420338284356973668694190858849272e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(9.7113993308142263585696165630045673111681e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.2782032722420696783490774561470798087806e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.2839225743684876846606884610432721858467e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.2310379919200405583585585763616268543280e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(7.6022040203297708680761704349741281552810e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(6.0585627692137084975194401027021043950336e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(6.9671484191565651840135591166708977202632e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.0635186144773849184603585298970860286067e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.1074067884841554582359276440867157376147e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.4555536986365495985762695546571595045862e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8088650919945662988613879442988661462588e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.7332955500698514822612403009559437503176e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0617925689204915485344566527950785350676e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.1383812432677759996530343469075716947986e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0481222349072412539280689596402860183991e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.5888205748023648515549373007563514282117e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.6534022716997265763289905182720218590475e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.1651064424654609915411024736542431462505e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.8704019756800005157751552405977213400234e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.7921636941932881081660669742245187152641e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0970643408584651237871543730251211457016e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.5060415292974999031493263618262240521872e+01) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0900423705392731210480075171526462285421e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.6513670009153554407228666015558862789625e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.7184021924317003872373366135661854059435e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.2494927434727319680319581555322239196926e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(2.3518337795069682563854235974891475563844e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(2.2526657066736842971799177322488311853935e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.3725796075920025031256121725092237545462e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.2418083844148507452400464742223229529326e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.4219114275085820837398261834355705330538e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(2.1459042101296288132316827605981585851223e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(2.2322832134660279170646846394476803254747e+02) },
      { SC_(-2.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(2.9161902132118950753167996512764067497392e+02) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-1.0131109827396358014084398746490478515625e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.8777531431833267561160027980804443359375e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-7.3246387662002234719693660736083984375000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.0391685155979757837485522031784057617188e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0997007744809707219246774911880493164062e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.3109258510902691341470927000045776367188e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.3335572363459505140781402587890625000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4920528411865234375000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.4991510029332857811823487281799316406250e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-9.8777538222620933083817362785339355468750e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-9.6301638080740303848870098590850830078125e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-7.1351610542114940471947193145751953125000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(1.0177920323048056161496788263320922851562e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(1.0769465120148197456728667020797729492188e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.2833638792021702101919800043106079101562e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.3054801498423330485820770263671875000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.4580921173095703125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.4673048245935206068679690361022949218750e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-7.3246398303708701860159635543823242187500e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-7.1351615862968174042180180549621582031250e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-5.2257601012970553711056709289550781250000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(8.0237736879880685592070221900939941406250e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(8.4764772019534575520083308219909667968750e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(1.0056169355908423312939703464508056640625e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(1.0225423036841675639152526855468750000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(-1.1158638000488281250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.1463851626955147366970777511596679687500e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0391688490954038570635020732879638671875e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.0177923009153346356470137834548950195312e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.0237752842440386302769184112548828125000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-6.9240779003894203924573957920074462890625e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.4348087510397817823104560375213623046875e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-9.2169851483204183750785887241363525390625e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-9.4079336914001032710075378417968750000000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.2588947296142578125000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.0805103511793276993557810783386230468750e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.0997009734232051414437592029571533203125e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.0769466454398752830456942319869995117188e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(8.4764777340387809090316295623779296875000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-7.4348074343934058560989797115325927734375e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-7.9784563523107863147743046283721923828125e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-9.8754991267696823342703282833099365234375e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.0078754850779660046100616455078125000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.3400341033935546875000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.1565976270900137024000287055969238281250e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3109259347409533802419900894165039062500e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.2833638870735740056261420249938964843750e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0056168823823099955916404724121093750000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-9.2169822260730143170803785324096679687500e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-9.8754977138050890062004327774047851562500e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.2173363131540099857375025749206542968750e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.2419564379844814538955688476562500000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6231674194335937500000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.4221018050695420242846012115478515625000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.3335573940363246947526931762695312500000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.3054802286875201389193534851074218750000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.0225423036841675639152526855468750000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-9.4079313260444905608892440795898437500000e+00) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.0078754062327789142727851867675781250000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.2419565168296685442328453063964843750000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.2670367766171693801879882812500000000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.6535034179687500000000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.4505489495699293911457061767578125000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.4602651596069335937500000000000000000000e-01), SC_(1.4991508972056180937215685844421386718750e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-7.2904610633850097656250000000000000000000e-01), SC_(1.4673046359139334526844322681427001953125e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(-5.5793190002441406250000000000000000000000e-01), SC_(1.1463849498613853938877582550048828125000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.2944722175598144531250000000000000000000e-01), SC_(-1.0805098427759730839170515537261962890625e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(6.7001700401306152343750000000000000000000e-01), SC_(-1.1565972820693787070922553539276123046875e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.1158375740051269531250000000000000000000e-01), SC_(-1.4221015849043396883644163608551025390625e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(8.2675170898437500000000000000000000000000e-01), SC_(-1.4505486341891810297966003417968750000000e+01) },
      { SC_(-1.0000000000000000000000000000000000000000e+00), SC_(1.8754707336425781250000000000000000000000e+01), SC_(9.3773555755615234375000000000000000000000e-01), SC_(-1.6586955940925690811127424240112304687500e+01) }
   }};
//#undef SC_
