/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.Formula;
import SharpTools.Node;
import SharpTools.ParserException;
import SharpTools.SharpTableModel;
import java.util.LinkedList;

public abstract class Function {
    private static ParserException exception = new ParserException("#PARAM?");

    protected boolean isRange(Node param) {
        LinkedList exp = param.getExp();
        return exp.size() == 1 && ((Node)exp.getFirst()).isType(9);
    }

    protected Node getFirst(Node param) {
        return (Node)param.getExp().getFirst();
    }

    protected void checkParamsExist(Node func) throws ParserException {
        if (func.getParams().size() == 0) {
            throw exception;
        }
    }

    protected static float getSingleParameter(SharpTableModel table, Node node, int row, int col) throws ParserException {
        LinkedList params = node.getParams();
        if (params.size() != 1) {
            throw new ParserException("#PARAM?");
        }
        LinkedList exp = ((Node)params.getFirst()).getExp();
        return Formula.evaluate(table, exp, row, col).floatValue();
    }

    public abstract Number evaluate(SharpTableModel var1, Node var2, int var3, int var4) throws ParserException;

    public abstract String getUsage();

    public abstract String getDescription();

    public boolean requireParams() {
        return true;
    }
}

