package examples.app3;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Manifest constants for this application.
 *
 * @author Craig R. McClanahan
 * @author Ted Husted
 * @version $Revision: 477914 $ $Date: 2006-11-21 13:52:11 -0800 (Tue, 21 Nov 2006) $
 */

public final class Constants
{


    /**
     * The package name for this application.
     */
    public static final String Package = "app";


    /**
     * The session scope attribute under which the Username
     * for the currently logged in user is stored.
     */
    public static final String USER_KEY = "user";


    /**
     * The token that represents a nominal outcome
     * in an ActionForward.
     */
    public static final String CONTINUE = "continue";


    /**
     * The value to indicate debug logging.
     */
    public static final int DEBUG = 1;


    /**
     * The value to indicate normal logging.
     */
    public static final int NORMAL = 0;

}
