/***************************************************************************
                          dcspy.h  -  description
                             -------------------
    begin                : Fre Nov 8 2002
    copyright            : (C) 2002 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCSPY_H
#define DCSPY_H

#include <qwidget.h>
#include <qtimer.h>

#include "DCDialogSpy.h"

class QMdiSubWindow;
class SearchSpyModel;
class CMessageSearchFile;
class QCloseEvent;

/**
  *@author Mathias Küster
  */

class DCSpy : public QWidget, private Ui::DCDialogSpy  {
Q_OBJECT

public: 
	/** construtor */
	DCSpy( QWidget * parent );
	/** destructor */
	virtual ~DCSpy();
	
	/** Get the MDI sub window we are in */
	QMdiSubWindow * GetMdiSubWindow() { return m_pContainerWindow; } ;
	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** search */
	void DC_Search( CMessageSearchFile * MessageSearch );

protected:
	/** for removing mdi sub window from mdi area */
	virtual void closeEvent( QCloseEvent * e );

private:
	/** */
	QTimer m_Timer;
	/** */
	QMdiSubWindow * m_pContainerWindow;
	/** */
	SearchSpyModel * model;
	
private slots:
	/** */
	void timerDone();
	/** */
	void slotContextMenuSpy( const QPoint & );
	/** */
	void slotAltRowColors( bool enable );
};

/** */
extern DCSpy * g_pSpy;

#endif
