/* i086-dos16.com.h
   created from i086-dos16.com.bin, 6052 (0x17a4) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2013 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2013 Laszlo Molnar
   Copyright (C) 2000-2013 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I086_DOS16_COM_SIZE    6052
#define STUB_I086_DOS16_COM_ADLER32 0x06a83990
#define STUB_I086_DOS16_COM_CRC32   0xae960baf

unsigned char stub_i086_dos16_com[6052] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  72,  2,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  46,  0, 43,  0,129,252,  0,  0,119,  2,205, 32,185,  0,  0,190,
/* 0x0040 */   0,  0,191,  0,  0,187,  0,128,253,243,164,252,135,247,131,238,
/* 0x0050 */   0, 25,237, 87, 87,233,255,255, 85, 80, 88, 33,161,216,208,213,
/* 0x0060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,164,232,
/* 0x0070 */  11,  0,114,250, 65,232,  6,  0,227, 21,227, 20,115,  6,131,233,
/* 0x0080 */   3,114,  6,136,204,172,247,208,149, 49,201,232,  6,  0, 17,201,
/* 0x0090 */ 117,  8, 65,232,  6,  0,115,251, 65, 65, 65,129,253,  0,243,131,
/* 0x00a0 */ 209,  1,141,  3,150,243,164,150,235,  0,232,  2,  0, 17,201,  1,
/* 0x00b0 */ 219,117,  4,173, 17,192,147,195, 94,185,  0,  0,172, 44,232, 60,
/* 0x00c0 */   1,119,249,193,  4,  8, 41, 52,139, 28,134,223, 41,243,137, 28,
/* 0x00d0 */ 173,226,  3,176,232,176,233, 95,185,  0,  0,242,174,117, 20,117,
/* 0x00e0 */   2,193,  5,  8, 41, 61,139, 29,134,223, 41,251,137, 29,175,235,
/* 0x00f0 */   3,195,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x0100 */ 102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,
/* 0x0110 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x0120 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x0130 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x0140 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x0150 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 67, 79,
/* 0x0160 */  77, 77, 65, 73, 78, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x0170 */  48, 48, 49,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x0180 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0190 */  51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x01a0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x01b0 */  78, 76, 89, 10, 32, 32, 49, 32, 67, 79, 77, 83, 66, 66, 66, 80,
/* 0x01c0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x01d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x01e0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 49, 32, 32, 50, 42,
/* 0x01f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x0200 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 67, 79, 77, 80, 83,
/* 0x0210 */  72, 68, 73, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0220 */  49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0230 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 51, 32,
/* 0x0240 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x0250 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 67, 79,
/* 0x0260 */  77, 67, 65, 76, 76, 84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x0270 */  48, 48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x0280 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0290 */  53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x02a0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52,
/* 0x02b0 */  32, 67, 79, 77, 77, 65, 73, 78, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x02c0 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x02d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x02e0 */  48, 48, 48, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x02f0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x0300 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 85, 80, 88, 49, 72,
/* 0x0310 */  69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,
/* 0x0320 */  54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0330 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 53, 56, 32,
/* 0x0340 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x0350 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 67, 79,
/* 0x0360 */  77, 67, 85, 84, 80, 79, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x0370 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x0380 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0390 */  54,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x03a0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55,
/* 0x03b0 */  32, 78, 82, 86, 50, 66, 49, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x03c0 */  48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x03d0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x03e0 */  48, 48, 48, 54,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x03f0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x0400 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 82, 86, 68, 68,
/* 0x0410 */  79, 78, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0420 */  50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0430 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 56, 32,
/* 0x0440 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x0450 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x0460 */  10, 32, 32, 57, 32, 78, 82, 86, 68, 82, 69, 84, 85, 32, 32, 32,
/* 0x0470 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48,
/* 0x0480 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0490 */  32, 48, 48, 48, 48, 48, 48, 55, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x04a0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x04b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78,
/* 0x04c0 */  82, 86, 68, 69, 67, 79, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x04d0 */  48, 48, 48, 49,101, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x04e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x04f0 */  48, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x0500 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x0510 */  79, 78, 76, 89, 10, 32, 49, 49, 32, 78, 82, 86, 76, 69, 68, 48,
/* 0x0520 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x0530 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0540 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 97, 32, 32, 50,
/* 0x0550 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0560 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 82, 86, 71,
/* 0x0570 */  84, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0580 */  48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0590 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 57, 98,
/* 0x05a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x05b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 78,
/* 0x05c0 */  82, 86, 68, 69, 67, 79, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x05d0 */  48, 48, 48, 49, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x05e0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x05f0 */  48, 97, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x0600 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x0610 */  79, 78, 76, 89, 10, 32, 49, 52, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x0620 */  54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32,
/* 0x0630 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0640 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 56, 32, 32, 50,
/* 0x0650 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0660 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x0670 */  49, 53, 32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 32, 32, 32, 32,
/* 0x0680 */  32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,
/* 0x0690 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x06a0 */  48, 48, 48, 48, 48, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x06b0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x06c0 */  89, 10, 32, 49, 54, 32, 67, 84, 49, 54, 83, 85, 66, 48, 32, 32,
/* 0x06d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x06e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x06f0 */  32, 32, 48, 48, 48, 48, 48, 48, 99, 54, 32, 32, 50, 42, 42, 48,
/* 0x0700 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x0710 */  79, 78, 76, 89, 10, 32, 49, 55, 32, 67, 84, 49, 54, 73, 48, 56,
/* 0x0720 */  54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x0730 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0740 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 56, 32, 32, 50,
/* 0x0750 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0760 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56, 32, 67, 65, 76, 76,
/* 0x0770 */  84, 82, 73, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0780 */  48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0790 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 48,
/* 0x07a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x07b0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x07c0 */  89, 10, 32, 49, 57, 32, 67, 84, 49, 54, 69, 56, 48, 48, 32, 32,
/* 0x07d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x07e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x07f0 */  32, 32, 48, 48, 48, 48, 48, 48,100, 51, 32, 32, 50, 42, 42, 48,
/* 0x0800 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x0810 */  79, 78, 76, 89, 10, 32, 50, 48, 32, 67, 84, 49, 54, 69, 57, 48,
/* 0x0820 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x0830 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0840 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 53, 32, 32, 50,
/* 0x0850 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0860 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 49, 32, 67, 65, 76, 76,
/* 0x0870 */  84, 82, 73, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0880 */  48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0890 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 55,
/* 0x08a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x08b0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x08c0 */  89, 10, 32, 50, 50, 32, 67, 84, 49, 54, 74, 69, 78, 68, 32, 32,
/* 0x08d0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48,
/* 0x08e0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x08f0 */  32, 32, 48, 48, 48, 48, 48, 48,100,100, 32, 32, 50, 42, 42, 48,
/* 0x0900 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x0910 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32,
/* 0x0920 */  67, 84, 49, 54, 74, 85, 76, 50, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x0930 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0940 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x0950 */  48, 48,100,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x0960 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x0970 */  68, 79, 78, 76, 89, 10, 32, 50, 52, 32, 67, 84, 49, 54, 73, 50,
/* 0x0980 */  56, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x0990 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x09a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 49, 32, 32,
/* 0x09b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x09c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 53, 32, 67, 84, 49,
/* 0x09d0 */  54, 83, 85, 66, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x09e0 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x09f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101,
/* 0x0a00 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0a10 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32,
/* 0x0a20 */  67, 84, 49, 54, 73, 48, 56, 55, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x0a30 */  48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0a40 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x0a50 */  48, 48,101, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x0a60 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x0a70 */  50, 55, 32, 67, 65, 76, 76, 84, 82, 73, 54, 32, 32, 32, 32, 32,
/* 0x0a80 */  32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48,
/* 0x0a90 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0aa0 */  48, 48, 48, 48, 48,101,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0ab0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x0ac0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 67, 79, 82,
/* 0x0ad0 */  69, 84, 85, 82, 78, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x0ae0 */  48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0af0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,102,
/* 0x0b00 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x0b10 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66,
/* 0x0b20 */  79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48,
/* 0x0b30 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,
/* 0x0b40 */  49, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x0b50 */  50, 66, 49, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0b60 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,  9,
/* 0x0b70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 69, 67, 79,
/* 0x0b80 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0b90 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 54,  9, 48, 48, 48, 48,
/* 0x0ba0 */  48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 48, 48,
/* 0x0bb0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0bc0 */  65, 76, 76, 84, 82, 73, 53,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0bd0 */  32, 67, 65, 76, 76, 84, 82, 73, 53, 10, 48, 48, 48, 48, 48, 48,
/* 0x0be0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x0bf0 */  82, 73, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,
/* 0x0c00 */  76, 84, 82, 73, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0c10 */  32, 32, 32, 32,100, 32, 32, 67, 79, 77, 77, 65, 73, 78, 49,  9,
/* 0x0c20 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77, 77, 65, 73, 78,
/* 0x0c30 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0c40 */ 100, 32, 32, 67, 79, 77, 83, 66, 66, 66, 80,  9, 48, 48, 48, 48,
/* 0x0c50 */  48, 48, 48, 48, 32, 67, 79, 77, 83, 66, 66, 66, 80, 10, 48, 48,
/* 0x0c60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0c70 */  79, 77, 80, 83, 72, 68, 73,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0c80 */  32, 67, 79, 77, 80, 83, 72, 68, 73, 10, 48, 48, 48, 48, 48, 48,
/* 0x0c90 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 79, 77, 67, 65,
/* 0x0ca0 */  76, 76, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77,
/* 0x0cb0 */  67, 65, 76, 76, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0cc0 */  32, 32, 32, 32,100, 32, 32, 67, 79, 77, 77, 65, 73, 78, 50,  9,
/* 0x0cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 77, 77, 65, 73, 78,
/* 0x0ce0 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0cf0 */ 100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48,
/* 0x0d00 */  48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48,
/* 0x0d10 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0d20 */  79, 77, 67, 85, 84, 80, 79,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d30 */  32, 67, 79, 77, 67, 85, 84, 80, 79, 10, 48, 48, 48, 48, 48, 48,
/* 0x0d40 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 68,
/* 0x0d50 */  79, 78, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x0d60 */  68, 68, 79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0d70 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 82, 69, 84, 85,  9,
/* 0x0d80 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 82, 69, 84,
/* 0x0d90 */  85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0da0 */ 100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 49,  9, 48, 48, 48, 48,
/* 0x0db0 */  48, 48, 48, 48, 32, 78, 82, 86, 68, 69, 67, 79, 49, 10, 48, 48,
/* 0x0dc0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x0dd0 */  82, 86, 76, 69, 68, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0de0 */  32, 78, 82, 86, 76, 69, 68, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x0df0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 71, 84,
/* 0x0e00 */  68, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x0e10 */  71, 84, 68, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0e20 */  32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 50, 56, 54,  9,
/* 0x0e30 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 73, 50, 56,
/* 0x0e40 */  54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0e50 */ 100, 32, 32, 67, 84, 49, 54, 83, 85, 66, 48,  9, 48, 48, 48, 48,
/* 0x0e60 */  48, 48, 48, 48, 32, 67, 84, 49, 54, 83, 85, 66, 48, 10, 48, 48,
/* 0x0e70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0e80 */  84, 49, 54, 73, 48, 56, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0e90 */  32, 67, 84, 49, 54, 73, 48, 56, 54, 10, 48, 48, 48, 48, 48, 48,
/* 0x0ea0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x0eb0 */  82, 73, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65, 76,
/* 0x0ec0 */  76, 84, 82, 73, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0ed0 */  32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69, 56, 48, 48,  9,
/* 0x0ee0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 69, 56, 48,
/* 0x0ef0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0f00 */ 100, 32, 32, 67, 84, 49, 54, 69, 57, 48, 48,  9, 48, 48, 48, 48,
/* 0x0f10 */  48, 48, 48, 48, 32, 67, 84, 49, 54, 69, 57, 48, 48, 10, 48, 48,
/* 0x0f20 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0f30 */  84, 49, 54, 74, 69, 78, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f40 */  32, 67, 84, 49, 54, 74, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x0f50 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 74,
/* 0x0f60 */  85, 76, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49,
/* 0x0f70 */  54, 74, 85, 76, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0f80 */  32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 50, 56, 55,  9,
/* 0x0f90 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 73, 50, 56,
/* 0x0fa0 */  55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0fb0 */ 100, 32, 32, 67, 84, 49, 54, 83, 85, 66, 49,  9, 48, 48, 48, 48,
/* 0x0fc0 */  48, 48, 48, 48, 32, 67, 84, 49, 54, 83, 85, 66, 49, 10, 48, 48,
/* 0x0fd0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x0fe0 */  84, 49, 54, 73, 48, 56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ff0 */  32, 67, 84, 49, 54, 73, 48, 56, 55, 10, 48, 48, 48, 48, 48, 48,
/* 0x1000 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 79, 82, 69, 84,
/* 0x1010 */  85, 82, 78,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 79, 82,
/* 0x1020 */  69, 84, 85, 82, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1030 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x1040 */  48, 48, 48, 48, 48, 32,115,112, 95,108,105,109,105,116, 10, 48,
/* 0x1050 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1060 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 98,
/* 0x1070 */ 121,116,101,115, 95,116,111, 95, 99,111,112,121, 10, 48, 48, 48,
/* 0x1080 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x1090 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,112,
/* 0x10a0 */ 121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x10b0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x10c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,111,112,121, 95,100,101,
/* 0x10d0 */ 115,116,105,110, 97,116,105,111,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x10e0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x10f0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32,110,101,103, 95,101, 95,
/* 0x1100 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x1110 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x1120 */  48, 48, 48, 32, 99, 97,108,108,116,114,105, 99,107, 95, 99, 97,
/* 0x1130 */ 108,108,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1140 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 79, 77,
/* 0x1150 */  77, 65, 73, 78, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1160 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1170 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1180 */  50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x1190 */  32, 32, 32, 32,115,112, 95,108,105,109,105,116, 10, 48, 48, 48,
/* 0x11a0 */  48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x11b0 */  32, 32, 32, 32, 32, 32, 32, 32, 98,121,116,101,115, 95,116,111,
/* 0x11c0 */  95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82,
/* 0x11d0 */  95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x11e0 */  32, 99,111,112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48,
/* 0x11f0 */  48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x1200 */  32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121, 95,100,101,115,
/* 0x1210 */ 116,105,110, 97,116,105,111,110, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x1220 */  99, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x1230 */  32, 32, 32, 32,110,101,103, 95,101, 95,108,101,110, 10, 10, 82,
/* 0x1240 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x1250 */  83, 32, 70, 79, 82, 32, 91, 67, 79, 77, 77, 65, 73, 78, 50, 93,
/* 0x1260 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1270 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1280 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x1290 */  54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x12a0 */  86, 50, 66, 49, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x12b0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x12c0 */  78, 82, 86, 50, 66, 49, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x12d0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x12e0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x12f0 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32,
/* 0x1300 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10,
/* 0x1310 */  48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x1320 */  67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69,
/* 0x1330 */  67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1340 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x1350 */  68, 68, 79, 78, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1360 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1370 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1380 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x1390 */  32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69,
/* 0x13a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x13b0 */  32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 82, 69, 84, 85, 93, 58,
/* 0x13c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x13d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x13e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x13f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1400 */  68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x1410 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x1420 */  82, 86, 68, 69, 67, 79, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x1430 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1440 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x1450 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x1460 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10, 48,
/* 0x1470 */  48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x1480 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67,
/* 0x1490 */  79, 50, 10, 48, 48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 51, 56,
/* 0x14a0 */  54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x14b0 */  86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x14c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x14d0 */  78, 82, 86, 68, 69, 67, 79, 50, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x14e0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x14f0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x1500 */  48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x1510 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 49, 54, 48, 10,
/* 0x1520 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x1530 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49,
/* 0x1540 */  54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x1550 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1560 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x1570 */  51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1580 */  99, 97,108,108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10,
/* 0x1590 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x15a0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73,
/* 0x15b0 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x15c0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x15d0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x15e0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x15f0 */  67, 65, 76, 76, 84, 82, 49, 54, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x1600 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x1610 */  32, 91, 67, 65, 76, 76, 84, 82, 73, 53, 93, 58, 10, 79, 70, 70,
/* 0x1620 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1630 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1640 */  48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,
/* 0x1650 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,108,108,116,114,105,
/* 0x1660 */  99,107, 95, 99, 97,108,108,115, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x1670 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x1680 */  32, 91, 67, 84, 49, 54, 74, 69, 78, 68, 93, 58, 10, 79, 70, 70,
/* 0x1690 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x16a0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x16b0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x16c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79,
/* 0x16d0 */  50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x16e0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 49, 54, 74,
/* 0x16f0 */  85, 76, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x1700 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1710 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x1720 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x1730 */  32, 32, 67, 65, 76, 76, 84, 82, 73, 54, 10, 10, 82, 69, 76, 79,
/* 0x1740 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x1750 */  79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 54, 93, 58, 10, 79,
/* 0x1760 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x1770 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x1780 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x1790 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84,
/* 0x17a0 */  82, 73, 53, 10
};
