/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "LinuxEventLog.h"
#include "EventMessages.h"

#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include <string>


//ctor
LinuxEventLog::LinuxEventLog(const char * eventLogSourceName)
{
	msgId = 1;
	openlog(eventLogSourceName, LOG_CONS, LOG_DAEMON);
}


//dtor
LinuxEventLog::~LinuxEventLog()
{
	closelog();
}

// Record Events for
void LinuxEventLog::LogEvent(	unsigned short CategoryID,
				unsigned long EventID,
				unsigned long	EventType)
{
	//get string from EventMessages
	//EventMessages msg;
	char msg[1024];
	snprintf(msg, 1024, "Category=%s:EventId=%d:Message=(%u)%s",
		EventMessages::instance().getCategory(CategoryID).c_str(),
		EventMessages::instance().getEventid(EventID),
		msgId++,
		EventMessages::instance().getMessage(EventID).c_str());
	std::string str = std::string(msg);

	syslog(EventMessages::instance().getPriority(EventID), "%s", str.c_str());

}

void LinuxEventLog::LogEvent(	unsigned short CategoryID,
		unsigned long	EventID,
		unsigned long	EventType,
		const char * ArrayOfStrings[],
		unsigned int NumOfArrayStr,
		void * RawData,
		unsigned long RawDataSize){

  // sanity check: replace algorithm only works for array length below 10
	if (NumOfArrayStr > 9){
		return;
	}

	//get string from EventMessages
	//EventMessages msg;
	char msg[1024];
	snprintf(msg, 1024, "Category=%s:EventId=%d:Message=(%u)%s",
		EventMessages::instance().getCategory(CategoryID).c_str(),
		EventMessages::instance().getEventid(EventID),
		msgId++, 
		EventMessages::instance().getMessage(EventID).c_str());
	std::string str = std::string(msg);

	//replace '%i' with ArrayOfStrings[i]
	for(unsigned int i=0; i<NumOfArrayStr; i++){
		char tmp[4];
		int index = snprintf(tmp, 3, "_%d", i+1);
		tmp[0]='%';
		tmp[index]= 0;
		index = str.find(tmp,0);
		str.replace(index,2,ArrayOfStrings[i]);
	}

	syslog(EventMessages::instance().getPriority(EventID), "%s", str.c_str());

}
