# tkz-euclide — for euclidean geometry

Release 4.03 b 2022/01/19

## Description

`tkz-euclide` is a package (latex) which allows you to draw  two-dimensional
geometric figures, in other words to create figures of Euclidean geometry.
It uses a Cartesian coordinate system orthogonormal (unit 1cm) 
 as well as tools to define the unique coordinates of points and to
manipulate them. The idea is to allow you to follow step by step a construction
that would be done by hand as naturally as possible.

## Licence

This package may be modified and distributed under the terms and
conditions of the [LaTeX Project Public License](https://www.latex-project.org/lppl/), version 1.3 or greater.


## Requirements

The package compiles with utf8, pdflatex and lualatex, loads and depends on updated versions of:
- [xfp](https://ctan.org/pkg/xfp)
- [tikz](https://ctan.org/pkg/tikz)

## Installation

The package `tkz-euclide` is present in TeXLive and MiKTeX, use the package
manager to install.

You can experiment with the `tkz-euclide` package by placing all of the
distribution files in the directory containing your current tex file.

The different files must be moved into the different directories in your
installation `TDS` tree or in your `TEXMFHOME`:


## How to use it

To use the package `tkz-euclide`, place the following lines in the preamble of
your LaTeX document:

```
\usepackage{tkz-euclide}
\begin{document}
\begin{tikzpicture}
```
your code
```
\end{tikzpicture}
```

The line `\usetkzobj{all}` is no longer required with `tkz-euclide` but you can use it with
other packages.

If you use the `xcolor` package, load that package before `tkz-euclide` to avoid
package conflicts.

## Documentation

Documentation for `tkz-euclide` is available on `CTAN`. 

## Examples

All  examples given in documentation will be stored on my site : [http://altermundus.fr](http://altermundus.fr) as standalone
files, ready for compilation. 

Other examples, in French, are on my site.

## Compatibility

The new version of `tkz-euclide` is *not* fully compatible with the version
3.06 but the differences are minor.

## History

- 4.03 Adaptation of the code and documentation to the changes of the macros for the intersections.
- 4.02
  Major changes for the macros concerning the intersection of a line and a circle or two circles. If one point of the intersection is known then you can use the "common" option and indicate what the common point is. The second point is given in tkzFirstPointResult.
  In other cases, for the intersection of two circles the determined points form angles with the centers of the circles. One of the angles measures less than 180 degrees and the other more than 180. The smaller one determines tkzFirstPointResult.
 For the intersection of a line and a circle, the method is the same except that the angle is formed by a point on the line and the center of the circle.

- 4.01 
 \tkzDefOrthogonalCircle was defined twice so I deleted the version in   tkz-obj-eu-circles-by

 In the tkz-obj-eu-draw-lines.tex   new code for add dim from muzimuzhi Z.
 The code comes from an answer on the site tex.stackexchange.com

 In the file tkz-obj-eu-draw-triangles.tex added options 
  pythagoras and egyptian equivalent to pythagore
  euclid  equivalent to euclide
  two one equivalent to  half
	
 Added option "swap" useful with golden, gold,  school, half, pythagoras

  In the file tkz-obj-eu-circles  correction of bug in \tkzDefOrthoThroughCircle : \tkz@@CalcLength  has been replaced by 	 \tkz@@CalcLengthcm 
 	
  Addition of the macro \tkzDefGoldenRatio in tkz-obj-eu-points-spc. It allows to split a segment with a ratio equal to the golden ratio

 Minor corrections of the documentation. New  examples about option "dim"
      

- 4.00 correction of bugs, tkz-euclide no longer depends on tkz-base. The unit is "cm". 
       The bounding box is controlled. The documentation has been restructured according to the rule:
        set, calculate, draw, mark and fill, label.
- 3.06 correction of bugs, amelioration of the documentation. 
- 3.05 correction of bugs, amelioration of the documentation.
- 3.02 replacement french documentation by english documentation, correction of bugs.
- 3.01 replacement `fp` for `xfp`, addition of some macros, correction of bugs
- 1.16 correction of bugs
- 1.13 first version

## Author

Alain Matthes, 5 rue de Valence, Paris 75005, al (dot) ma (at) mac (dot) com
