/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "UnlockDialog.h"
#include "ScModel.h"
#include "Settings.h"
#include "settings/FontSettings.h"
#include "sublib/Gui.h"
#include "sublib/settings/LayoutSettings.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QCheckBox>
#include <Qt3Support/Q3GroupBox>
#include <Qt3Support/Q3VBox>



UnlockDialog::UnlockDialog( ScModel* model, QWidget *parent )
: super( parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_Dialog
  | Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _model(model)
{
  setName( "UnlockDialog" );
  setCaption( _q("subcommander:unlock") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    Q3GroupBox* gb = new Q3GroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("unlock options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _break = new QCheckBox(_q("&break locks"),this);
      _break->setChecked(model->getOptionCommandForce());
      h1->addWidget(_break);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(true);
      _ok->setText( _q("&Unlock") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);
      
      hu->addSpacing(getSizeGripSpacing());

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  Settings s;
  resize( s.layout().getSize( name(), QSize(350,300) ) );
}

UnlockDialog::~UnlockDialog()
{
  Settings s;
  s.layout().setSize( name(), geometry().size() );
}

bool UnlockDialog::isBreakLock() const
{
  return _break->isChecked();
}
