/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPVIEWSTATE_H
#define _SC_RPVIEWSTATE_H

// sc
#include "util/String.h"
class Bookmark;

// sys
#include <map>
#include <vector>

// qt
#include <QtCore/QObject>


typedef std::map< sc::String, bool >  RpViewExpandedItems;
typedef std::map< sc::String, bool >  RpViewSelectedItems;
typedef std::vector< sc::String >     PathHistory;


class RpViewState : public QObject
{
  typedef QObject super;
  Q_OBJECT

public:
  RpViewState( Bookmark* );

  void clearExpanded();
  void setExpanded( const sc::String& name, bool );
  bool isExpanded( const sc::String& name );

  void clearSelected();
  void setSelected( const sc::String& name, bool );
  bool isSelected( const sc::String& name );

  void getPrevPathHistory( PathHistory& );
  void getNextPathHistory( PathHistory& );

  const sc::String& getPath();
  void setPath( const sc::String& path );
  void addPath( const sc::String& path );

public slots:
  void prevPath();
  void nextPath();
  void prevPath( int cnt );
  void nextPath( int cnt );

signals:
  void historyChanged();
  void currentChanged( const sc::String& );
  void optionsChanged();

private:
  RpViewExpandedItems  _itemExpanded;
  RpViewSelectedItems  _itemSelected;

  PathHistory          _pathHistory;
  unsigned int         _pathPos;
};

#endif // _SC_RPVIEWSTATE_H
