/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REPOSITORY_H
#define _SC_REPOSITORY_H

// sc
#include "util/String.h"
namespace svn
{
  class Revision;
}



class Repository
{
public:
  Repository( const sc::String& url )
    : _url(url), _sort(-1), _flat(false), _cache(false), _hide(false)
  {
  }

  void setSortKey( long key )
  {
    _sort = key;
  }

  void setFlat( bool flat )
  {
    _flat = flat;
  }

  void setCache( bool cache )
  {
    _cache = cache;
  }

  void setHide( bool hide )
  {
    _hide = hide;
  }

  const sc::String& getUrl() const
  {
    return _url;
  }

  bool isFlat()
  {
    return _flat;
  }

  bool isCached()
  {
    return _cache;
  }

private:
  sc::String     _url;
  svn::Revision* _rev;

  long           _sort;
  bool           _flat;
  bool           _cache;
  bool           _hide;
};



#endif // _SC_REPOSITORY_H

