#! /usr/bin/ruby -w

## ====================================================================
## Copyright (c) 2003, 2008 Martin Hauner
##                          http://subcommander.tigris.org
##
## Subcommander is licensed as described in the file doc/COPYING, which
## you should have received as part of this distribution.
## ====================================================================
##
## generated setup/build files that contain version numbers.
##

require 'getoptlong'

VersionTemplate = './sublib/version.in.h'
VersionOut      = './sublib/version.out.h'
VersionOutXml   = './doc/docbook/guide/version.out.xml'

InfoPlistTemplate = './dist/macosx/Info.plist.in'
InfoPlistOutSC    = './dist/macosx/Info.plist.sc'
InfoPlistOutSM    = './dist/macosx/Info.plist.sm'

Uptodate          = 'gen_version.udt'


opts = GetoptLong.new(
  [ "--no-specialbuild", "-n", GetoptLong::NO_ARGUMENT],
  [ "--specialbuild",    "-s", GetoptLong::REQUIRED_ARGUMENT ]
) 



$RevisionTagSrc = `svnversion -c .`.chop
$RevisionTagSrc =~ /:?(\d+)\w*$/
$RevisionNr     = $1
$RevisionTagSrc =~ /:?(\d+\w*)$/
$RevisionTag    = $1
$Date           = Time.now.strftime("%A %d. %B %Y")

$Major = nil
$Minor = nil
$Patch = nil


$SpecialBuild     = "unset"
$SpecialBuildDesc = "n/a"


opts.each do |opt,arg|

  case opt
    when "--specialbuild"
    
      $SpecialBuild = true
      if arg.empty? then
        printf "--specialbuild expects an argument!\n"
      else
        $SpecialBuildDesc = arg
      end      
      
    when "--no-specialbuild"
      $SpecialBuild = false
    
    else
      printf "unknown option #{opt}!\n"

  end

end


##
## extract major, minor and patch version for creating VersionOutXml below.
##

IO.foreach( VersionTemplate ) {
  | line |
  
  if line.include? "#define SUBCOMMANDER_VER_MAJOR" then
    $Major = line[/\d+/]
  end

  if line.include? "#define SUBCOMMANDER_VER_MINOR" then
    $Minor = line[/\d+/]
  end

  if line.include? "#define SUBCOMMANDER_VER_PATCH" then
    $Patch = line[/\d+/]
  end 
}

##
## display values..
##

printf "Date                     : '#{$Date}'\n"
printf "extracted RevisionNr     : '#{$RevisionNr}'\n"
printf "extracted RevisionTag    : 'r#{$RevisionTag}'\n"
printf "special build            : '#{$SpecialBuild}'\n"
if $SpecialBuild == true then
  printf "special build description: '#{$SpecialBuildDesc}'\n"
end
printf "Major Version            : '#{$Major}'\n"
printf "Minor Version            : '#{$Minor}'\n"
printf "Patch Version            : '#{$Patch}'\n"


##
## up todate check
##

udtnew = "r#{$RevisionTag} #{$SpecialBuild} #{$SpecialBuildDesc}\n"

if FileTest.exists?(Uptodate) then
  
  udt = File.new(Uptodate).gets
    
  if udt == udtnew then
    puts "\nversion info is up-to-date."
    exit
  end
end

puts "\nupdating version info.." 

File.new(Uptodate,"w").puts udtnew



##
## create Subcommander VersionOut
##

out = File.open( VersionOut, "w" )

IO.foreach( VersionTemplate ) {
  | line |

  # create VersionOut by reading VersionTemplate, substituing some values and writing
  # everything to VersionOut.

  line.sub!( /(#define SUBCOMMANDER_VER_REVISION +)\d+/,     '\1'"#{$RevisionNr}" )
  line.sub!( /(#define SUBCOMMANDER_VER_REVISION_TAG +)\S+/, '\1'"\"r#{$RevisionTag}\"" )
  line.sub!( /(#define SUBCOMMANDER_DATE +)\S+/,             '\1'"\"#{$Date}\"" )
  
  if $SpecialBuild == true then
    line.sub!( /(#define SUBCOMMANDER_SPECIALBUILD_DESCRIPTION +).+/, '\1'"\"#{$SpecialBuildDesc}\"" )
  elsif $SpecialBuild == false
    line.sub!( /(#define SUBCOMMANDER_SPECIALBUILD)/, '//\1' )
  end
  
  out.puts line
}

out.close


##
## create Subcommander guide VersionOutXml
##

File.open( VersionOutXml, "w" ) do |file|
  file.puts( 
    '<!-- automatically generated by gen_version.rb -->',
    '<!ENTITY sc.version "'"#{$Major}.#{$Minor}.#{$Patch}"'">',
    '<!ENTITY sc.revision "'"r#{$RevisionTag}"'">',
    '<!ENTITY sc.date "'"#{$Date}"'">'
  )
end


##
## prepare BuildDesc
##

#puts $SpecialBuild

if $SpecialBuild == true then
  $BuildDesc = " #{$SpecialBuildDesc}"
else
  $BuildDesc = ""
end


##
## create inno setup version.iss
##

File.open( "dist/win32/version.iss", "w" ) do |file|

  file.puts(
    '; automatically generated by gen_version.rb',
    'AppVerName=Subcommander '"#{$Major}.#{$Minor}.#{$Patch} (r#{$RevisionTag})#{$BuildDesc}"
  )
end


##
## create MacOSX Info.plist
##


## subcommander Info.plist

out = File.open( InfoPlistOutSC, "w" )

IO.foreach( InfoPlistTemplate ) {
  | line |

  # create the file by reading the template and substituting some values

  line.sub!( /SHORTNAME/, "sc" )
  line.sub!( /LONGNAME/, "subcommander" )
  line.sub!( /SHORTVERSION/, "#{$Major}.#{$Minor}.#{$Patch}" )
  line.sub!( /LONGVERSION/, "#{$Major}.#{$Minor}.#{$Patch} (r#{$RevisionTag})#{$BuildDesc}" )
  line.sub!( /SIGNATURE/, "SUBC" )
  
  out.puts line
}

out.close

## submerge Info.plist

out = File.open( InfoPlistOutSM, "w" )

IO.foreach( InfoPlistTemplate ) {
  | line |

  # create the file by reading the template and substituting some values

  line.sub!( /SHORTNAME/, "sm" )
  line.sub!( /LONGNAME/, "submerge" )
  line.sub!( /SHORTVERSION/, "#{$Major}.#{$Minor}.#{$Patch}" )
  line.sub!( /LONGVERSION/, "#{$Major}.#{$Minor}.#{$Patch} (r#{$RevisionTag})#{$BuildDesc}" )
  line.sub!( /SIGNATURE/, "SUBM" )
  
  out.puts line
}

out.close