// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


/*
  custom.cc
  This file contains code for the font and color selection dialog boxes
  of the StarPlot Options menu.
*/

#include <gtk/gtk.h>
#include "starplot.h"

using std::endl;
using std::string;

// custom_colors(): present a dialog box for choosing star colors
// void custom_colors() { /* XXX */ }

// font selector callback
void select_font( GtkWidget *w, GtkFontSelectionDialog * fs )
{
  globals::display_fontname = gtk_font_selection_dialog_get_font_name(fs);
  globals::program_viewer->setfont(globals::display_fontname);
  redraw_all (DECORATIONS_CHANGE);

  if (globals::program_hr_viewer) {
    globals::program_hr_viewer->setfont(globals::display_fontname);
    hr_redraw_display(globals::program_hr_canvas);
  }
}

void custom_font()
{
  GtkWidget *fontsel=gtk_font_selection_dialog_new(_("StarPlot: Select font"));
  gtk_window_set_modal (GTK_WINDOW (fontsel), true);
  g_signal_connect (G_OBJECT (fontsel), "destroy",
                    G_CALLBACK (gtk_widget_destroy),
                    GTK_WIDGET (fontsel));

  /* Connect the ok_button to the appropriate file selection function */
  g_signal_connect (G_OBJECT (GTK_FONT_SELECTION_DIALOG (fontsel)->ok_button),
                      "clicked", G_CALLBACK (select_font), fontsel);
  g_signal_connect_swapped (G_OBJECT (GTK_FONT_SELECTION_DIALOG
                                         (fontsel)->ok_button),
                             "clicked", G_CALLBACK (gtk_widget_destroy),
                             G_OBJECT (fontsel));

  /* Connect the cancel_button to destroy the widget */
  g_signal_connect_swapped (G_OBJECT (GTK_FONT_SELECTION_DIALOG
                                         (fontsel)->cancel_button),
                             "clicked", G_CALLBACK (gtk_widget_destroy),
                             G_OBJECT (fontsel));

  /* Set the highlighted font to be the current one */
  gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG (fontsel),
    globals::display_fontname.c_str());

  gtk_font_selection_dialog_set_preview_text
    (GTK_FONT_SELECTION_DIALOG (fontsel), "\316\262 Centauri");
  gtk_widget_show(fontsel);
}


