/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.parsers;

import edu.jhu.htm.core.Constraint;
import edu.jhu.htm.core.Convex;
import edu.jhu.htm.core.Domain;
import edu.jhu.htm.core.Vector3d;
import edu.jhu.htm.geometry.Chull;
import edu.jhu.htm.geometry.Circle;
import edu.jhu.htm.geometry.Rect;
import edu.jhu.htm.parsers.DomainParser;
import edu.jhu.htm.parsers.ParseException;
import edu.jhu.htm.parsers.XMLtags;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXxmlParser
extends DefaultHandler
implements DomainParser {
    Domain d = null;
    protected List points = null;
    protected Convex convex;
    protected double radius;

    public Domain parseFile(String string) throws ParseException, IOException {
        FileReader fileReader = new FileReader(string);
        return this.parse(fileReader);
    }

    public Domain parseString(String string) throws ParseException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.parse(stringReader);
    }

    public Domain parse(Reader reader) throws ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        SAXxmlParser sAXxmlParser = null;
        try {
            this.points = new ArrayList();
            this.d = new Domain();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            sAXxmlParser = this;
            xMLReader.setContentHandler(sAXxmlParser);
            xMLReader.setErrorHandler(sAXxmlParser);
            InputSource inputSource = new InputSource(bufferedReader);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new ParseException(sAXException.getMessage());
        }
        return this.d;
    }

    public void startDocument() {
        System.out.println("Starting parse");
    }

    public void endDocument() {
        System.out.println("Finished Parser");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        System.out.println("Start element: {" + string + "}" + string2);
        try {
            int n = XMLtags.getTag(string2);
            switch (n) {
                case 4: {
                    this.handlePoint(string, string2, string3, attributes);
                    break;
                }
                case 2: {
                    this.handleConstraint(string, string2, string3, attributes);
                    break;
                }
                case 1: {
                    this.handleConvex(string, string2, string3, attributes);
                    break;
                }
                case 5: {
                    this.handleRadius(string, string2, string3, attributes);
                }
            }
        }
        catch (ParseException parseException) {
            System.err.println(parseException);
        }
    }

    public void handleRadius(String string, String string2, String string3, Attributes attributes) {
        this.radius = SAXxmlParser.getDouble(string, "r", attributes);
    }

    public void handleConstraint(String string, String string2, String string3, Attributes attributes) {
        double d = SAXxmlParser.getDouble(string, "x", attributes);
        double d2 = SAXxmlParser.getDouble(string, "y", attributes);
        double d3 = SAXxmlParser.getDouble(string, "z", attributes);
        double d4 = SAXxmlParser.getDouble(string, "d", attributes);
        Constraint constraint = new Constraint(d, d2, d3, d4);
        this.convex.add(constraint);
    }

    public void handlePoint(String string, String string2, String string3, Attributes attributes) {
        double d = SAXxmlParser.getDouble(string, "ra", attributes);
        double d2 = SAXxmlParser.getDouble(string, "dec", attributes);
        Vector3d vector3d = new Vector3d(d, d2);
        this.points.add(vector3d);
    }

    public void handleConvex(String string, String string2, String string3, Attributes attributes) {
        boolean bl = false;
        this.convex = new Convex();
        this.d.add(this.convex);
    }

    public void endElement(String string, String string2, String string3) {
        try {
            int n = XMLtags.getTag(string2);
            switch (n) {
                case 6: {
                    this.handleRect(string, string2, string3);
                    break;
                }
                case 3: {
                    this.handleCircle(string, string2, string3);
                    break;
                }
                case 7: {
                    this.handleChull(string, string2, string3);
                }
            }
        }
        catch (ParseException parseException) {
            System.err.println(parseException);
        }
    }

    public void handleRect(String string, String string2, String string3) {
        int n = 0;
        Vector3d vector3d = (Vector3d)this.points.get(n++);
        Vector3d vector3d2 = (Vector3d)this.points.get(n++);
        this.points.clear();
        Rect rect = new Rect(vector3d.ra(), vector3d.dec(), vector3d2.ra(), vector3d2.dec());
        this.d.add(rect.getConvex());
    }

    public void handleCircle(String string, String string2, String string3) {
        int n = 0;
        Vector3d vector3d = (Vector3d)this.points.get(n++);
        this.points.clear();
        Circle circle = new Circle(vector3d.ra(), vector3d.dec(), this.radius);
        this.d.add(circle.getConvex());
    }

    public void handleChull(String string, String string2, String string3) {
        boolean bl = false;
        Chull chull = new Chull();
        Iterator iterator = this.points.iterator();
        while (iterator.hasNext()) {
            chull.add((Vector3d)iterator.next());
        }
        this.d.add(chull.getConvex());
        this.points.clear();
    }

    public static double getDouble(String string, String string2, Attributes attributes) {
        int n = attributes.getIndex(string, string2);
        if (n < 0) {
            n = attributes.getIndex(string, string2.toUpperCase());
        }
        double d = Double.parseDouble(attributes.getValue(n));
        return d;
    }

    public void characters(char[] cArray, int n, int n2) {
        System.out.print("Characters:    \"");
        int n3 = n;
        while (n3 < n + n2) {
            switch (cArray[n3]) {
                case '\\': {
                    System.out.print("\\\\");
                    break;
                }
                case '\"': {
                    System.out.print("\\\"");
                    break;
                }
                case '\n': {
                    System.out.print("\\n");
                    break;
                }
                case '\r': {
                    System.out.print("\\r");
                    break;
                }
                case '\t': {
                    System.out.print("\\t");
                    break;
                }
                default: {
                    System.out.print(cArray[n3]);
                }
            }
            ++n3;
        }
        System.out.print("\"\n");
    }

    static {
        if (System.getProperty("org.xml.sax.driver") == null) {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
        }
    }
}

