-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
function Indexes_Match (Target, Source : Dictionary.Symbol) return Boolean is
   Tgt_It, Src_It : Dictionary.Iterator;
   Ok             : Boolean;

   function Bounds_Match (Src_Sym, Tgt_Sym : Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   --#        in LexTokenManager.State;
   is
      function Upper_Bound_Matches (Src_Sym, Tgt_Sym : Dictionary.Symbol) return Boolean
      --# global in Dictionary.Dict;
      --#        in LexTokenManager.State;
      is
      begin
         return LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Dictionary.GetScalarAttributeValue (False, LexTokenManager.Last_Token, Src_Sym),
            Lex_Str2 => Dictionary.GetScalarAttributeValue (False, LexTokenManager.Last_Token, Tgt_Sym)) =
           LexTokenManager.Str_Eq;
      end Upper_Bound_Matches;

      --------------------

      function Lower_Bound_Matches (Src_Sym, Tgt_Sym : Dictionary.Symbol) return Boolean
      --# global in Dictionary.Dict;
      --#        in LexTokenManager.State;
      is
      begin
         return LexTokenManager.Lex_String_Case_Insensitive_Compare
           (Lex_Str1 => Dictionary.GetScalarAttributeValue (False, LexTokenManager.First_Token, Src_Sym),
            Lex_Str2 => Dictionary.GetScalarAttributeValue (False, LexTokenManager.First_Token, Tgt_Sym)) =
           LexTokenManager.Str_Eq;
      end Lower_Bound_Matches;

   begin -- Bounds_Match
      return Upper_Bound_Matches (Src_Sym => Src_Sym,
                                  Tgt_Sym => Tgt_Sym)
        and then Lower_Bound_Matches (Src_Sym => Src_Sym,
                                      Tgt_Sym => Tgt_Sym);
   end Bounds_Match;

begin -- Indexes_Match
   Ok     := True;
   Tgt_It := Dictionary.FirstArrayIndex (Target);
   Src_It := Dictionary.FirstArrayIndex (Source);
   while not Dictionary.IsNullIterator (Tgt_It) loop
      if not Bounds_Match (Src_Sym => Dictionary.CurrentSymbol (Src_It),
                           Tgt_Sym => Dictionary.CurrentSymbol (Tgt_It)) then
         Ok := False;
         exit;
      end if;
      Tgt_It := Dictionary.NextSymbol (Tgt_It);
      Src_It := Dictionary.NextSymbol (Src_It);
   end loop;
   return Ok;
end Indexes_Match;
