-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Debug;
with Dictionary;
with ExaminerConstants;
with Ada.Text_IO;

package body RelationAlgebra.Debug is

   ---------------
   -- Print_Rho --
   ---------------

   procedure Print_Rho (Msg     : in String;
                        Rho     : in RelationAlgebra.Relation;
                        TheHeap : in Heap.HeapRecord) is

      --# hide Print_Rho;
      ColIndex  : Natural;
      ColLdr    : RelationAlgebra.ColLeader;
      P         : RelationAlgebra.Pair;
      LaterItem : Boolean;

   begin
      Ada.Text_IO.Put_Line (Msg);
      ColLdr := RelationAlgebra.FirstColLeader (TheHeap, Rho);
      loop
         exit when ColLdr = NullColLdr;
         ColIndex := ColLdrIndex (TheHeap, ColLdr);
         Standard.Debug.Print_Sym_Raw (Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (ColIndex)));
         Ada.Text_IO.Put (" <-- ");

         LaterItem := False;
         P         := RelationAlgebra.FirstInCol (TheHeap, ColLdr);
         loop
            exit when P = NullPair;
            if LaterItem then
               Ada.Text_IO.Put (", ");
            end if;
            LaterItem := True;
            Standard.Debug.Print_Sym_Raw
              (Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (RelationAlgebra.RowValue (TheHeap, P))));
            P := RelationAlgebra.DownSuccr (TheHeap, P);
         end loop;
         Ada.Text_IO.New_Line;
         ColLdr := NextColLeader (TheHeap, ColLdr);
      end loop;
   end Print_Rho;

   --------------
   -- Print_Mu --
   --------------

   procedure Print_Mu (Msg     : in String;
                       Mu      : in RelationAlgebra.Relation;
                       TheHeap : in Heap.HeapRecord) is
      --# hide Print_Mu;
      ColIndex  : Natural;
      ColLdr    : ColLeader;
      P         : Pair;
      LaterItem : Boolean;

   begin
      Ada.Text_IO.Put_Line (Msg);
      ColLdr := FirstColLeader (TheHeap, Mu);
      loop
         exit when ColLdr = NullColLdr;
         ColIndex := ColLdrIndex (TheHeap, ColLdr);
         Standard.Debug.Print_Sym_Raw (Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (ColIndex)));
         Ada.Text_IO.Put (" <-- ");

         LaterItem := False;
         P         := FirstInCol (TheHeap, ColLdr);
         loop
            exit when P = NullPair;
            if LaterItem then
               Ada.Text_IO.Put (", ");
            end if;
            LaterItem := True;
            Ada.Text_IO.Put (Integer'Image (RowValue (TheHeap, P)));
            P := DownSuccr (TheHeap, P);
         end loop;
         Ada.Text_IO.New_Line;
         ColLdr := NextColLeader (TheHeap, ColLdr);
      end loop;
   end Print_Mu;

   ------------------
   -- Print_Lambda --
   ------------------

   procedure Print_Lambda (Msg     : in String;
                           Lambda  : in RelationAlgebra.Relation;
                           TheHeap : in Heap.HeapRecord) is
      --# hide Print_Lambda;
      ColIndex  : Natural;
      ColLdr    : ColLeader;
      P         : Pair;
      LaterItem : Boolean;

   begin
      Ada.Text_IO.Put_Line (Msg);
      ColLdr := FirstColLeader (TheHeap, Lambda);
      loop
         exit when ColLdr = NullColLdr;
         ColIndex := ColLdrIndex (TheHeap, ColLdr);
         Ada.Text_IO.Put (Integer'Image (ColIndex));
         Ada.Text_IO.Put (" <-- ");

         LaterItem := False;
         P         := FirstInCol (TheHeap, ColLdr);
         loop
            exit when P = NullPair;
            if LaterItem then
               Ada.Text_IO.Put (", ");
            end if;
            LaterItem := True;
            Standard.Debug.Print_Sym_Raw (Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (RowValue (TheHeap, P))));
            P := DownSuccr (TheHeap, P);
         end loop;
         Ada.Text_IO.New_Line;
         ColLdr := NextColLeader (TheHeap, ColLdr);
      end loop;
   end Print_Lambda;

end RelationAlgebra.Debug;
