8.2 Acordes

# Acordes

Sonic Pi soporta nombres de acordes que regresarán listas. Pruébalo:


```
play chord(:E3, :minor)
```

¡Ahora estamos en algo!. Eso se mira mucho mejor que listas crudas y 
es más fácil de leer para otros. ¿qué otros acordes soporta Sonic Pi?
Bueno, *muchos*. Prueba con estos:

* `chord(:E3, :m7)`
* `chord(:E3, :minor)`
* `chord(:E3, :dim7)`
* `chord(:E3, :dom7)`

## Arpegios

Podemos convertir acordes en arpegios con facilidad, gracias a la
función `play_pattern` :

```
play_pattern chord(:E3, :m7)
```

Ok, eso no fue tan divertido, se ejecutó muy despacio. `play_pattern` va
a tocar cada nota en la lista separada por una llamada a `sleep 1` entre
cada llamada a `play`. Podemos usar otra función `play_pattern_timed` 
para especificar nuestros propios tiempos y acelerar las cosas: 

```
play_pattern_timed chord(:E3, :m7), 0.25
```

Inclusive podemos pasar una lista de tiempos, los cuales serán tratados
como un círculo de tiempos:


```
play_pattern_timed chord(:E3, :m13), [0.25, 0.5]
```

Eso equivale a:

```
play 52
sleep 0.25
play 55
sleep 0.5
play 59
sleep 0.25
play 62
sleep 0.5
play 66
sleep 0.25
play 69
sleep 0.5
play 73
```

¿qué preferirías escribir?
