/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_COMPONENT_TOPOLOGY_POINTSETTOPOLOGYALGORITHMS_H
#define SOFA_COMPONENT_TOPOLOGY_POINTSETTOPOLOGYALGORITHMS_H

#include <sofa/core/componentmodel/topology/BaseTopology.h>
#include <sofa/helper/vector.h>
#include <sofa/defaulttype/VecTypes.h>
#include <sofa/defaulttype/RigidTypes.h>
#include <sofa/component/component.h>

namespace sofa
{

namespace component
{

namespace topology
{
	class PointSetTopologyContainer;

	class PointSetTopologyModifier;
    
	template < class DataTypes >
	class PointSetGeometryAlgorithms;

	/** A class that performs complex algorithms on a PointSet.
	*
	*/
	template<class DataTypes>
	class PointSetTopologyAlgorithms : public core::componentmodel::topology::TopologyAlgorithms
	{
		// no methods implemented yet
	public:

	  using core::componentmodel::topology::TopologyAlgorithms::sout;
	  using core::componentmodel::topology::TopologyAlgorithms::serr;
	  using core::componentmodel::topology::TopologyAlgorithms::sendl;
		PointSetTopologyAlgorithms()
		: TopologyAlgorithms()
		{}

		virtual ~PointSetTopologyAlgorithms() {}

		virtual void init();		

                virtual std::string getTemplateName() const
                {
                  return templateName(this);
                }

                static std::string templateName(const PointSetTopologyAlgorithms<DataTypes>* = NULL)
                {
                  return DataTypes::Name();
                }
	private:
		PointSetTopologyContainer*					m_container;
		PointSetTopologyModifier*					m_modifier;
		PointSetGeometryAlgorithms< DataTypes >*	m_geometryAlgorithms;
	};

#if defined(WIN32) && !defined(SOFA_COMPONENT_TOPOLOGY_POINTSETTOPOLOGYALGORITHMS_CPP)
#pragma warning(disable : 4231)
#ifndef SOFA_FLOAT
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Vec3dTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Vec2dTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Vec1dTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Rigid3dTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Rigid2dTypes>;
#endif

#ifndef SOFA_DOUBLE
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Vec3fTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Vec2fTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Vec1fTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Rigid3fTypes>;
extern template class SOFA_COMPONENT_TOPOLOGY_API PointSetTopologyAlgorithms<defaulttype::Rigid2fTypes>;
#endif
#endif

} // namespace topology

} // namespace component

} // namespace sofa

#endif // SOFA_COMPONENTS_POINTSETTOPOLOGYALGORITHMS_H
