//#define XERR
#include "loop.ih"

extern double g_age;

void Loop::intervalCancer(double screeningAge)
{
    // a self-detected tumor before the next screening: an interval cancer.

    d_tumor.intervalCancer();
    ++d_nIntervals[d_round];

    d_selfDetected = true;

//    d_tumor.characteristics(screeningAge);

        // treat the tumor and determine the death-age of the women
        // since the tumor is present, no need to call diameterCheck()
    addCost(treatmentCosts(d_tumor.selfDetectAge()));

    d_tumor.setDeathAge();
                                                        // natural death
    if (d_naturalDeathAge < d_tumor.deathAge())         // before cancer death
//    if (d_naturalDeathAge < d_tumor.selfDetectAge())     // natural death
    {
        g_log << "  ** intervalCancer. Case leaves: natural death "
                "before tumor death\n"; 
            //at age " <<
            //d_naturalDeathAge << '\n';
        setStatus(LEFT_DURING, d_naturalDeathAge);
    }
    else                                            // death by tumor
    {
        d_tumor.characteristics(d_tumor.selfDetectAge());
        g_log << 
        "  ** intervalCancer. Case leaves: self-detected  tumor at age " <<
            d_tumor.selfDetectAge() << 
            ", diam: " << d_tumor.diameter() << '\n';

        setStatus(TUMOR_DURING, d_tumor.deathAge());
    }
}


