#!/bin/sh

# Screader - screen reader for Linux install script.
# (C)1999 J. Lemmens

# Screader only works on Linux version 1.1.92 or later.

# Login as root for best results.
echo -e "\n\n-----------------------------------------------------------------"
if [ ! $LOGNAME = root ];then
   echo "Please change to user root."
   exit 1
fi

# Make a directory /opt/etc/screader.
test ! -d /opt && ln -s /usr/local /opt
test ! -d /opt/etc && mkdir /opt/etc
test ! -d /opt/etc/screader && mkdir /opt/etc/screader

# Copy all punctuation.?.sh and the tts files to /opt/etc/screader.
cp tts /opt/etc/screader
cp punctuation.1.sh.english /opt/etc/screader/punctuation.1.sh

# Place the manual in the man-directory.
gzip -9f screader.1
cp screader.1.gz /opt/man/man1

# Place the binary in the bin-directory and give it the set-user-id.
test ! -d /opt/bin && mkdir /opt/bin
cp screader /opt/bin
chmod u+s /opt/bin/screader

# Make vcs device.
# Script by Jakub Jelinek
#
if [ ! -e /dev/vcs0 ]; then
   I=0
   while [ $I -lt 10 ]; do
      mknod /dev/vcs$I c 7 $I
      chmod 622 /dev/vcs$I
      chown root.tty /dev/vcs$I
      mknod /dev/vcsa$I c 7 `expr $I + 128`
      chmod 622 /dev/vcsa$I
      chown root.tty /dev/vcsa$I
      I=`expr $I + 1`
   done
fi

# Place the say synth into /opt/bin.
# rsynth: version 1.13 1994/11/08
cp say /opt/bin

# number2ascii reads Arabic numerals from standard input and converts them
# into English or Dutch.
#
# The english version:
# Copyright (c) 1988, 1993, 1994
# The Regents of the University of California.
#
# The dutch version (C)1999 J. Lemmens
cp number2ascii /opt/bin

cat << EOF
The screader screen reader has been installed.
Now type screader to start the screen reader.

Screader can  be placed into the ~/.login file (for tcsh) or into
the ~/.profile (for sh) file for automatic startup of screadr. each time
you login.

Edit the /opt/etc/screader/tts file to let screader use your favorite
speech synthesizer.
EOF
