/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.reflection;

import info.monitorenter.util.TimeStampedValue;
import info.monitorenter.util.collections.IRingBuffer;
import info.monitorenter.util.collections.RingBufferArrayFast;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import javax.naming.directory.NoSuchAttributeException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRecorder
extends Thread {
    protected IRingBuffer<ObjectInspection> m_buffer = new RingBufferArrayFast<ObjectInspection>(100);
    protected EventListenerList m_changeListeners = new EventListenerList();
    protected Field[] m_fields;
    protected long m_interval;
    protected Object m_toinspect;

    public ObjectRecorder(Object toinspect, long interval) {
        this.m_interval = interval;
        this.m_toinspect = toinspect;
        this.setDaemon(true);
        this.m_fields = toinspect.getClass().getDeclaredFields();
        this.start();
    }

    public void addChangeListener(ChangeListener x) {
        this.m_changeListeners.add(ChangeListener.class, x);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectRecorder other = (ObjectRecorder)obj;
        if (this.m_buffer == null ? other.m_buffer != null : !this.m_buffer.equals(other.m_buffer)) {
            return false;
        }
        if (this.m_changeListeners == null ? other.m_changeListeners != null : !this.m_changeListeners.equals(other.m_changeListeners)) {
            return false;
        }
        if (!Arrays.equals(this.m_fields, other.m_fields)) {
            return false;
        }
        if (this.m_interval != other.m_interval) {
            return false;
        }
        return !(this.m_toinspect == null ? other.m_toinspect != null : !this.m_toinspect.equals(other.m_toinspect));
    }

    protected void fireChange() {
        ChangeEvent ce = new ChangeEvent(this);
        Object[] listeners = this.m_changeListeners.getListenerList();
        for (int i = listeners.length - 1; i >= 0; i -= 2) {
            ChangeListener cl = (ChangeListener)listeners[i];
            cl.stateChanged(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeStampedValue[] getAttributeHistory(String attributeName) throws NoSuchAttributeException {
        int attribindex = -1;
        for (int i = this.m_fields.length - 1; i >= 0; --i) {
            if (!this.m_fields[i].getName().equals(attributeName)) continue;
            attribindex = i;
            break;
        }
        if (attribindex == -1) {
            throw new NoSuchAttributeException("The Attribute with the name: " + attributeName + " does not exist in " + this.m_toinspect.getClass().getName());
        }
        int stop = this.m_buffer.size();
        TimeStampedValue[] ret = new TimeStampedValue[stop];
        IRingBuffer<ObjectInspection> iRingBuffer = this.m_buffer;
        synchronized (iRingBuffer) {
            for (ObjectInspection tmp : this.m_buffer) {
                int i = 0;
                ret[i++] = new TimeStampedValue(tmp.getTime(), tmp.get(attribindex));
            }
        }
        return ret;
    }

    public String[] getAttributeNames() {
        String[] ret = new String[this.m_fields.length];
        for (int i = 0; i < this.m_fields.length; ++i) {
            ret[i] = this.m_fields[i].getName();
        }
        return ret;
    }

    public Object getInspected() {
        return this.m_toinspect;
    }

    public TimeStampedValue getLastValue(String fieldname) throws NoSuchAttributeException {
        int attribindex = -1;
        for (int i = this.m_fields.length - 1; i >= 0; --i) {
            if (!this.m_fields[i].getName().equals(fieldname)) continue;
            attribindex = i;
            break;
        }
        if (attribindex == -1) {
            throw new NoSuchAttributeException("The Attribute with the name: " + fieldname + " does not exist in " + this.m_toinspect.getClass().getName());
        }
        ObjectInspection tmp = this.m_buffer.getYoungest();
        return new TimeStampedValue(tmp.getTime(), tmp.get(attribindex));
    }

    public IRingBuffer<ObjectInspection> getRingBuffer() {
        return this.m_buffer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_buffer == null ? 0 : this.m_buffer.hashCode());
        result = 31 * result + (this.m_changeListeners == null ? 0 : this.m_changeListeners.hashCode());
        result = 31 * result + Arrays.hashCode(this.m_fields);
        result = 31 * result + (int)(this.m_interval ^ this.m_interval >>> 32);
        result = 31 * result + (this.m_toinspect == null ? 0 : this.m_toinspect.hashCode());
        return result;
    }

    public void inspect() {
        ObjectInspection newentry = new ObjectInspection();
        for (Field mField : this.m_fields) {
            try {
                mField.setAccessible(true);
                newentry.add(mField.get(this.m_toinspect));
            }
            catch (IllegalAccessException e) {
                String fieldname = mField.getName();
                char[] fieldnm = fieldname.toCharArray();
                fieldnm[0] = Character.toUpperCase(fieldnm[0]);
                fieldname = new String(fieldnm);
                String methodname = new StringBuffer("get").append(fieldname).toString();
                try {
                    Method toinvoke = this.m_toinspect.getClass().getDeclaredMethod(methodname, new Class[0]);
                    newentry.add(toinvoke.invoke(this.m_toinspect, new Object[0]));
                }
                catch (NoSuchMethodException toinvoke) {
                }
                catch (SecurityException g) {
                    g.printStackTrace();
                }
                catch (IllegalAccessException h) {
                    h.printStackTrace();
                }
                catch (InvocationTargetException l) {
                    l.printStackTrace();
                }
            }
        }
        this.m_buffer.add(newentry);
        this.fireChange();
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.m_interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.inspect();
        }
    }

    public void setHistoryLength(int length) {
        this.m_buffer.setBufferSize(length);
    }

    public void setInterval(long sleeptime) {
        this.m_interval = sleeptime;
    }

    @Override
    public String toString() {
        return this.m_buffer.toString();
    }

    public final class ObjectInspection {
        protected long m_time = new Date().getTime();
        private final LinkedList<Object> m_values = new LinkedList();

        protected ObjectInspection() {
        }

        protected void add(Object value) {
            this.m_values.add(value);
        }

        public Object get(int index) {
            return this.m_values.get(index);
        }

        public long getTime() {
            return this.m_time;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("\nObjectInspection:\n");
            ret.append("-----------------\n");
            ret.append("Inspected: ").append(ObjectRecorder.this.getInspected().toString()).append("\n");
            ret.append("time:      ").append(this.m_time).append("\n");
            for (int i = ObjectRecorder.this.m_fields.length - 1; i >= 0; --i) {
                ret.append(ObjectRecorder.this.m_fields[i].getName()).append(": ").append(this.m_values.get(i).toString()).append("\n");
            }
            return ret.toString();
        }
    }
}

