QuTiP: Quantum Toolbox in Python
================================

[A. Pitchford](http://github.com/ajgpitch), [C. Granade](http://github.com/cgranade), [A. Grimsmo](http://github.com/arnelg), [P. D. Nation](http://github.com/nonhermitian), and [J. R. Johansson](http://github.com/jrjohansson)

QuTiP is open-source software for simulating the dynamics of closed and open
quantum systems. The QuTiP library uses the excellent Numpy, Scipy, and Cython packages as numerical backend, and graphical output is provided by Matplotlib. QuTiP aims to provide user-friendly and efficient numerical simulations of a wide
variety of quantum mechanical problems, including those with Hamiltonians
and/or collapse operators with arbitrary time-dependence, commonly found in a
wide range of physics applications. QuTiP is freely available for use and/or
modification, and it can be used on all Unix-based platforms and on Windows.
Being free of any licensing fees, QuTiP is ideal for exploring quantum
mechanics in research as well as in the classroom.

Build status and test coverage
------------------------------

[![build-status](https://secure.travis-ci.org/qutip/qutip.svg?branch=master)](http://travis-ci.org/qutip/qutip)
[![Coverage Status](https://img.shields.io/coveralls/qutip/qutip.svg)](https://coveralls.io/r/qutip/qutip)
[![Maintainability](https://api.codeclimate.com/v1/badges/df502674f1dfa1f1b67a/maintainability)](https://codeclimate.com/github/qutip/qutip/maintainability)

Download
--------
[![Anaconda-Server Badge](https://anaconda.org/conda-forge/qutip/badges/downloads.svg)](https://anaconda.org/conda-forge/qutip)

The official releases of QuTiP can be downloaded at:

[http://qutip.org/download.html](http://qutip.org/download.html)


Installation
------------

For instructions on how to install QuTiP, see:

[http://qutip.org/docs/latest/installation.html](http://qutip.org/docs/latest/installation.html)


Demos
-----
A selection of demonstration notebooks is available here: [![Binder](http://img.shields.io/badge/launch-binder-ff69b4.svg?style=flat)](http://mybinder.org/repo/qutip/qutip-notebooks)

or may be found at: [github.com/qutip/qutip-notebooks](http://github.com/qutip/qutip-notebooks).


Documentation
-------------

The documentation for official releases, in HTML and PDF formats, are available at:

[http://qutip.org/documentation.html](http://qutip.org/documentation.html)

and the development documentation is available at [github.com/qutip/qutip-doc](http://github.com/qutip/qutip-doc).

Contribute
----------

You are most welcome to contribute to QuTiP development by forking this
repository and sending pull requests, or filing bug reports at the
[issues page](http://github.com/qutip/qutip/issues), or send us bug reports,
questions, or your proposed changes to our
[QuTiP discussion group](http://groups.google.com/group/qutip).

All contributions are acknowledged in the
[contributors](http://github.com/qutip/qutip-doc/blob/master/contributors.rst)
section in the documentation.

Note that all contributions must adhere to the [PEP 8 -- Style Guide for Python Code](https://www.python.org/dev/peps/pep-0008/).

For more information, including technical advice, please see [Contributing to QuTiP development](https://github.com/qutip/qutip-doc/blob/master/qutip_dev_contrib.md).

Changelog
---------

For release notes and a change log, see the
[changelog](http://github.com/qutip/qutip-doc/blob/master/changelog.rst)
section in the documentation.

License
-------
[![license](https://img.shields.io/badge/license-New%20BSD-blue.svg)](http://en.wikipedia.org/wiki/BSD_licenses#3-clause_license_.28.22Revised_BSD_License.22.2C_.22New_BSD_License.22.2C_or_.22Modified_BSD_License.22.29)

You are free to use this software, with or without modification, provided that the conditions listed in the LICENSE.txt file are satisfied.
