/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKECAMERAFLASHCONTROL_H
#define FAKECAMERAFLASHCONTROL_H

#include <QCameraFlashControl>

class FakeCameraService;

class FakeCameraFlashControl : public QCameraFlashControl
{
public:
    FakeCameraFlashControl(FakeCameraService *service, QObject *parent = 0);

    QCameraExposure::FlashModes flashMode() const;
    bool isFlashModeSupported(QCameraExposure::FlashModes mode) const;
    bool isFlashReady() const;
    void setFlashMode(QCameraExposure::FlashModes mode);

private:
    FakeCameraService *m_service;
    QCameraExposure::FlashModes m_mode;
};

#endif // FAKECAMERAFLASHCONTROL_H
