/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "addchanneldialog.h"

#include <QLayout>

AddChannelDlg::AddChannelDlg(QWidget *parent)
 : QDialog(parent)
{
  QGridLayout* grid = new QGridLayout(this);
  m_okBtn           = new QPushButton(this);
  m_cancelBtn       = new QPushButton(this);
  m_editChannelName = new QLineEdit  (this);
  m_lab             = new QLabel     (this);

  grid->addWidget(m_lab             , 0, 0);
  grid->addWidget(m_editChannelName , 0, 1);
  grid->addWidget(m_okBtn           , 1, 0);
  grid->addWidget(m_cancelBtn       , 1, 1);

  setModal(false);

  connect(m_okBtn    , SIGNAL(clicked()), this, SLOT(setValues()));
  connect(m_cancelBtn, SIGNAL(clicked()), this, SLOT(reject   ()));

  retranslate();
}

void AddChannelDlg::setValues()
{
  hide();

  if(!m_editChannelName->text().isEmpty())
    emit dataAccepted(m_editChannelName->text());

  accept();
}

void AddChannelDlg::retranslate()
{
  setWindowTitle(tr("Add Channel"));
  m_okBtn     ->setText(tr("&Ok"    ));
  m_cancelBtn ->setText(tr("&Cancel"));
  m_lab       ->setText(tr("Channel's Name:"));
}
