#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(17282);
 script_version ("$Revision: 7591 $");
 script_tag(name:"risk_factor", value:"None");
 
 name = "vBulletin Detection";
 
 script_name(name);
 
 desc = "
This script detects whether vBulletin discussion forum is running 
on the remote host, and extracts its version if it is.

Risk factor : None";

 script_description(desc);
 
 summary = "Checks for the presence of vBulletin";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2005 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);


foreach d (make_list("/forum", cgi_dirs()))
{
 req = http_get(item:string(d, "/index.php"), port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if( res == NULL ) exit(0);
 res = egrep(pattern:" content=.vBulletin ", string:res, icase:TRUE);
 if( res )
 {

  if(strlen(dir)>0) {
    install=dir;
  } else {
    install=string("/");
  }    
			           
  vers = ereg_replace(pattern:".*vBulletin ([0-9.]+).*", string:res, replace:"\1", icase:TRUE);
  set_kb_item(name:string("www/", port, "/vBulletin"), value:string(vers," under ",install));
	      
  rep = "The remote host is running vBulletin " + vers + " under " + install;
  security_note(port:port, data:rep);
  exit(0);     
 }
} 
