SET(COIN_ROOT_DIR "" CACHE PATH "COIN root directory")

FIND_PATH(COIN_INCLUDE_DIR coin/CoinUtilsConfig.h
  HINTS ${COIN_ROOT_DIR}/include
)
FIND_LIBRARY(COIN_CBC_LIBRARY
  NAMES Cbc libCbc
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_CBC_SOLVER_LIBRARY
  NAMES CbcSolver libCbcSolver
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_CGL_LIBRARY
  NAMES Cgl libCgl
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_CLP_LIBRARY
  NAMES Clp libClp
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_COIN_UTILS_LIBRARY
  NAMES CoinUtils libCoinUtils
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_OSI_LIBRARY
  NAMES Osi libOsi
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_OSI_CBC_LIBRARY
  NAMES OsiCbc libOsiCbc
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_OSI_CLP_LIBRARY
  NAMES OsiClp libOsiClp
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_OSI_VOL_LIBRARY
  NAMES OsiVol libOsiVol
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_VOL_LIBRARY
  NAMES Vol libVol
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)

FIND_LIBRARY(COIN_ZLIB_LIBRARY
  NAMES z libz
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)
FIND_LIBRARY(COIN_BZ2_LIBRARY
  NAMES bz2 libbz2
  HINTS ${COIN_ROOT_DIR}/lib/coin
  HINTS ${COIN_ROOT_DIR}/lib
)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(COIN DEFAULT_MSG
  COIN_INCLUDE_DIR
  COIN_CBC_LIBRARY
  COIN_CBC_SOLVER_LIBRARY
  COIN_CGL_LIBRARY
  COIN_CLP_LIBRARY
  COIN_COIN_UTILS_LIBRARY
  COIN_OSI_LIBRARY
  COIN_OSI_CBC_LIBRARY
  COIN_OSI_CLP_LIBRARY
  # COIN_OSI_VOL_LIBRARY
  # COIN_VOL_LIBRARY
)

IF(COIN_FOUND)
  SET(COIN_INCLUDE_DIRS ${COIN_INCLUDE_DIR})
  SET(COIN_CLP_LIBRARIES "${COIN_CLP_LIBRARY};${COIN_COIN_UTILS_LIBRARY};${COIN_ZLIB_LIBRARY};${COIN_BZ2_LIBRARY}")
  IF(COIN_ZLIB_LIBRARY)
    SET(COIN_CLP_LIBRARIES "${COIN_CLP_LIBRARIES};${COIN_ZLIB_LIBRARY}")
  ENDIF(COIN_ZLIB_LIBRARY)
   IF(COIN_BZ2_LIBRARY)
    SET(COIN_CLP_LIBRARIES "${COIN_CLP_LIBRARIES};${COIN_BZ2_LIBRARY}")
  ENDIF(COIN_BZ2_LIBRARY)
  SET(COIN_CBC_LIBRARIES "${COIN_CBC_LIBRARY};${COIN_CBC_SOLVER_LIBRARY};${COIN_CGL_LIBRARY};${COIN_OSI_LIBRARY};${COIN_OSI_CBC_LIBRARY};${COIN_OSI_CLP_LIBRARY};${COIN_ZLIB_LIBRARY};${COIN_BZ2_LIBRARY};${COIN_CLP_LIBRARIES}")
  SET(COIN_LIBRARIES ${COIN_CBC_LIBRARIES})
ENDIF(COIN_FOUND)

MARK_AS_ADVANCED(
  COIN_INCLUDE_DIR
  COIN_CBC_LIBRARY
  COIN_CBC_SOLVER_LIBRARY
  COIN_CGL_LIBRARY
  COIN_CLP_LIBRARY
  COIN_COIN_UTILS_LIBRARY
  COIN_OSI_LIBRARY
  COIN_OSI_CBC_LIBRARY
  COIN_OSI_CLP_LIBRARY
  COIN_OSI_VOL_LIBRARY
  COIN_VOL_LIBRARY
  COIN_ZLIB_LIBRARY
  COIN_BZ2_LIBRARY
)

IF(COIN_FOUND)
  SET(LEMON_HAVE_LP TRUE)
  SET(LEMON_HAVE_MIP TRUE)
  SET(LEMON_HAVE_CLP TRUE)
  SET(LEMON_HAVE_CBC TRUE)
ENDIF(COIN_FOUND)
