/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PCIDevice.h"
#include "OpenDRIM_PCIDeviceAccess.h"

#include <iostream>

#define ToString(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value; os << endl
#define ToStringInt(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << (long) instance.value; os << endl
#define ToStringRef(name, value, condition) os << (string) "      " + name + (string) "="; instance.condition ? os << "NULL" : os << instance.value.toString(); os << endl
#define ToStringArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringArrayInt(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << (long) instance.value[i]; if (i < instance.value.size()-1) os << ","; } os << "]" << endl
#define ToStringRefArray(name, value, condition) os << (string) "      " + name + (string) "=["; for (size_t i = 0; i < instance.value.size(); i++) { os << instance.value[i].toString(); if (i < instance.value.size()-1) os << ","; } os << "]" << endl

ostream& operator<<(ostream& os, OpenDRIM_PCIDevice& instance) {
	os << "   [OpenDRIM_PCIDevice]" << endl;
	ToString("InstanceID", InstanceID, InstanceID_isNULL);
	ToString("Caption", Caption, Caption_isNULL);
	ToString("Description", Description, Description_isNULL);
	ToString("ElementName", ElementName, ElementName_isNULL);
	ToString("InstallDate", InstallDate, InstallDate_isNULL);
	ToString("Name", Name, Name_isNULL);
	ToStringArrayInt("OperationalStatus", OperationalStatus, OperationalStatus_isNULL);
	ToStringArray("StatusDescriptions", StatusDescriptions, StatusDescriptions_isNULL);
	ToString("Status", Status, Status_isNULL);
	ToStringInt("HealthState", HealthState, HealthState_isNULL);
	ToStringInt("CommunicationStatus", CommunicationStatus, CommunicationStatus_isNULL);
	ToStringInt("DetailedStatus", DetailedStatus, DetailedStatus_isNULL);
	ToStringInt("OperatingStatus", OperatingStatus, OperatingStatus_isNULL);
	ToStringInt("PrimaryStatus", PrimaryStatus, PrimaryStatus_isNULL);
	ToStringInt("EnabledState", EnabledState, EnabledState_isNULL);
	ToString("OtherEnabledState", OtherEnabledState, OtherEnabledState_isNULL);
	ToStringInt("RequestedState", RequestedState, RequestedState_isNULL);
	ToStringInt("EnabledDefault", EnabledDefault, EnabledDefault_isNULL);
	ToString("TimeOfLastStateChange", TimeOfLastStateChange, TimeOfLastStateChange_isNULL);
	ToStringArrayInt("AvailableRequestedStates", AvailableRequestedStates, AvailableRequestedStates_isNULL);
	ToStringInt("TransitioningToState", TransitioningToState, TransitioningToState_isNULL);
	ToString("SystemCreationClassName", SystemCreationClassName, SystemCreationClassName_isNULL);
	ToString("SystemName", SystemName, SystemName_isNULL);
	ToString("CreationClassName", CreationClassName, CreationClassName_isNULL);
	ToString("DeviceID", DeviceID, DeviceID_isNULL);
	ToString("PowerManagementSupported", PowerManagementSupported, PowerManagementSupported_isNULL);
	ToStringArrayInt("PowerManagementCapabilities", PowerManagementCapabilities, PowerManagementCapabilities_isNULL);
	ToStringInt("Availability", Availability, Availability_isNULL);
	ToStringInt("StatusInfo", StatusInfo, StatusInfo_isNULL);
	ToString("LastErrorCode", LastErrorCode, LastErrorCode_isNULL);
	ToString("ErrorDescription", ErrorDescription, ErrorDescription_isNULL);
	ToString("ErrorCleared", ErrorCleared, ErrorCleared_isNULL);
	ToStringArray("OtherIdentifyingInfo", OtherIdentifyingInfo, OtherIdentifyingInfo_isNULL);
	ToString("PowerOnHours", PowerOnHours, PowerOnHours_isNULL);
	ToString("TotalPowerOnHours", TotalPowerOnHours, TotalPowerOnHours_isNULL);
	ToStringArray("IdentifyingDescriptions", IdentifyingDescriptions, IdentifyingDescriptions_isNULL);
	ToStringArrayInt("AdditionalAvailability", AdditionalAvailability, AdditionalAvailability_isNULL);
	ToString("MaxQuiesceTime", MaxQuiesceTime, MaxQuiesceTime_isNULL);
	ToString("TimeOfLastReset", TimeOfLastReset, TimeOfLastReset_isNULL);
	ToStringInt("ProtocolSupported", ProtocolSupported, ProtocolSupported_isNULL);
	ToString("MaxNumberControlled", MaxNumberControlled, MaxNumberControlled_isNULL);
	ToString("ProtocolDescription", ProtocolDescription, ProtocolDescription_isNULL);
	ToStringInt("CommandRegister", CommandRegister, CommandRegister_isNULL);
	ToStringArrayInt("Capabilities", Capabilities, Capabilities_isNULL);
	ToStringArray("CapabilityDescriptions", CapabilityDescriptions, CapabilityDescriptions_isNULL);
	ToStringInt("DeviceSelectTiming", DeviceSelectTiming, DeviceSelectTiming_isNULL);
	ToStringInt("ClassCode", ClassCode, ClassCode_isNULL);
	ToStringInt("CacheLineSize", CacheLineSize, CacheLineSize_isNULL);
	ToStringInt("LatencyTimer", LatencyTimer, LatencyTimer_isNULL);
	ToStringInt("InterruptPin", InterruptPin, InterruptPin_isNULL);
	ToString("ExpansionROMBaseAddress", ExpansionROMBaseAddress, ExpansionROMBaseAddress_isNULL);
	ToString("SelfTestEnabled", SelfTestEnabled, SelfTestEnabled_isNULL);
	ToStringArray("BaseAddress", BaseAddress, BaseAddress_isNULL);
	ToStringInt("SubsystemID", SubsystemID, SubsystemID_isNULL);
	ToStringInt("SubsystemVendorID", SubsystemVendorID, SubsystemVendorID_isNULL);
	ToStringInt("MinGrantTime", MinGrantTime, MinGrantTime_isNULL);
	ToStringInt("MaxLatency", MaxLatency, MaxLatency_isNULL);
	ToStringInt("BusNumber", BusNumber, BusNumber_isNULL);
	ToStringInt("DeviceNumber", DeviceNumber, DeviceNumber_isNULL);
	ToStringInt("FunctionNumber", FunctionNumber, FunctionNumber_isNULL);
	ToStringInt("PCIDeviceID", PCIDeviceID, PCIDeviceID_isNULL);
	ToStringInt("VendorID", VendorID, VendorID_isNULL);
	ToStringInt("RevisionID", RevisionID, RevisionID_isNULL);
	os << "   [\\OpenDRIM_PCIDevice]" << endl;
	return os;
}

int main() {
	
	string errorMessage;

	int errorCode = PCI_OpenDRIM_PCIDevice_load(NULL, errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}

	cout << endl << "[enumInstances]" << endl;
	vector<OpenDRIM_PCIDevice> instances;
	
	errorCode = PCI_OpenDRIM_PCIDevice_retrieve(NULL, NULL, instances, NULL, errorMessage, "ei");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	vector<OpenDRIM_PCIDevice>::iterator it = instances.begin();
	for (; it != instances.end(); ++it) {
		cout << *it;
	}
	
	cout << "[\\enumInstances]" << endl;
	cout << endl << "[enumInstanceNames & getInstance]" << endl;
	
	instances.clear();
	errorCode = PCI_OpenDRIM_PCIDevice_retrieve(NULL, NULL, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	
	it = instances.begin();
	for (; it != instances.end(); ++it) {
		errorCode = PCI_OpenDRIM_PCIDevice_getInstance(NULL, NULL, *it, NULL, errorMessage);
		if (errorCode != OK) {
			cout << "ERROR " << errorCode << ": " << errorMessage << endl;
			return -1;
		}
		cout << *it;
	}
	
	cout << "[\\enumInstanceNames & getInstance]" << endl;
	cout << endl;

	errorCode = PCI_OpenDRIM_PCIDevice_unload(errorMessage);
	if (errorCode != OK) {
		cout << "ERROR " << errorCode << ": " << errorMessage << endl;
		return -1;
	}
	return 0;
}
