/*
-----------------------------------------------------------------------------
This source file is part of OGRE
(Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org/

Copyright (c) 2000-2013 Torus Knot Software Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/
#include "OgrePageContentCollection.h"
#include "OgrePageContentCollectionFactory.h"
#include "OgreStreamSerialiser.h"
#include "OgrePageContent.h"
#include "OgrePage.h"

namespace Ogre
{
	//---------------------------------------------------------------------
	const uint32 PageContentCollection::CHUNK_ID = StreamSerialiser::makeIdentifier("PGCC");
	const uint16 PageContentCollection::CHUNK_VERSION = 1;
	//---------------------------------------------------------------------
	PageContentCollection::PageContentCollection(PageContentCollectionFactory* creator)
		: mCreator(creator), mParent(0)
	{

	}
	//---------------------------------------------------------------------
	PageContentCollection::~PageContentCollection()
	{
		// don't call destroy(), we're not the final subclass
	}
	//---------------------------------------------------------------------
	PageManager* PageContentCollection::getManager() const
	{
		return mParent->getManager();
	}
	//---------------------------------------------------------------------
	const String& PageContentCollection::getType() const
	{
		return mCreator->getName();
	}
	//---------------------------------------------------------------------
	void PageContentCollection::_notifyAttached(Page* parent)
	{
		mParent = parent;
	}
	//---------------------------------------------------------------------
	SceneManager* PageContentCollection::getSceneManager() const
	{
		return mParent->getSceneManager();
	}	


}

