// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntPoly_ShapeSection_HeaderFile
#define _IntPoly_ShapeSection_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _IntPoly_SequenceOfSequenceOfPnt_HeaderFile
#include <IntPoly_SequenceOfSequenceOfPnt.hxx>
#endif
#ifndef _IntPoly_IndexedMapOfPnt_HeaderFile
#include <IntPoly_IndexedMapOfPnt.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;
class gp_Pnt;
class gp_Vec;
class TColgp_SequenceOfPnt;
class TopoDS_Edge;


//! determines the section between 2 triangulated shapes. <br>
//!          The section is a set of edges. <br>
class IntPoly_ShapeSection  {
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT   IntPoly_ShapeSection();
  
  Standard_EXPORT   IntPoly_ShapeSection(const TopoDS_Shape& S1,const TopoDS_Shape& S2);
  
  Standard_EXPORT     void Section() ;
  
  Standard_EXPORT     void Explore() ;
  //! determines if it exists, the intersection point between <br>
//!          the (S1,S2,S3) triangle and the edge pointed by V1 and V2. <br>
//!          Returns True if the triangle-triangle section is found. <br>
  Standard_EXPORT     Standard_Boolean Intersect(const gp_Pnt& S1,const gp_Pnt& S2,const gp_Pnt& S3,const gp_Vec& OS1,const gp_Vec& VS0,const gp_Vec& V1,const gp_Vec& V2,Standard_Real& h1,Standard_Real& h2,Standard_Real& ah1,Standard_Real& ah2) ;
  
  Standard_EXPORT     Standard_Boolean IsEqual(const gp_Pnt& Pt1,const gp_Pnt& Pt2) ;
  //! returns True if P is inside the (P1,P2,P3) triangle <br>
//!          N0 = P1P2 ^ P1P3 <br>
  Standard_EXPORT     Standard_Boolean IsInside(const gp_Pnt& P,const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3,const gp_Vec& N0) ;
  //! adds if necessary, myBegPoint in myMapBegPoint <br>
//!          and myEndPoint in  myMapEndPoint. <br>
  Standard_EXPORT     void InsertInMap() ;
  //! sees whether OldPnt and NewPnt begins or ends a section <br>
//!          created before and adds the 2 others points. <br>
//!          If not, creates a section <br>
  Standard_EXPORT     void Insert(const gp_Pnt& OldPnt,const gp_Pnt& ComPnt,const gp_Pnt& NewPnt) ;
  //! sees whether BegPnt or EndPnt begins or ends a section <br>
//!          created before, and returns the other point to continue <br>
//!          the construction <br>
//!          Returns 2 if the construction is 'Forward' <br>
//!          Returns 1 if the construction is 'Previous' <br>
//!          Returns 0 if not and creates a section <br>
  Standard_EXPORT     Standard_Integer Concat(const gp_Pnt& BegPnt,const gp_Pnt& EndPnt,gp_Pnt& OutPnt) ;
  //! sees whether Section begins or ends another one in  mySection, <br>
//!          from the rank 'Index' to the last one 'NbSection' <br>
  Standard_EXPORT     void ConcatSection(TColgp_SequenceOfPnt& Section,const Standard_Integer NbSection,const Standard_Integer Index) ;
  //! builds a section from Point in this way <br>
//!                       ___   ___   ___   ___ <br>
//!               Point--/__/--/__/--/__/--/__/---> <br>
  Standard_EXPORT     void ForwConstruction(const gp_Pnt& Point) ;
  //! builds a section from Point in this way <br>
//!                    ___   ___   ___   ___ <br>
//!               <---/__/--/__/--/__/--/__/--Point <br>
  Standard_EXPORT     void PrevConstruction(const gp_Pnt& Point) ;
  
  Standard_EXPORT     Standard_Integer NbEdges() ;
  //! builds an edge from a sequence of Pnt <br>
//!          this is a part of the whole section <br>
  Standard_EXPORT     TopoDS_Edge Edge(const Standard_Integer Index) ;





protected:





private:



TopoDS_Shape myShape1;
TopoDS_Shape myShape2;
IntPoly_SequenceOfSequenceOfPnt mySection;
IntPoly_IndexedMapOfPnt myMapBegPoints;
IntPoly_IndexedMapOfPnt myMapEndPoints;
gp_Pnt myBegPoint;
gp_Pnt myEndPoint;
Standard_Boolean myFirstTime;
Standard_Integer myCpt;
Standard_Integer myIndex;
Standard_Integer myNbEdges;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
