/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.chefproject.util.GCal;
import org.chefproject.util.TimeBreakdown;

public class Time
implements Cloneable,
Comparable {
    protected long m_millisecondsSince = 0L;
    protected static final TimeZone M_tz = TimeZone.getTimeZone("GMT");
    protected static final TimeZone M_tzl = TimeZone.getDefault();
    protected static final GCal M_GCal = GCal.getInstance(M_tz, 0, 0, 0, 0, 0, 0, 0);
    protected static final GCal M_GCall = GCal.getInstance(M_tzl, 0, 0, 0, 0, 0, 0, 0);
    public static final String LOCAL = "local";
    protected static final SimpleDateFormat M_fmtA;
    protected static final SimpleDateFormat M_fmtAl;
    protected static final SimpleDateFormat M_fmtB;
    protected static final SimpleDateFormat M_fmtBl;
    protected static final SimpleDateFormat M_fmtC;
    protected static final SimpleDateFormat M_fmtCl;
    protected static final SimpleDateFormat M_fmtD;
    protected static final SimpleDateFormat M_fmtDl;
    protected static final SimpleDateFormat M_fmtE;
    protected static final SimpleDateFormat M_fmtFl;

    protected Object clone() {
        Time obj = new Time(this.m_millisecondsSince);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time(String str) {
        Date d = null;
        SimpleDateFormat simpleDateFormat = M_fmtA;
        synchronized (simpleDateFormat) {
            ParsePosition pos = new ParsePosition(0);
            d = M_fmtA.parse(str, pos);
        }
        this.m_millisecondsSince = d.getTime();
    }

    public Time() {
        this.m_millisecondsSince = System.currentTimeMillis();
    }

    public Time(long l) {
        this.m_millisecondsSince = l;
    }

    public Time(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GCal cal = (GCal)M_GCal.clone();
        cal.set(year, month - 1, day, hour, minute, second, millisecond);
        this.m_millisecondsSince = cal.getTimeMs();
    }

    public Time(TimeBreakdown tb) {
        GCal cal = (GCal)M_GCal.clone();
        cal.set(tb.year, tb.month - 1, tb.day, tb.hour, tb.min, tb.sec, tb.ms);
        this.m_millisecondsSince = cal.getTimeMs();
    }

    public Time(String local, int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GCal cal = (GCal)M_GCall.clone();
        cal.set(year, month - 1, day, hour, minute, second, millisecond);
        this.m_millisecondsSince = cal.getTimeMs();
    }

    public Time(String local, TimeBreakdown tb) {
        GCal cal = (GCal)M_GCall.clone();
        cal.set(tb.year, tb.month - 1, tb.day, tb.hour, tb.min, tb.sec, tb.ms);
        this.m_millisecondsSince = cal.getTimeMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtA;
        synchronized (simpleDateFormat) {
            s = M_fmtA.format(new Date(this.getTime()));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringSql() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtE;
        synchronized (simpleDateFormat) {
            s = M_fmtE.format(new Date(this.getTime()));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringLocal() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtAl;
        synchronized (simpleDateFormat) {
            s = M_fmtAl.format(new Date(this.getTime()));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringGmtFull() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtB;
        synchronized (simpleDateFormat) {
            s = M_fmtB.format(new Date(this.getTime()));
        }
        s = this.fix(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringLocalFull() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtBl;
        synchronized (simpleDateFormat) {
            s = M_fmtBl.format(new Date(this.getTime()));
        }
        s = this.fix(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringGmtShort() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtC;
        synchronized (simpleDateFormat) {
            s = M_fmtC.format(new Date(this.getTime()));
        }
        s = this.fix(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringLocalShort() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtCl;
        synchronized (simpleDateFormat) {
            s = M_fmtCl.format(new Date(this.getTime()));
        }
        s = this.fix(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringGmtTime() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtC;
        synchronized (simpleDateFormat) {
            s = M_fmtC.format(new Date(this.getTime()));
        }
        s = this.fix(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringLocalTime() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtCl;
        synchronized (simpleDateFormat) {
            s = M_fmtCl.format(new Date(this.getTime()));
        }
        s = this.fix(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringLocalTime24() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtFl;
        synchronized (simpleDateFormat) {
            s = M_fmtFl.format(new Date(this.getTime()));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringGmtDate() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtD;
        synchronized (simpleDateFormat) {
            s = M_fmtD.format(new Date(this.getTime()));
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringLocalDate() {
        String s = null;
        SimpleDateFormat simpleDateFormat = M_fmtDl;
        synchronized (simpleDateFormat) {
            s = M_fmtDl.format(new Date(this.getTime()));
        }
        return s;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof Time) {
            equals = ((Time)obj).m_millisecondsSince == this.m_millisecondsSince;
        }
        return equals;
    }

    public int compareTo(Object o) {
        return this.m_millisecondsSince < ((Time)o).m_millisecondsSince ? -1 : (this.m_millisecondsSince > ((Time)o).m_millisecondsSince ? 1 : 0);
    }

    public void setTime(long l) {
        this.m_millisecondsSince = l;
    }

    public long getTime() {
        return this.m_millisecondsSince;
    }

    public boolean before(Time other) {
        return this.m_millisecondsSince < other.m_millisecondsSince;
    }

    public boolean after(Time other) {
        return this.m_millisecondsSince > other.m_millisecondsSince;
    }

    public Time makeClone() {
        return (Time)this.clone();
    }

    protected String fix(String s) {
        int len = s.length();
        if (s.charAt(len - 2) == 'P') {
            return s.substring(0, len - 2) + "pm";
        }
        return s.substring(0, len - 2) + "am";
    }

    public TimeBreakdown breakdownGmt() {
        String s = this.toString();
        TimeBreakdown b = new TimeBreakdown(Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(4, 6)), Integer.parseInt(s.substring(6, 8)), Integer.parseInt(s.substring(8, 10)), Integer.parseInt(s.substring(10, 12)), Integer.parseInt(s.substring(12, 14)), Integer.parseInt(s.substring(14)));
        return b;
    }

    public TimeBreakdown breakdownLocal() {
        String s = this.toStringLocal();
        TimeBreakdown b = new TimeBreakdown(Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(4, 6)), Integer.parseInt(s.substring(6, 8)), Integer.parseInt(s.substring(8, 10)), Integer.parseInt(s.substring(10, 12)), Integer.parseInt(s.substring(12, 14)), Integer.parseInt(s.substring(14)));
        return b;
    }

    static {
        LOCAL = LOCAL;
        M_fmtA = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        M_fmtAl = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        M_fmtB = new SimpleDateFormat("MMM d, yyyy h:mm aa");
        M_fmtBl = new SimpleDateFormat("MMM d, yyyy h:mm aa");
        M_fmtC = new SimpleDateFormat("h:mm aa");
        M_fmtCl = new SimpleDateFormat("h:mm aa");
        M_fmtD = new SimpleDateFormat("MMM d, yyyy");
        M_fmtDl = new SimpleDateFormat("MMM d, yyyy");
        M_fmtE = new SimpleDateFormat("yyyyMMddHHmmss");
        M_fmtFl = new SimpleDateFormat("HH:mm:ss");
        M_fmtA.setTimeZone(M_tz);
        M_fmtAl.setTimeZone(M_tzl);
        M_fmtB.setTimeZone(M_tz);
        M_fmtBl.setTimeZone(M_tzl);
        M_fmtC.setTimeZone(M_tz);
        M_fmtCl.setTimeZone(M_tzl);
        M_fmtD.setTimeZone(M_tz);
        M_fmtDl.setTimeZone(M_tzl);
        M_fmtE.setTimeZone(M_tz);
        M_fmtFl.setTimeZone(M_tzl);
    }
}

