<!-- Please do not edit this file. Edit the `blah` field in the `package.json` instead. If in doubt, open an issue. -->








[![git-url-parse](http://i.imgur.com/HlfMsVf.png)](#)











# git-url-parse

 [![Support me on Patreon][badge_patreon]][patreon] [![Buy me a book][badge_amazon]][amazon] [![PayPal][badge_paypal_donate]][paypal-donations] [![Ask me anything](https://img.shields.io/badge/ask%20me-anything-1abc9c.svg)](https://github.com/IonicaBizau/ama) [![Travis](https://img.shields.io/travis/IonicaBizau/git-url-parse.svg)](https://travis-ci.org/IonicaBizau/git-url-parse/) [![Version](https://img.shields.io/npm/v/git-url-parse.svg)](https://www.npmjs.com/package/git-url-parse) [![Downloads](https://img.shields.io/npm/dt/git-url-parse.svg)](https://www.npmjs.com/package/git-url-parse) [![Get help on Codementor](https://cdn.codementor.io/badges/get_help_github.svg)](https://www.codementor.io/johnnyb?utm_source=github&utm_medium=button&utm_term=johnnyb&utm_campaign=github)

<a href="https://www.buymeacoffee.com/H96WwChMy" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/yellow_img.png" alt="Buy Me A Coffee"></a>







> A high level git url parser for common git providers.

















## :cloud: Installation

```sh
# Using npm
npm install --save git-url-parse

# Using yarn
yarn add git-url-parse
```













## :clipboard: Example



```js
// Dependencies
const GitUrlParse = require("git-url-parse");

console.log(GitUrlParse("git@github.com:IonicaBizau/node-git-url-parse.git"));
// => {
//     protocols: []
//   , port: null
//   , resource: "github.com"
//   , user: "git"
//   , pathname: "/IonicaBizau/node-git-url-parse.git"
//   , hash: ""
//   , search: ""
//   , href: "git@github.com:IonicaBizau/node-git-url-parse.git"
//   , token: ""
//   , protocol: "ssh"
//   , toString: [Function]
//   , source: "github.com"
//   , name: "node-git-url-parse"
//   , owner: "IonicaBizau"
// }

console.log(GitUrlParse("https://github.com/IonicaBizau/node-git-url-parse.git"));
// => {
//     protocols: ["https"]
//   , port: null
//   , resource: "github.com"
//   , user: ""
//   , pathname: "/IonicaBizau/node-git-url-parse.git"
//   , hash: ""
//   , search: ""
//   , href: "https://github.com/IonicaBizau/node-git-url-parse.git"
//   , token: ""
//   , protocol: "https"
//   , toString: [Function]
//   , source: "github.com"
//   , name: "node-git-url-parse"
//   , owner: "IonicaBizau"
// }

console.log(GitUrlParse("https://github.com/IonicaBizau/git-url-parse/blob/master/test/index.js"));
// { protocols: [ 'https' ],
//   protocol: 'https',
//   port: null,
//   resource: 'github.com',
//   user: '',
//   pathname: '/IonicaBizau/git-url-parse/blob/master/test/index.js',
//   hash: '',
//   search: '',
//   href: 'https://github.com/IonicaBizau/git-url-parse/blob/master/test/index.js',
//   token: '',
//   toString: [Function],
//   source: 'github.com',
//   name: 'git-url-parse',
//   owner: 'IonicaBizau',
//   organization: '',
//   ref: 'master',
//   filepathtype: 'blob',
//   filepath: 'test/index.js',
//   full_name: 'IonicaBizau/git-url-parse' }

console.log(GitUrlParse("https://github.com/IonicaBizau/node-git-url-parse.git").toString("ssh"));
// => "git@github.com:IonicaBizau/node-git-url-parse.git"

console.log(GitUrlParse("git@github.com:IonicaBizau/node-git-url-parse.git").toString("https"));
// => "https://github.com/IonicaBizau/node-git-url-parse.git"
```











## :question: Get Help

There are few ways to get help:



 1. Please [post questions on Stack Overflow](https://stackoverflow.com/questions/ask). You can open issues with questions, as long you add a link to your Stack Overflow question.
 2. For bug reports and feature requests, open issues. :bug:
 3. For direct and quick help, you can [use Codementor](https://www.codementor.io/johnnyb). :rocket:





## :memo: Documentation


### `gitUrlParse(url)`
Parses a Git url.

#### Params

- **String** `url`: The Git url to parse.

#### Return
- **GitUrl** The `GitUrl` object containing:
 - `protocols` (Array): An array with the url protocols (usually it has one element).
 - `port` (null|Number): The domain port.
 - `resource` (String): The url domain (including subdomains).
 - `user` (String): The authentication user (usually for ssh urls).
 - `pathname` (String): The url pathname.
 - `hash` (String): The url hash.
 - `search` (String): The url querystring value.
 - `href` (String): The input url.
 - `protocol` (String): The git url protocol.
 - `token` (String): The oauth token (could appear in the https urls).
 - `source` (String): The Git provider (e.g. `"github.com"`).
 - `owner` (String): The repository owner.
 - `name` (String): The repository name.
 - `ref` (String): The repository ref (e.g., "master" or "dev").
 - `filepath` (String): A filepath relative to the repository root.
 - `filepathtype` (String): The type of filepath in the url ("blob" or "tree").
 - `full_name` (String): The owner and name values in the `owner/name` format.
 - `toString` (Function): A function to stringify the parsed url into another url type.
 - `organization` (String): The organization the owner belongs to. This is CloudForge specific.
 - `git_suffix` (Boolean): Whether to add the `.git` suffix or not.

### `stringify(obj, type)`
Stringifies a `GitUrl` object.

#### Params

- **GitUrl** `obj`: The parsed Git url object.
- **String** `type`: The type of the stringified url (default `obj.protocol`).

#### Return
- **String** The stringified url.














## :yum: How to contribute
Have an idea? Found a bug? See [how to contribute][contributing].


## :sparkling_heart: Support my projects
I open-source almost everything I can, and I try to reply to everyone needing help using these projects. Obviously,
this takes time. You can integrate and use these projects in your applications *for free*! You can even change the source code and redistribute (even resell it).

However, if you get some profit from this or just want to encourage me to continue creating stuff, there are few ways you can do it:


 - Starring and sharing the projects you like :rocket:
 - [![Buy me a book][badge_amazon]][amazon]—I love books! I will remember you after years if you buy me one. :grin: :book:
 - [![PayPal][badge_paypal]][paypal-donations]—You can make one-time donations via PayPal. I'll probably buy a ~~coffee~~ tea. :tea:
 - [![Support me on Patreon][badge_patreon]][patreon]—Set up a recurring monthly donation and you will get interesting news about what I'm doing (things that I don't share with everyone).
 - **Bitcoin**—You can send me bitcoins at this address (or scanning the code below): `1P9BRsmazNQcuyTxEqveUsnf5CERdq35V6`

    ![](https://i.imgur.com/z6OQI95.png)


Thanks! :heart:
















## :dizzy: Where is this library used?
If you are using this library in one of your projects, add it in this list. :sparkles:

 - `release-it`
 - `documentation`
 - `apollo`
 - `@backstage/backend-common`
 - `@plone/scripts`
 - `@atomist/automation-client`
 - `@storybook/storybook-deployer`
 - `@backstage/integration`
 - `@pvm/core`
 - `@kadira/storybook-deployer`
 - `workspace-tools`
 - `gatsby-source-git`
 - `@backstage/plugin-catalog-backend`
 - `@backstage/plugin-scaffolder-backend`
 - `@lerna-lite/core`
 - `umi-build-dev`
 - `@nuxt/telemetry`
 - `@era-ci/utils`
 - `@atomist/automation-client-ext-raven`
 - `git-source`
 - `semantic-release-gitmoji`
 - `@qiwi/semantic-release-gh-pages-plugin`
 - `@atomist/sdm-pack-analysis`
 - `apify-shared`
 - `@git-stack/server-core`
 - `remax-stats`
 - `strapi-generate-new`
 - `common-boilerplate`
 - `renovate`
 - `@backstage/plugin-techdocs-node`
 - `@instructure/ui-scripts`
 - `@s-ui/studio`
 - `@appworks/project-utils`
 - `@jswork/next-git-url`
 - `@umijs/block-sdk`
 - `@lerna/github-client`
 - `@micro-app/shared-utils`
 - `@oumi/block-sdk`
 - `@radjs/block-sdk`
 - `@wetrial/block-sdk`
 - `datoit-generate-new`
 - `@appirio/appirio`
 - `@backstage/plugin-techdocs`
 - `@log4brains/core`
 - `@xdn/cli`
 - `@atomist/skill`
 - `@zeplin/cli`
 - `@koumoul/gh-pages-multi`
 - `@pvm/gitlab`
 - `@backstage/plugin-scaffolder`
 - `@atomist/cli`
 - `@brisk-docs/gatsby-generator`
 - `@microservices/cli`
 - `@vamsikc/plugin-catalog`
 - `hzero-block-sdk`
 - `@spryker-lerna/github-client`
 - `gitbook-start-plugin-iaas-ull-es-noejaco2017`
 - `omg`
 - `clipped`
 - `fotingo`
 - `git-issues`
 - `@guardian/cdk`
 - `@stackbit/dev-common`
 - `lambda-service`
 - `octokit-downloader`
 - `stylelint-formatter-utils`
 - `sync-repos`
 - `copy-github-directory`
 - `@kevinbds/techdocs-common`
 - `docula-ui`
 - `@s-ui/mono`
 - `@facadecompany/ignition-ui`
 - `@focusworkstemp/project-utils`
 - `@git-stack/hemera-plugin`
 - `@jaredpalmer/workspace-tools`
 - `@unibtc/release-it`
 - `scaffolder-core`
 - `testarmada-midway`
 - `autorelease-setup`
 - `@geut/git-url-parse`
 - `sherry-utils`
 - `wiby`
 - `@erquhart/lerna-github-client`
 - `@oumi/cli-ui`
 - `changelog.md`
 - `@yarnpkg/plugin-git`
 - `@feizheng/next-git-url`
 - `@iceworks/project-utils`
 - `@hygiene/plugin-github-url`
 - `@0x-lerna-fork/github-client`
 - `@atomist/uhura`
 - `@pmworks/project-utils`
 - `@pubbo/github-client`
 - `@sanv/apify-shared`
 - `gcpayz-block-sdk`
 - `documentation-custom-markdown`
 - `generator-clearphp`
 - `@antv/gatsby-theme-antv`
 - `@scafflater/scafflater`
 - `@emedvedev/renovate`
 - `@dougkulak/semantic-release-gh-pages-plugin`
 - `@hemith/react-native-tnk`
 - `@hugomrdias/documentation`
 - `@buschtoens/documentation`
 - `@brisk-docs/website`
 - `@dandean/storybook-deployer`
 - `@lerna-test-v1/markdown`
 - `@merna/github-client`
 - `@jswork/topics2keywords`
 - `@pvdlg/semantic-release`
 - `@rianfowler/backstage-backend-common`
 - `auto-changelog-vsts`
 - `@deskbtm/workspace-tools`
 - `debone`
 - `cz-conventional-changelog-befe`
 - `create-apex-js-app`
 - `gatsby-source-git-remotes`
 - `gatsby-source-npmjs`
 - `flutter-boot`
 - `fster`
 - `gatsby-theme-zh`
 - `git-service-node`
 - `git-origin-check`
 - `git-yoink`
 - `harry-reporter`
 - `jsnix`
 - `kef-core`
 - `konitor`
 - `laborious`
 - `l-other-data`
 - `lime-cli`
 - `npm_one_1_2_3`
 - `miguelcostero-ng2-toasty`
 - `mdnext-loader`
 - `native-kakao-login`
 - `open-pull-request`
 - `rn-adyen-dropin`
 - `snipx`
 - `react-native-contact-list`
 - `react-native-biometric-authenticate`
 - `react-native-arunmeena1987`
 - `react-native-is7`
 - `react-native-my-first-try-arun-ramya`
 - `react-native-kakao-maps`
 - `react-native-ytximkit`
 - `vuepress-plugin-remote-url`
 - `@mmomtchev/documentation`
 - `spk`
 - `release-it-http`
 - `todo2issue`
 - `tooling-personal`
 - `tmplr`
 - `prep-barv11`
 - `gitlab-ci-variables-cli`
 - `gitbook-start-iaas-bbdd-alex-moi`
 - `gitbook-start-iaas-ull-es-merquililycony`
 - `gitc`
 - `lcov-server`
 - `gtni`
 - `belt-repo`
 - `@axetroy/gpm`
 - `@belt/repo`
 - `docula-ui-express`
 - `@geut/git-compare-template`
 - `cover-builder`
 - `@positionex/position-sdk`
 - `@cliz/gpm`
 - `@gasket/plugin-metrics`
 - `simple-github-release`
 - `@salla.sa/cli`
 - `ewizard-cli`
 - `@1coin178/github-compare`
 - `@arcanis/sherlock`
 - `@cilyn/bitbucket`
 - `@corelmax/react-native-my2c2p-sdk`
 - `@csmith/release-it`
 - `@esops/publish-github-pages`
 - `@felipesimmi/react-native-datalogic-module`
 - `@narfeta/catalog-backend`
 - `@hawkingnetwork/react-native-tab-view`
 - `@infinitecsolutions/storybook-deployer`
 - `@pipelinedoc/cli`
 - `ftl-renovate`
 - `gatsby-theme-cone`
 - `gatsby-theme-nestx`
 - `generate-github-directory`
 - `git-url-promise`
 - `git-observer`
 - `github-action-readme`
 - `coc-discord-rpc`
 - `@xyz/create-package`
 - `@theowenyoung/gatsby-source-git`
 - `@voodeng/uppacks`
 - `bitbucket-pullr`
 - `configorama`
 - `drowl-base-theme-iconset`
 - `dx-scanner`
 - `native-apple-login`
 - `react-native-cplus`
 - `npm_qwerty`
 - `patchanon-cli`
 - `pbc`
 - `wsj.gatsby-source-git`
 - `semantic-release-github-milestones`
 - `tldw`
 - `react-native-arunjeyam1987`
 - `publish-version`
 - `complan`
 - `@shopgate/pwa-releaser`
 - `def-core`
 - `pr-log`
 - `@geut/chan-parser`
 - `@evanpurkhiser/tooling-personal`
 - `react-native-bubble-chart`
 - `@blackglory/git-list`
 - `nmrium-cli`
 - `github-assistant`
 - `@tmplr/node`
 - `react-native-flyy`
 - `@react-18-pdf/root`
 - `@edgio/cli`
 - `@stackbit/cli`
 - `winx-form-winx`
 - `test-cli-tested1`
 - `@wekanteam/documentation`
 - `@campus-online/gatsby-source-git`
 - `@carrotwu/wcli`
 - `@cratosw/gatsby-antd`
 - `@cyber-tools/cyber-npm`
 - `@domestika/mono`
 - `@docomodigital/pdor`
 - `@apardellass/react-native-audio-stream`
 - `@amorist/gatsby-theme-antd`
 - `@1nd/documentation`
 - `@geeky-apo/react-native-advanced-clipboard`
 - `@git-stack/module-server`
 - `@lerna-test-v1/git`
 - `@voodeng/archive`
 - `@tjmonsi/generator-uplb-hci-lab-project-template`
 - `@tjmonsi/generator-project-template`
 - `@vicoders/cli2`
 - `@patrickhulce/scripts`
 - `@saad27/react-native-bottom-tab-tour`
 - `aral-vps-test`
 - `auto-clone`
 - `cirodown`
 - `candlelabssdk`
 - `canarist`
 - `@tagoro9/git`
 - `committing`
 - `detect-node-support`
 - `gatsby-theme-art-graph`
 - `gatsby-theme-cone-oc`
 - `github-books`
 - `git-upstream`
 - `@turborepo/workspace-tools`
 - `generator-bootstrap-boilerplate-template`
 - `git-imitate`
 - `just-dev-sdk`
 - `learning-journal-ci`
 - `meta-release`
 - `nixitech_cli`
 - `openapi-repo-generator`
 - `npm_one_12_34_1_`
 - `npm_one_2_2`
 - `payutesting`
 - `react-native-dsphoto-module`
 - `react-native-sayhello-module`
 - `react-native-responsive-size`
 - `sn-flutter-boot`
 - `wp-continuous-deployment`
 - `umi-plugin-repo`
 - `@axetroy/git-clone`
 - `branch-release`
 - `gatsby-theme-iot`
 - `documentation-markdown-themes`
 - `gd-cli`
 - `gitline`
 - `gitbook-start-iaas-ull-es-alex-moi`
 - `download-repo-cli`
 - `yarn-upgrade-on-ci`
 - `react-native-shekhar-bridge-test`
 - `react-feedback-sdk`
 - `@oiti/documentoscopy-react-native`
 - `@dvcorg/cml`
 - `semantic-release-telegram`
 - `@stagas/documentation-fork`
 - `@kb-sanity/proto-kb-plugin`
 - `@gogogosir/build-cli`
 - `generate-preview`
 - `@jupiterone/graph-checkmarx`
 - `@pvm/github`
 - `@pusdn/gatsby-theme-antv`
 - `@layer0/cli`
 - `@backstage/plugin-techdocs-module-addons-contrib`
 - `gatsby-theme-hansin`
 - `git-multi-profile`
 - `gitlab-tool-cli`
 - `luojia-cli-dev`
 - `mdxbook`
 - `myrenobatebot`
 - `node-norman`
 - `birken-react-native-community-image-editor`
 - `cetus-cli`
 - `@shushuer/cli`
 - `create-release-it`
 - `create-sourcegraph-extension`
 - `@activeviam/documentation`
 - `@hjin/generator-app`
 - `@hnp/package-scripts`
 - `@githubtraining/github-exercise-manager`
 - `@epranka/create-tsx-package`
 - `@elestu/actions-dependacop`
 - `@mayahq/mayadev`
 - `@pagedip/tool-autorelease`
 - `@stavalfi/ci`
 - `@kevinbds/plugin-techdocs`
 - `one-more-gitlab-cli`
 - `ogh`
 - `ci-yarn-upgrade`
 - `bibi`
 - `@wpbrothers/sbcli`
 - `ourbigbook`
 - `@alitajs/block-sdk`
 - `gitbook-start-https-alex-moi`
 - `mira`
 - `moto-connector`
 - `nodeschool-admin`
 - `ship-release`
 - `ssh-remote`
 - `strapper`
 - `@jfilipe-sparta/react-native-module_2`
 - `cc-flow`
 - `release2hub`
 - `cogoportutils`
 - `sinanews-flutter-boot`
 - `kube-workflow`
 - `airbyte-faros-destination`
 - `@rocket.chat/houston`
 - `@saleor/cli`
 - `@backstage/plugin-catalog-import`
 - `@cloudoki/donderflow`
 - `@epranka/create-package`
 - `@buganto/client`
 - `@cythral/renovate`
 - `@georgs/beachball`
 - `@generates/kdot`
 - `@bcgov/gatsby-source-github-raw`
 - `@atomist/ci-sdm`
 - `@limejs/cli`
 - `@makepad/puppeteer-cli`
 - `@mockswitch/cli`
 - `@rescribe/cli`
 - `@pubcore/node-docker-build`
 - `@reshiftsecurity/reshift-plugin-npm`
 - `@tahini/nc`
 - `@senti-techlabs/generator-senti-project-template`
 - `@whey/gatsby-theme-whey`
 - `@zpmpkg/zpm`
 - `@zalando-backstage/plugin-catalog`
 - `air-material_cli`
 - `actions-package-update`
 - `angularvezba`
 - `aral-server`
 - `astra-ufo-sdk`
 - `blog-flutter-boot`
 - `react-native-syan-photo-picker`
 - `@wecraftapps/react-native-use-keyboard`
 - `documentation-fork`
 - `documentation42`
 - `create-n`
 - `gatsby-source-github-raw`
 - `git-csv`
 - `git-cherry-fix`
 - `git-push-pr`
 - `kit-command`
 - `l2forlerna`
 - `next-mdx-books`











## :scroll: License

[MIT][license] © [Ionică Bizău][website]






[license]: /LICENSE
[website]: https://ionicabizau.net
[contributing]: /CONTRIBUTING.md
[docs]: /DOCUMENTATION.md
[badge_patreon]: https://ionicabizau.github.io/badges/patreon.svg
[badge_amazon]: https://ionicabizau.github.io/badges/amazon.svg
[badge_paypal]: https://ionicabizau.github.io/badges/paypal.svg
[badge_paypal_donate]: https://ionicabizau.github.io/badges/paypal_donate.svg
[patreon]: https://www.patreon.com/ionicabizau
[amazon]: http://amzn.eu/hRo9sIZ
[paypal-donations]: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=RVXDDLKKLQRJW
