/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Return a directory name.
*
* @module @stdlib/utils/dirname
*
* @example
* var dirname = require( '@stdlib/utils/dirname' );
*
* var dir = dirname( './foo/bar/index.js' );
* // returns './foo/bar'
*/

// MODULES //

var dirname = require( './dirname.js' );


// EXPORTS //

module.exports = dirname;
