/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#include <QFile>
#include <QTextStream>

#include <yf/random/random.hpp>

#include "Layout.hpp"

void Layout::read(const QString& path)
{
	QFile fin(path);
	if (!fin.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		qFatal("Cannot open layout file at %s", qPrintable(path));
	}
	QTextStream in(&fin);
	for (size_t i = 0; i < keyboardRowCount; ++i)
	{
		this->smallLetters[i] = in.readLine();
		this->bigLetters[i] = in.readLine();
	}
	this->layoutFortuneParam = in.readLine();
	fin.close();
	this->lastPath = path;
}

bool Layout::containsKey(QChar key) const
{
	if (key == QChar(' '))
	{
		// it's a space - answer is true :)
		return true;
	}

	for (size_t i = 0; i < keyboardRowCount; ++i)
	{
		if (smallLetters[i].contains(key) || bigLetters[i].contains(key))
		{
			return true;
		}
	}
	//qDebug("Layout %s doesn't contain key %s", qPrintable(lastPath), qPrintable(QString(key)));
	return false;
}

QChar Layout::getSmallChar(size_t row, int index) const
{
	Q_ASSERT(index < this->charsInRow(row));

	return smallLetters[row][index];
}

QChar Layout::getBigChar(size_t row, int index) const
{
	Q_ASSERT(index < this->charsInRow(row));

	return bigLetters[row][index];
}

int Layout::charsInRow(size_t row) const
{
	Q_ASSERT(row < keyboardRowCount);
	Q_ASSERT(smallLetters[row].size() == bigLetters[row].size());

	return smallLetters[row].size();
}

bool Layout::isAdmissibleFortune(const QString& text) const
{
	for (int i = 0; i < text.size(); ++i)
	{
		if (!this->containsKey(text[i]))
		{
			return false;
			break;
		}
	}
	return true;
}

QChar Layout::getRandomChar() const
{
	using namespace yf::random;

	const QString* const& string = (rnd_bool() ? this->smallLetters : this->bigLetters);
	byte row = rnd_uint16(keyboardRowCount);
	int pos = rnd_uint16(string[row].size());

	return string[row][pos];
}

QString Layout::getLayoutFortuneParam() const
{
	return layoutFortuneParam;
}
