/* pdu-dns.c
 
   PDU builder for DNS messages

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "pbuild-priv.h"
#include "pdu-dns.h"

/* Bit fields in the flags. From Wireshark's packet-dns.c */
#define F_RESPONSE	(1<<15)	    /* packet is response */
#define F_OPCODE	(0xF<<11)   /* query opcode */
#define OPCODE_SHIFT	11
#define F_AUTHORITATIVE	(1<<10)	    /* response is authoritative */
#define F_TRUNCATED	(1<<9)	    /* response is truncated */
#define F_RECDESIRED	(1<<8)	    /* recursion desired */
#define F_RECAVAIL	(1<<7)	    /* recursion available */
#define F_Z		(0x7<<6)    /* Z */
#define Z_SHIFT		4
#define F_RCODE		(0xF<<0)    /* reply code */

static void
build(const GNode *pdu, void *dest)
{
    struct dns_hdr *dns;
    uint16_t i, flags;
    char *ptr, *p1, *p2;
    uint16_t u16;
    void *field;

    dns = dest;

    u16 = htons( (field = _pb_pdata(pdu, "id") )
		 ? num_next(field) : (uint32_t) rand() );
    SSVAL(dns, offsetof(struct dns_hdr, id), u16);

    /*
     * Flags
     */
    flags = 0;
    if (_pb_pdata(pdu, "qr") ) flags |= F_RESPONSE;
    flags |= num_next(_pb_pdata(pdu, "opcode") ) << OPCODE_SHIFT;
    if (_pb_pdata(pdu, "aa") ) flags |= F_AUTHORITATIVE;
    if (_pb_pdata(pdu, "tc") ) flags |= F_TRUNCATED;
    if (_pb_pdata(pdu, "rd") ) flags |= F_RECDESIRED;
    if (_pb_pdata(pdu, "ra") ) flags |= F_RECAVAIL;
    flags |= num_next(_pb_pdata(pdu, "z") ) << Z_SHIFT;
    flags |= num_next(_pb_pdata(pdu, "rcode") );
    flags = htons(flags);
    SSVAL(dns, offsetof(struct dns_hdr, flags), flags);

#if 0
    u16 = htons(hdr_data->qdcount
	        ? num_next(hdr_data->qdcount) : hdr_data->nqueries);
    SSVAL(dns, offsetof(struct dns_hdr, qdcount), u16);

    u16 = htons(hdr_data->ancount
	        ? num_next(hdr_data->ancount) : hdr_data->nanswers);
    SSVAL(dns, offsetof(struct dns_hdr, ancount), u16);

    u16 = htons(hdr_data->nscount
	        ? num_next(hdr_data->nscount) : hdr_data->nnservers);
    SSVAL(dns, offsetof(struct dns_hdr, nscount), u16);

    u16 = htons(hdr_data->arcount
	        ? num_next(hdr_data->arcount) : hdr_data->nextrarrs);
    SSVAL(dns, offsetof(struct dns_hdr, arcount), u16);

    /*
     * Put queries in place.
     */
    for (ptr = dest + sizeof(*dns), i = 0; i < hdr_data->nqueries; i++) {
	/*
	 * Labels
	 */
	for (p1 = hdr_data->queries[i].qname;
	     *p1 && *p1 != '.' && (p2 = strchr(p1, '.') );
	     p1 = p2 + 1) {
	    *ptr++ = p2 - p1;
	    memcpy(ptr, p1, p2 - p1);
	    ptr += p2 - p1;
	}

	if (*p1 && *p1 != '.') {
	    *ptr++ = strlen(p1);
	    memcpy(ptr, p1, strlen(p1) );
	    ptr += strlen(p1);
	}

	*ptr++ = 0; /* zero length octet for the null label of the root */

	/*
	 * qtype
	 */
	u16 = htons(hdr_data->queries[i].qtype);
	SSVAL(ptr, 0, u16);
	ptr += sizeof(uint16_t);

	/*
	 * qclass
	 */
	u16 = htons(hdr_data->queries[i].qclass);
	SSVAL(ptr, 0, u16);
	ptr += sizeof(uint16_t);
    }
#endif
}

#if 0
static void
pdu_dnshdr_dumper(pdu_t *p, const char *prefix)
{
    struct dnshdr_options *hdr_data;

    hdr_data = p->header_data;

    printf("%s  Parameters:\n", prefix);
    printf("%s    ID: %s\n", prefix, num_info(hdr_data->id) );
    printf("%s    qdcount: %s\n", prefix, num_info(hdr_data->qdcount) );
    printf("%s    ancount: %s\n", prefix, num_info(hdr_data->ancount) );
    printf("%s    nscount: %s\n", prefix, num_info(hdr_data->nscount) );
    printf("%s    arcount: %s\n", prefix, num_info(hdr_data->arcount) );
}
#endif

static const pdu_t pdu_dns = {
    .name = "dns",
    .description = "DNS message",
    .documented_in = "RFC 1305",
    .len = -1,
    .fields = (field_t []) {
	{.name = "id", .type = PDU_FTYPE_NUMTYPE},
	{.name = "qr", .type = PDU_FTYPE_BIT},
	{.name = "opcode", .type = PDU_FTYPE_NUMTYPE},
	{.name = "aa", .type = PDU_FTYPE_BIT},
	{.name = "tc", .type = PDU_FTYPE_BIT},
	{.name = "rd", .type = PDU_FTYPE_BIT},
	{.name = "ra", .type = PDU_FTYPE_BIT},
	{.name = "z", .type = PDU_FTYPE_NUMTYPE},
	{.name = "rcode", .type = PDU_FTYPE_NUMTYPE},
	{.name = "qdcount", .type = PDU_FTYPE_NUMTYPE},
	{.name = "ancount", .type = PDU_FTYPE_NUMTYPE},
	{.name = "nscount", .type = PDU_FTYPE_NUMTYPE},
	{.name = "arcount", .type = PDU_FTYPE_NUMTYPE},
	{.name = NULL, .type = 0}
    },
    .build = &build
};

void
_pb_register_dns(void)
{
    _pb_register_protocol(&pdu_dns);
}
