/* nexp_pcap.c
  
   PCAP dumper and other PCAP-related functions.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <pcap.h>
#include "nexp_pbuild.h"
#include "nexp_speakers.h"

void
dump_pcap(pcb_t *pcb, unsigned char *packet, size_t packet_size)
{
    struct pcap_pkthdr h;

    gettimeofday(&h.ts, NULL);
    h.caplen = h.len = packet_size;

    /*
     * IMPORTANT: whatever we get gets written to the PCAP file as if it
     * were an Ethernet frame. This means that if p->id == PDU_IPV4, for
     * example, the packet written to the PCAP file won't make sense since
     * the IPv4 header would be interpreted as the Ethernet header. For this
     * reason, if you want to dump Layer 3 data to a PCAP file you must
     * precede it with an Ethernet PDU (ether). This also has the benefit
     * that you can basically copy and paste an Ethernet frame using a
     * raw payload and it'll be written properly to the PCAP file.
     */
    pcap_dump( (u_char *) pcb->speaker->_pcap.pdumper, &h, packet);
}
