/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * LoremIpsumPanel.java
 *
 * Created on 12-Feb-2010, 22:26:11
 */
package org.netbeans.modules.html.editor.codegen;

import java.util.List;

/**
 *
 * @author daniel
 */
public class LoremIpsumPanel extends javax.swing.JPanel {

    private List<String> paragraphs;
    private int[] wordCount;
    private int[] characterCount;

    /** Creates new form LoremIpsumPanel */
    public LoremIpsumPanel(List<String> paragraphs) {
        this.paragraphs = paragraphs;
        initCounts();
        initComponents();
        updateDisplayedCounts();
    }

    public List<String> getParagraphs() {
        return paragraphs.subList(0, (Integer) paragraphCountSpinner.getValue());
    }

    public String getTag() {
        return (String) separatedByComboBox.getSelectedItem();
    }

    private void initCounts() {
        characterCount = new int[paragraphs.size() + 1];
        wordCount = new int[paragraphs.size() + 1];
        characterCount[0] = 0;
        wordCount[0] = 0;
        for (int i = 1; i <= paragraphs.size(); ++i) {
            String paragraph = paragraphs.get(i - 1);
            characterCount[i] = characterCount[i - 1] + paragraph.length();
            wordCount[i] = wordCount[i - 1] + countWords(paragraph);
        }
    }

    private static int countWords(String text) {
        int words = 1;
        for (char c : text.toCharArray()) {
            if (c == ' ') {
                ++words;
            }
        }
        return words;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        paragraphCountLabel = new javax.swing.JLabel();
        paragraphCountSpinner = new javax.swing.JSpinner();
        wordCountLabel = new javax.swing.JLabel();
        characterCountLabel = new javax.swing.JLabel();
        wordCountTextField = new javax.swing.JTextField();
        characterCountTextField = new javax.swing.JTextField();
        separatedByLabel = new javax.swing.JLabel();
        separatedByComboBox = new javax.swing.JComboBox();

        setMinimumSize(new java.awt.Dimension(380, 220));
        setName("Form"); // NOI18N
        setPreferredSize(new java.awt.Dimension(400, 220));

        paragraphCountLabel.setLabelFor(paragraphCountSpinner);
        org.openide.awt.Mnemonics.setLocalizedText(paragraphCountLabel, org.openide.util.NbBundle.getMessage(LoremIpsumPanel.class, "LoremIpsumPanel.paragraphCountLabel.text")); // NOI18N
        paragraphCountLabel.setName("paragraphCountLabel"); // NOI18N

        paragraphCountSpinner.setModel(new javax.swing.SpinnerNumberModel(4, 1, 10, 1));
        paragraphCountSpinner.setName("paragraphCountSpinner"); // NOI18N
        paragraphCountSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                paragraphCountSpinnerStateChanged(evt);
            }
        });

        wordCountLabel.setText(org.openide.util.NbBundle.getMessage(LoremIpsumPanel.class, "LoremIpsumPanel.wordCountLabel.text")); // NOI18N
        wordCountLabel.setName("wordCountLabel"); // NOI18N

        characterCountLabel.setText(org.openide.util.NbBundle.getMessage(LoremIpsumPanel.class, "LoremIpsumPanel.characterCountLabel.text")); // NOI18N
        characterCountLabel.setName("characterCountLabel"); // NOI18N

        wordCountTextField.setColumns(5);
        wordCountTextField.setEditable(false);
        wordCountTextField.setName("wordCountTextField"); // NOI18N

        characterCountTextField.setColumns(5);
        characterCountTextField.setEditable(false);
        characterCountTextField.setName("characterCountTextField"); // NOI18N

        separatedByLabel.setLabelFor(separatedByComboBox);
        org.openide.awt.Mnemonics.setLocalizedText(separatedByLabel, org.openide.util.NbBundle.getMessage(LoremIpsumPanel.class, "LoremIpsumPanel.separatedByLabel.text")); // NOI18N
        separatedByLabel.setName("separatedByLabel"); // NOI18N

        separatedByComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "<p>", "<div>", "<span>" }));
        separatedByComboBox.setName("separatedByComboBox"); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(separatedByLabel)
                    .addComponent(wordCountLabel)
                    .addComponent(characterCountLabel)
                    .addComponent(paragraphCountLabel))
                .addGap(76, 76, 76)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(wordCountTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 119, Short.MAX_VALUE)
                    .addComponent(separatedByComboBox, 0, 119, Short.MAX_VALUE)
                    .addComponent(characterCountTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 119, Short.MAX_VALUE)
                    .addComponent(paragraphCountSpinner, javax.swing.GroupLayout.DEFAULT_SIZE, 119, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(20, 20, 20)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(paragraphCountLabel)
                    .addComponent(paragraphCountSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(separatedByLabel)
                    .addComponent(separatedByComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(wordCountLabel)
                    .addComponent(wordCountTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(characterCountLabel)
                    .addComponent(characterCountTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(63, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void paragraphCountSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_paragraphCountSpinnerStateChanged
        updateDisplayedCounts();
    }//GEN-LAST:event_paragraphCountSpinnerStateChanged

    private void updateDisplayedCounts() {
        Integer value = (Integer) paragraphCountSpinner.getValue();
        wordCountTextField.setText(Integer.toString(wordCount[value]));
        characterCountTextField.setText(Integer.toString(characterCount[value]));
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel characterCountLabel;
    private javax.swing.JTextField characterCountTextField;
    private javax.swing.JLabel paragraphCountLabel;
    private javax.swing.JSpinner paragraphCountSpinner;
    private javax.swing.JComboBox separatedByComboBox;
    private javax.swing.JLabel separatedByLabel;
    private javax.swing.JLabel wordCountLabel;
    private javax.swing.JTextField wordCountTextField;
    // End of variables declaration//GEN-END:variables
}
