/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.dynamic.container;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.AttributeNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.ReflectionException;
import org.helios.jmx.dynamic.AccessorPair;
import org.helios.jmx.dynamic.annotations.options.AttributeMutabilityOption;
import org.helios.jmx.dynamic.container.MBeanContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeContainer
extends MBeanContainer
implements Comparable<AttributeContainer>,
Serializable {
    private static final long serialVersionUID = -6272664974883231003L;
    protected MBeanAttributeInfo attributeInfo = null;
    protected Method targetSetterMethod = null;
    protected Method targetGetterMethod = null;
    protected boolean writeOnce = false;
    protected AttributeMutabilityOption mutability = null;
    protected boolean writen = false;
    protected String attributeName = null;
    protected static final Object[] NO_ARGS = new Object[0];

    public AttributeContainer() {
    }

    public AttributeContainer(AccessorPair ap) throws IntrospectionException {
        this(ap.getTargetObject(), new MBeanAttributeInfo(ap.getAttributeName(), ap.getDescription(), ap.getGetter(), ap.getSetter()), ap.getGetter(), ap.getSetter());
        this.mutability = ap.getMutability();
        this.writeOnce = this.mutability.compareTo(AttributeMutabilityOption.WRITE_ONCE) == 0;
    }

    public AttributeContainer(Object targetObject, MBeanAttributeInfo attributeInfo, Method targetGetterMethod, Method targetSetterMethod) {
        this.targetObject = targetObject;
        this.attributeInfo = attributeInfo;
        this.targetSetterMethod = targetSetterMethod;
        this.targetGetterMethod = targetGetterMethod;
        this.attributeName = attributeInfo.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttributeValue(Object newValue) throws AttributeNotFoundException, ReflectionException {
        if (this.targetSetterMethod == null) throw new AttributeNotFoundException("The attribute " + this.attributeName + " does not have a setter.");
        try {
            if (this.writeOnce && this.writen) {
                throw new AttributeNotFoundException("The attribute " + this.attributeName + " is WRITE_ONCE and has already been writen.");
            }
            this.targetSetterMethod.invoke(this.targetObject, newValue);
            if (!this.writeOnce) return;
            this.tripWriteOnce();
            return;
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Failed to call setter [" + this.targetSetterMethod.getName() + "] for attribute " + this.attributeName);
        }
    }

    public Object getAttributeValue() throws AttributeNotFoundException, ReflectionException {
        if (this.targetGetterMethod != null) {
            try {
                return this.targetGetterMethod.invoke(this.targetObject, NO_ARGS);
            }
            catch (Exception e) {
                throw new ReflectionException(e, "Failed to call getter [" + this.targetGetterMethod.getName() + "] for attribute " + this.attributeName);
            }
        }
        throw new AttributeNotFoundException("The attribute " + this.attributeName + " does not have a getter.");
    }

    public MBeanAttributeInfo getAttributeInfo() {
        return this.attributeInfo;
    }

    public void setAttributeInfo(MBeanAttributeInfo attributeInfo) {
        this.attributeInfo = attributeInfo;
        this.attributeName = attributeInfo.getName();
    }

    public Method getTargetGetterMethod() {
        return this.targetGetterMethod;
    }

    public void setTargetGetterMethod(Method targetGetterMethod) {
        this.targetGetterMethod = targetGetterMethod;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public Method getTargetSetterMethod() {
        return this.targetSetterMethod;
    }

    public void setTargetSetterMethod(Method targetSetterMethod) {
        this.targetSetterMethod = targetSetterMethod;
    }

    public boolean isWriteOnce() {
        return this.writeOnce;
    }

    public void setWriteOnce(boolean writeOnce) {
        this.writeOnce = writeOnce;
    }

    public boolean isWriten() {
        return this.writen;
    }

    public void setWriten(boolean writen) {
        this.writen = writen;
    }

    private void tripWriteOnce() {
        this.writen = true;
        try {
            this.attributeInfo = new MBeanAttributeInfo(this.attributeInfo.getName(), this.attributeInfo.getDescription(), this.targetGetterMethod, null);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Unexpected failure converting attribute to ReadOnly", e);
        }
    }

    public void resetWriteOnce() {
        if (this.writeOnce) {
            this.writen = false;
            try {
                this.attributeInfo = new MBeanAttributeInfo(this.attributeInfo.getName(), this.attributeInfo.getDescription(), this.targetGetterMethod, this.targetSetterMethod);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("Unexpected failure resetting attribute to WriteOnce", e);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeContainer other = (AttributeContainer)obj;
        return !(this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName));
    }

    public AttributeMutabilityOption getMutability() {
        return this.mutability;
    }

    public void setMutability(AttributeMutabilityOption mutability) {
        this.mutability = mutability;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public int compareTo(AttributeContainer ac) {
        return this.attributeName.compareTo(ac.getAttributeName());
    }
}

