/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#pragma once

#include "wf_button.h"

namespace MySQL {
  namespace Forms {

    public ref class CheckBoxImpl : public ButtonImpl
    {
      static bool create(mforms::CheckBox *self, bool square);
      static void click(System::Object ^sender, System::EventArgs ^e);
      static void set_active(mforms::CheckBox *self, bool flag);
      static bool get_active(mforms::CheckBox *self);

      CheckBoxImpl(mforms::CheckBox *cbox);

    public:
      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, mforms::CheckBox*, bool, mgr, f->_checkbox_impl, CheckBoxImpl, create);
        DEF_CALLBACK2(void, mforms::CheckBox*, bool, mgr, f->_checkbox_impl, CheckBoxImpl, set_active);
        DEF_CALLBACK1(bool, mforms::CheckBox*, mgr, f->_checkbox_impl, CheckBoxImpl, get_active);
      }
    };

  };
};
