# oggfile.py - read .ogg files into the library.

from musiclibrarian import genreset
import musiclibrarian.musicfile

import ogg.vorbis

class OggFile(musiclibrarian.musicfile.DictFile):
    """This class represents an Ogg file."""
    def __init__(self, library, fn, cache):
        self.fn=fn

        if cache == None:
            musiclibrarian.musicfile.DictFile.__init__(self, library, ogg.vorbis.VorbisFile(fn).comment().as_dict())
        else:
            musiclibrarian.musicfile.DictFile.__init__(self, library, cache)

    def write_to_file(self):
        """Write the comments back to the Vorbis file."""
        class FooExcept:
            """This class exists solely to work around a bug in past
            versions of pyvorbis."""
            def __init__(self):
                pass
        try:
            c=ogg.vorbis.VorbisComment(self.comments)

            # work around a pyvorbis bug by trashing exception information:
            raise FooExcept()
        except FooExcept:
            pass

        c.write_to(self.fn)

    def get_file(self):
        class VorbisWrapper:
            def __init__(self, vf):
                self.vf=vf

            def read(self, amt=-1):
                buf,amt,link=self.vf.read(amt)

                if amt == 0:
                    return None,0,0,16,0
                else:
                    info=self.vf.info(link)

                    return buf,amt,info.rate,16,info.channels
        try:
            return VorbisWrapper(ogg.vorbis.VorbisFile(self.fn))
        except:
            # Maybe it isn't present any more?
            return None

    def valid_genres(self):
        """All genres are valid for Vorbis files."""
        return genreset.GenreSet(True)

musiclibrarian.musicfile.register_file_type('ogg', OggFile)
