/*

  xmunipack - zoom

  Copyright © 2009-2012, 2018 F.Hroch (hroch@physics.muni.cz)

  This file is part of Munipack.

  Munipack is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Munipack is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.

*/


#include "fits.h"
#include <wx/wx.h>
#include <algorithm>

using namespace std;

// --- FitsZoom

// 8 items
const int FitsZoom::nratios  = 8;
const int FitsZoom::ratios[] ={-4,-2,1,2,3,4,6,8};


FitsZoom::FitsZoom(): shrink(1),zoom(0) {}

FitsZoom::FitsZoom(int s, int kind): shrink(1),zoom(0)
{
  if( kind == ZOOM_SHRINK ) {
    shrink = s;
    zoom = 0;
  }
  else if( kind == ZOOM_ZOOM ) {
    shrink = 0;
    zoom = s;
  }
}

FitsZoom::FitsZoom(const FitsZoom& other)
{
  shrink = other.shrink;
  zoom = other.zoom;
}

FitsZoom& FitsZoom::operator = (const FitsZoom& other)
{
  if( this != &other ) {
    shrink = other.shrink;
    zoom = other.zoom;
  }
  return *this;
}

int FitsZoom::GetKind() const
{
  if( shrink > 0 && zoom == 0 )
    return ZOOM_SHRINK;
  else if( shrink == 0 && zoom > 0 )
    return ZOOM_ZOOM;
  else
    return 0;
}

int FitsZoom::GetZoom() const { return zoom; }
int FitsZoom::GetShrink() const { return shrink; }

FitsZoom FitsZoom::GetOut() const
{
  int n = 1;
  if( GetKind() == ZOOM_SHRINK )
    n = shrink;
  else
    n = -zoom;

  for(int l = 0; l < nratios; l++)
    if( ratios[l] == n ) {
      int m = ratios[min(l+1,nratios-1)];
      if( m > 0 )
	return FitsZoom(m,ZOOM_SHRINK);
      else
	return FitsZoom(-m,ZOOM_ZOOM);
    }

  return FitsZoom(1,ZOOM_SHRINK);
}

FitsZoom FitsZoom::GetIn() const
{
  int n = 1;
  if( GetKind() == ZOOM_SHRINK )
    n = shrink;
  else
    n = -zoom;

  for(int l = 0; l < nratios; l++)
    if( ratios[l] == n ) {
      int m = ratios[max(l-1,0)];
      if( m > 0 )
	return FitsZoom(m,ZOOM_SHRINK);
      else
	return FitsZoom(-m,ZOOM_ZOOM);
    }

  return FitsZoom(1,ZOOM_SHRINK);
}
