/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntDeque;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.hash.IntHashFunction;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayDeque
extends AbstractIntCollection
implements IntDeque {
    public static final int DEFAULT_CAPACITY = 5;
    public int[] buffer;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;
    public final IntHashFunction hashFunction;

    public IntArrayDeque() {
        this(5);
    }

    public IntArrayDeque(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayDeque(int initialCapacity, ArraySizingStrategy resizer) {
        this(initialCapacity, resizer, new IntHashFunction());
    }

    public IntArrayDeque(int initialCapacity, ArraySizingStrategy resizer, IntHashFunction hashFunction) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        assert (hashFunction != null);
        this.hashFunction = hashFunction;
        this.resizer = resizer;
        initialCapacity = resizer.round(initialCapacity);
        this.buffer = new int[initialCapacity];
    }

    public IntArrayDeque(IntContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(int e1) {
        int h = IntArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = IntArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public void addFirst(int ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.addFirst(elements[i]);
        }
    }

    public final int addFirst(IntContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (IntCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    @Override
    public void addLast(int e1) {
        int t = IntArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = IntArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public void addLast(int ... elements) {
        this.ensureBufferSpace(1);
        for (int i = 0; i < elements.length; ++i) {
            this.addLast(elements[i]);
        }
    }

    public final int addLast(IntContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (IntCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    @Override
    public int removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        int result = this.buffer[this.head];
        this.buffer[this.head] = 0;
        this.head = IntArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public int removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = IntArrayDeque.oneLeft(this.tail, this.buffer.length);
        int result = this.buffer[this.tail];
        this.buffer[this.tail] = 0;
        return result;
    }

    @Override
    public int getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public int getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[IntArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirstOccurrence(int e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(int e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = IntArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLastOccurrence(int e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(int e1) {
        int bufLen = this.buffer.length;
        int last = IntArrayDeque.oneLeft(this.head, bufLen);
        int i = IntArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (e1 == this.buffer[i]) {
                return i;
            }
            i = IntArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAllOccurrences(int e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (e1 == this.buffer[from]) {
                this.buffer[from] = 0;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                to = IntArrayDeque.oneRight(to, bufLen);
            }
            from = IntArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        int[] b = this.buffer;
        int bufLen = b.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(b, head, b, head + 1, leftChunk);
            } else {
                System.arraycopy(b, 0, b, 1, index);
                b[0] = b[lastIndex];
                System.arraycopy(b, head, b, head + 1, lastIndex - head);
            }
            b[head] = 0;
            this.head = IntArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(b, index + 1, b, index, rightChunk);
            } else {
                System.arraycopy(b, index + 1, b, index, lastIndex - index);
                b[lastIndex] = b[0];
                System.arraycopy(b, 1, b, 0, tail);
            }
            b[tail] = 0;
            this.tail = IntArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, 0);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, 0);
            Arrays.fill(this.buffer, this.head, this.buffer.length, 0);
        }
        this.tail = 0;
        this.head = 0;
    }

    public void release() {
        this.tail = 0;
        this.head = 0;
        int size = this.resizer.round(5);
        this.buffer = new int[size];
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer == null ? 0 : this.buffer.length;
        int elementsCount = this.size();
        int requestedMinimum = 1 + elementsCount + expectedAdditions;
        if (requestedMinimum >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, elementsCount, expectedAdditions + 1);
            assert (newSize >= requestedMinimum) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            int[] newBuffer = new int[newSize];
            if (bufferLen > 0) {
                this.toArray(newBuffer);
                this.tail = elementsCount;
                this.head = 0;
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public int[] toArray() {
        int size = this.size();
        return this.toArray(new int[size]);
    }

    public int[] toArray(int[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    static final int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    static final int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<IntCursor> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(IntProcedure procedure, int fromIndex, int toIndex) {
        int[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = IntArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        int[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = IntArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends IntProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(IntProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = IntArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends IntPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(IntPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        int[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = IntArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(IntPredicate predicate) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(this.buffer[from])) {
                    this.buffer[from] = 0;
                    ++removed;
                } else {
                    if (to != from) {
                        this.buffer[to] = this.buffer[from];
                        this.buffer[from] = 0;
                    }
                    to = IntArrayDeque.oneRight(to, bufLen);
                }
                from = IntArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0;
                }
                to = IntArrayDeque.oneRight(to, bufLen);
                from = IntArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(int e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        int[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (e == buffer[i]) {
                return true;
            }
            i = IntArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        int[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + this.hashFunction.hash(this.buffer[i]);
            i = IntArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        IntDeque other;
        if (obj != null && obj instanceof IntDeque && (other = (IntDeque)obj).size() == this.size()) {
            int fromIndex = this.head;
            int[] buffer = this.buffer;
            int i = fromIndex;
            for (IntCursor c : other) {
                if (c.value != buffer[i]) {
                    return false;
                }
                i = IntArrayDeque.oneRight(i, buffer.length);
            }
            return true;
        }
        return false;
    }

    public static IntArrayDeque from(int ... elements) {
        IntArrayDeque coll = new IntArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    public static IntArrayDeque from(IntContainer container) {
        return new IntArrayDeque(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DescendingIterator
    implements Iterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int remaining;

        public DescendingIterator() {
            this.cursor.index = IntArrayDeque.this.tail;
            this.remaining = IntArrayDeque.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public IntCursor next() {
            if (this.remaining == 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            this.cursor.index = IntArrayDeque.oneLeft(this.cursor.index, IntArrayDeque.this.buffer.length);
            this.cursor.value = IntArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    implements Iterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = IntArrayDeque.oneLeft(IntArrayDeque.this.head, IntArrayDeque.this.buffer.length);
            this.remaining = IntArrayDeque.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public IntCursor next() {
            if (this.remaining == 0) {
                throw new NoSuchElementException();
            }
            --this.remaining;
            this.cursor.index = IntArrayDeque.oneRight(this.cursor.index, IntArrayDeque.this.buffer.length);
            this.cursor.value = IntArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

